/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tree;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.batch.BatchContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.invocation.Flag;
import org.infinispan.invocation.InvocationContextContainer;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.NodeKey;
import org.infinispan.tree.TreeStructureSupport;
import org.infinispan.util.Immutables;
import org.infinispan.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeImpl<K, V>
extends TreeStructureSupport
implements Node<K, V> {
    Fqn fqn;
    NodeKey dataKey;
    NodeKey structureKey;

    public NodeImpl(Fqn fqn, Cache cache, BatchContainer batchContainer, InvocationContextContainer icc) {
        super(cache, batchContainer, icc);
        this.fqn = fqn;
        this.dataKey = new NodeKey(fqn, NodeKey.Type.DATA);
        this.structureKey = new NodeKey(fqn, NodeKey.Type.STRUCTURE);
    }

    @Override
    public Node<K, V> getParent() {
        if (this.fqn.isRoot()) {
            return this;
        }
        return new NodeImpl<K, V>(this.fqn.getParent(), (Cache)this.cache, this.batchContainer, this.icc);
    }

    @Override
    public Node<K, V> getParent(Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Node<K, V>> getChildren() {
        this.startAtomic();
        try {
            HashSet<NodeImpl<K, V>> set = new HashSet<NodeImpl<K, V>>();
            for (Fqn f : this.getStructure().values()) {
                NodeImpl<K, V> n = new NodeImpl<K, V>(f, (Cache)this.cache, this.batchContainer, this.icc);
                set.add(n);
            }
            Set set2 = Immutables.immutableSetWrap(set);
            return set2;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Set<Node<K, V>> getChildren(Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.getChildren();
    }

    @Override
    public Set<Object> getChildrenNames() {
        return Immutables.immutableSetCopy((Set)this.getStructure().keySet());
    }

    @Override
    public Set<Object> getChildrenNames(Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.getChildrenNames();
    }

    @Override
    public Map<K, V> getData() {
        return Collections.unmodifiableMap(new HashMap<K, V>(this.getDataInternal()));
    }

    @Override
    public Map<K, V> getData(Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> getKeys() {
        this.startAtomic();
        try {
            Set<K> set = this.getData().keySet();
            return set;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Set<K> getKeys(Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.getKeys();
    }

    @Override
    public Fqn getFqn() {
        return this.fqn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node<K, V> addChild(Fqn f) {
        this.startAtomic();
        try {
            Fqn absoluteChildFqn = Fqn.fromRelativeFqn(this.fqn, f);
            NodeImpl<K, V> child = new NodeImpl<K, V>(absoluteChildFqn, (Cache)this.cache, this.batchContainer, this.icc);
            AtomicMap<Object, Fqn> s = this.getStructure();
            s.put(f.getLastElement(), (Object)absoluteChildFqn);
            this.createNodeInCache(absoluteChildFqn);
            NodeImpl<K, V> nodeImpl = child;
            return nodeImpl;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Node<K, V> addChild(Fqn f, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.addChild(f);
    }

    @Override
    public boolean removeChild(Fqn f) {
        return this.removeChild(f.getLastElement());
    }

    @Override
    public boolean removeChild(Fqn f, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.removeChild(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChild(Object childName) {
        this.startAtomic();
        try {
            AtomicMap<Object, Fqn> s = this.getStructure();
            Fqn childFqn = (Fqn)s.remove(childName);
            if (childFqn != null) {
                NodeImpl<K, V> child = new NodeImpl<K, V>(childFqn, (Cache)this.cache, this.batchContainer, this.icc);
                child.removeChildren();
                child.clearData();
                this.cache.remove((Object)new NodeKey(childFqn, NodeKey.Type.DATA));
                this.cache.remove((Object)new NodeKey(childFqn, NodeKey.Type.STRUCTURE));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public boolean removeChild(Object childName, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.removeChild(childName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node<K, V> getChild(Fqn f) {
        this.startAtomic();
        try {
            if (this.hasChild(f)) {
                NodeImpl<K, V> nodeImpl = new NodeImpl<K, V>(Fqn.fromRelativeFqn(this.fqn, f), (Cache)this.cache, this.batchContainer, this.icc);
                return nodeImpl;
            }
            Node<K, V> node = null;
            return node;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Node<K, V> getChild(Fqn f, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.getChild(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node<K, V> getChild(Object name) {
        this.startAtomic();
        try {
            if (this.hasChild(name)) {
                NodeImpl<K, V> nodeImpl = new NodeImpl<K, V>(Fqn.fromRelativeElements(this.fqn, name), (Cache)this.cache, this.batchContainer, this.icc);
                return nodeImpl;
            }
            Node<K, V> node = null;
            return node;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Node<K, V> getChild(Object name, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.getChild(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.startAtomic();
        try {
            Object object = this.getDataInternal().put(key, value);
            return (V)object;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public V put(K key, V value, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        this.startAtomic();
        try {
            AtomicMap<K, V> data = this.getDataInternal();
            if (!data.containsKey(key)) {
                Object object = data.put(key, value);
                return (V)object;
            }
            V v = null;
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public V putIfAbsent(K key, V value, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.putIfAbsent(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.startAtomic();
        try {
            AtomicMap<K, V> map = this.getDataInternal();
            if (map.containsKey(key)) {
                Object object = map.put(key, value);
                return (V)object;
            }
            V v = null;
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public V replace(K key, V value, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.replace(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.startAtomic();
        try {
            AtomicMap<K, V> data = this.getDataInternal();
            Object old = data.get(key);
            if (Util.safeEquals(oldValue, (Object)old)) {
                data.put(key, newValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.replace(key, oldValue, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.startAtomic();
        try {
            this.getDataInternal().putAll(map);
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        this.putAll(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAll(Map<? extends K, ? extends V> map) {
        this.startAtomic();
        try {
            AtomicMap<K, V> data = this.getDataInternal();
            data.clear();
            data.putAll(map);
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public void replaceAll(Map<? extends K, ? extends V> map, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        this.replaceAll(map);
    }

    @Override
    public V get(K key) {
        return this.getData().get(key);
    }

    @Override
    public V get(K key, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        this.startAtomic();
        try {
            Object object = this.getDataInternal().remove(key);
            return (V)object;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public V remove(K key, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.remove(key);
    }

    @Override
    public void clearData() {
        this.getDataInternal().clear();
    }

    @Override
    public void clearData(Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        this.clearData();
    }

    @Override
    public int dataSize() {
        return this.getData().size();
    }

    @Override
    public int dataSize(Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.dataSize();
    }

    @Override
    public boolean hasChild(Fqn f) {
        if (f.size() > 1) {
            Fqn absoluteFqn = Fqn.fromRelativeFqn(this.fqn, f);
            return this.exists(absoluteFqn);
        }
        return this.hasChild(f.getLastElement());
    }

    @Override
    public boolean hasChild(Fqn f, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.hasChild(f);
    }

    @Override
    public boolean hasChild(Object o) {
        return this.getStructure().containsKey(o);
    }

    @Override
    public boolean hasChild(Object o, Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        return this.hasChild(o);
    }

    @Override
    public boolean isValid() {
        return this.cache.containsKey((Object)this.dataKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChildren() {
        this.startAtomic();
        try {
            AtomicMap<Object, Fqn> s = this.getStructure();
            for (Object o : Immutables.immutableSetCopy(s.keySet())) {
                this.removeChild(o);
            }
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public void removeChildren(Flag ... flags) {
        ((InvocationContext)this.icc.get()).setFlags(flags);
        this.removeChildren();
    }

    AtomicMap<K, V> getDataInternal() {
        return this.cache.getAtomicMap((Object)this.dataKey);
    }

    AtomicMap<Object, Fqn> getStructure() {
        return this.cache.getAtomicMap((Object)this.structureKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeImpl node = (NodeImpl)o;
        return !(this.fqn != null ? !this.fqn.equals(node.fqn) : node.fqn != null);
    }

    public int hashCode() {
        return this.fqn != null ? this.fqn.hashCode() : 0;
    }

    public String toString() {
        return "NodeImpl{fqn=" + this.fqn + '}';
    }
}

