/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tree;

import java.util.Map;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.context.Flag;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.NodeImpl;
import org.infinispan.tree.NodeKey;
import org.infinispan.tree.NodeNotExistsException;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeStructureSupport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeCacheImpl<K, V>
extends TreeStructureSupport
implements TreeCache<K, V> {
    private static final Log log = LogFactory.getLog(TreeCacheImpl.class);
    private static final boolean trace = log.isTraceEnabled();

    public TreeCacheImpl(Cache<K, V> cache) {
        super(cache, ((AdvancedCache)cache).getBatchContainer(), ((AdvancedCache)cache).getInvocationContextContainer());
        this.assertBatchingSupported(cache.getConfiguration());
        this.createRoot();
    }

    @Override
    public Node<K, V> getRoot() {
        return new NodeImpl(Fqn.ROOT, (Cache)this.cache, this.batchContainer, this.icc);
    }

    @Override
    public Node<K, V> getRoot(Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.getRoot();
    }

    @Override
    public V put(String fqn, K key, V value) {
        return this.put(Fqn.fromString(fqn), key, value);
    }

    @Override
    public V put(String fqn, K key, V value, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.put(fqn, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Fqn fqn, Map<? extends K, ? extends V> data) {
        this.startAtomic();
        try {
            this.getNode(fqn).putAll(data);
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public void put(Fqn fqn, Map<? extends K, ? extends V> data, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        this.put(fqn, data);
    }

    @Override
    public void put(String fqn, Map<? extends K, ? extends V> data) {
        this.put(Fqn.fromString(fqn), data);
    }

    @Override
    public void put(String fqn, Map<? extends K, ? extends V> data, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        this.put(fqn, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Fqn fqn, K key) {
        this.startAtomic();
        try {
            AtomicMap map = this.cache.getAtomicMap((Object)new NodeKey(fqn, NodeKey.Type.DATA));
            Object object = map == null ? null : map.remove(key);
            return (V)object;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public V remove(Fqn fqn, K key, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.remove(fqn, key);
    }

    @Override
    public V remove(String fqn, K key) {
        return this.remove(Fqn.fromString(fqn), key);
    }

    @Override
    public V remove(String fqn, K key, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.remove(fqn, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNode(Fqn fqn) {
        boolean result;
        if (fqn.isRoot()) {
            return false;
        }
        this.startAtomic();
        try {
            Node<K, V> n;
            if (trace) {
                log.trace((Object)("About to remove node " + fqn));
            }
            result = (n = this.getNode(fqn.getParent())) != null && n.removeChild(fqn.getLastElement());
        }
        finally {
            this.endAtomic();
        }
        if (trace) {
            log.trace((Object)"Node successfully removed");
        }
        return result;
    }

    @Override
    public boolean removeNode(Fqn fqn, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.removeNode(fqn);
    }

    @Override
    public boolean removeNode(String fqn) {
        return this.removeNode(Fqn.fromString(fqn));
    }

    @Override
    public boolean removeNode(String fqn, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.removeNode(fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node<K, V> getNode(Fqn fqn) {
        this.startAtomic();
        try {
            if (this.exists(fqn)) {
                NodeImpl nodeImpl = new NodeImpl(fqn, (Cache)this.cache, this.batchContainer, this.icc);
                return nodeImpl;
            }
            Node<K, V> node = null;
            return node;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Node<K, V> getNode(Fqn fqn, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.getNode(fqn);
    }

    @Override
    public Node<K, V> getNode(String fqn) {
        return this.getNode(Fqn.fromString(fqn));
    }

    @Override
    public Node<K, V> getNode(String fqn, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.getNode(fqn);
    }

    @Override
    public V get(Fqn fqn, K key) {
        AtomicMap m = this.cache.getAtomicMap((Object)new NodeKey(fqn, NodeKey.Type.DATA));
        if (m == null) {
            return null;
        }
        return m.get(key);
    }

    @Override
    public V get(Fqn fqn, K key, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.get(fqn, key);
    }

    @Override
    public boolean exists(String f) {
        return this.exists(Fqn.fromString(f));
    }

    @Override
    public boolean exists(String fqn, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.exists(fqn);
    }

    @Override
    public boolean exists(Fqn fqn, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.exists(fqn);
    }

    @Override
    public V get(String fqn, K key) {
        return this.get(Fqn.fromString(fqn), key);
    }

    @Override
    public V get(String fqn, K key, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.get(fqn, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Fqn nodeToMoveFqn, Fqn newParentFqn) throws NodeNotExistsException {
        if (trace) {
            log.trace((Object)("Moving node '" + nodeToMoveFqn + "' to '" + newParentFqn + "'"));
        }
        if (nodeToMoveFqn == null || newParentFqn == null) {
            throw new NullPointerException("Cannot accept null parameters!");
        }
        if (nodeToMoveFqn.getParent().equals(newParentFqn)) {
            if (trace) {
                log.trace((Object)"Not doing anything as this node is equal with its parent");
            }
            return;
        }
        this.startAtomic();
        try {
            Node<K, V> nodeToMove = this.getNode(nodeToMoveFqn, Flag.FORCE_WRITE_LOCK);
            if (nodeToMove == null) {
                if (trace) {
                    log.trace((Object)"Did not find the node that needs to be moved. Returning...");
                }
                return;
            }
            if (!this.exists(newParentFqn)) {
                this.createNodeInCache(newParentFqn);
                if (trace) {
                    log.trace((Object)("The new parent (" + newParentFqn + ") did not exists, was created"));
                }
            }
            Fqn newFqn = Fqn.fromRelativeElements(newParentFqn, nodeToMoveFqn.getLastElement());
            this.createNodeInCache(newFqn);
            Node<K, V> newNode = this.getNode(newFqn);
            Map<K, V> oldData = nodeToMove.getData();
            if (oldData != null && !oldData.isEmpty()) {
                newNode.putAll(oldData);
            }
            for (Object child : nodeToMove.getChildrenNames()) {
                if (trace) {
                    log.trace((Object)("Moving child " + child));
                }
                Fqn oldChildFqn = Fqn.fromRelativeElements(nodeToMoveFqn, child);
                this.move(oldChildFqn, newFqn);
            }
            this.removeNode(nodeToMoveFqn);
        }
        finally {
            this.endAtomic();
        }
        log.trace((Object)("Successfully moved node '" + nodeToMoveFqn + "' to '" + newParentFqn + "'"));
    }

    @Override
    public void move(Fqn nodeToMove, Fqn newParent, Flag ... flags) throws NodeNotExistsException {
        this.icc.createInvocationContext().setFlags(flags);
        this.move(nodeToMove, newParent);
    }

    @Override
    public void move(String nodeToMove, String newParent) throws NodeNotExistsException {
        this.move(Fqn.fromString(nodeToMove), Fqn.fromString(newParent));
    }

    @Override
    public void move(String nodeToMove, String newParent, Flag ... flags) throws NodeNotExistsException {
        this.icc.createInvocationContext().setFlags(flags);
        this.move(nodeToMove, newParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> getData(Fqn fqn) {
        this.startAtomic();
        try {
            Map<K, V> map = this.getNode(fqn).getData();
            return map;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Map<K, V> getData(Fqn fqn, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.getData(fqn);
    }

    @Override
    public Set<K> getKeys(String fqn) {
        return this.getKeys(Fqn.fromString(fqn));
    }

    @Override
    public Set<K> getKeys(String fqn, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.getKeys(fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> getKeys(Fqn fqn) {
        this.startAtomic();
        try {
            Set<K> set = this.getNode(fqn).getKeys();
            return set;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Set<K> getKeys(Fqn fqn, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.getKeys(fqn);
    }

    @Override
    public void clearData(String fqn) {
        this.clearData(Fqn.fromString(fqn));
    }

    @Override
    public void clearData(String fqn, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearData(Fqn fqn) {
        this.startAtomic();
        try {
            this.getNode(fqn).clearData();
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public void clearData(Fqn fqn, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(Fqn fqn, K key, V value) {
        if (trace) {
            log.trace((Object)("Start: Putting value under key [" + key + "] for node [" + fqn + "]"));
        }
        this.startAtomic();
        try {
            this.createNodeInCache(fqn);
            Object object = this.cache.getAtomicMap((Object)new NodeKey(fqn, NodeKey.Type.DATA)).put(key, value);
            return (V)object;
        }
        finally {
            this.endAtomic();
            if (trace) {
                log.trace((Object)("End: Putting value under key [" + key + "] for node [" + fqn + "]"));
            }
        }
    }

    @Override
    public V put(Fqn fqn, K key, V value, Flag ... flags) {
        this.icc.createInvocationContext().setFlags(flags);
        return this.put(fqn, key, value);
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    public void start() throws CacheException {
        this.cache.start();
        this.createRoot();
    }

    public void stop() {
        this.cache.stop();
    }

    private void createRoot() {
        if (!this.exists(Fqn.ROOT)) {
            this.createNodeInCache(Fqn.ROOT);
        }
    }

    public String toString() {
        return this.cache.toString();
    }
}

