/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tree;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.infinispan.tree.FqnComparator;
import org.infinispan.util.Immutables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class Fqn
implements Comparable<Fqn> {
    public static final String SEPARATOR = "/";
    protected List<Object> elements;
    private transient int hash_code = 0;
    protected int size = 0;
    public static final Fqn ROOT = new Fqn();
    protected String stringRepresentation;

    public Fqn() {
        this.elements = Collections.emptyList();
        this.size = 0;
    }

    private Fqn(List names, boolean safe) {
        if (names != null) {
            this.elements = safe ? names : Immutables.immutableListCopy((List)names);
            this.size = this.elements.size();
        } else {
            this.elements = Collections.emptyList();
            this.size = 0;
        }
    }

    private Fqn(Fqn base, List relative) {
        this.elements = Immutables.immutableListMerge(base.elements, (List)relative);
        this.size = this.elements.size();
    }

    public static Fqn fromList(List names) {
        return new Fqn(names, false);
    }

    public static Fqn fromList(List names, boolean safe) {
        return new Fqn(names, safe);
    }

    public static Fqn fromElements(Object ... elements) {
        return new Fqn(Arrays.asList(elements), true);
    }

    public static Fqn fromRelativeFqn(Fqn base, Fqn relative) {
        return new Fqn(base, relative.elements);
    }

    public static Fqn fromRelativeList(Fqn base, List relativeElements) {
        return new Fqn(base, relativeElements);
    }

    public static Fqn fromRelativeElements(Fqn base, Object ... relativeElements) {
        return new Fqn(base, Arrays.asList(relativeElements));
    }

    public static Fqn fromString(String stringRepresentation) {
        if (stringRepresentation == null || stringRepresentation.equals(SEPARATOR) || stringRepresentation.equals("")) {
            return Fqn.root();
        }
        String toMatch = stringRepresentation.startsWith(SEPARATOR) ? stringRepresentation.substring(1) : stringRepresentation;
        Object[] el = toMatch.split(SEPARATOR);
        return new Fqn(Immutables.immutableListWrap((Object[])el), true);
    }

    public Fqn getAncestor(int generation) {
        if (generation == 0) {
            return Fqn.root();
        }
        return this.getSubFqn(0, generation);
    }

    public Fqn getSubFqn(int startIndex, int endIndex) {
        List<Object> el = this.elements.subList(startIndex, endIndex);
        return new Fqn(el, true);
    }

    public int size() {
        return this.size;
    }

    public Object get(int n) {
        return this.elements.get(n);
    }

    public Object getLastElement() {
        if (this.isRoot()) {
            return null;
        }
        return this.elements.get(this.size - 1);
    }

    public boolean hasElement(Object element) {
        return this.elements.indexOf(element) != -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fqn)) {
            return false;
        }
        Fqn other = (Fqn)obj;
        return this.size == other.size() && ((Object)this.elements).equals(other.elements);
    }

    public int hashCode() {
        if (this.hash_code == 0) {
            this.hash_code = this.calculateHashCode();
        }
        return this.hash_code;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.getStringRepresentation(this.elements);
        }
        return this.stringRepresentation;
    }

    public boolean isChildOf(Fqn parentFqn) {
        return parentFqn.size() != this.size && this.isChildOrEquals(parentFqn);
    }

    public boolean isDirectChildOf(Fqn parentFqn) {
        return this.size == parentFqn.size() + 1 && this.isChildOf(parentFqn);
    }

    public boolean isChildOrEquals(Fqn parentFqn) {
        List<Object> parentList = parentFqn.elements;
        if (parentList.size() > this.size) {
            return false;
        }
        for (int i = parentList.size() - 1; i >= 0; --i) {
            if (parentList.get(i).equals(this.elements.get(i))) continue;
            return false;
        }
        return true;
    }

    protected int calculateHashCode() {
        int hashCode = 19;
        for (Object o : this.elements) {
            hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
        }
        if (hashCode == 0) {
            hashCode = -559038737;
        }
        return hashCode;
    }

    protected String getStringRepresentation(List elements) {
        StringBuilder builder = new StringBuilder();
        for (Object e : elements) {
            if (SEPARATOR.equals(e) || "".equals(e)) continue;
            builder.append(SEPARATOR);
            builder.append(e);
        }
        return builder.length() == 0 ? SEPARATOR : builder.toString();
    }

    public Fqn getParent() {
        switch (this.size) {
            case 0: 
            case 1: {
                return Fqn.root();
            }
        }
        return new Fqn(this.elements.subList(0, this.size - 1), true);
    }

    public static final Fqn root() {
        return ROOT;
    }

    public boolean isRoot() {
        return this.size == 0;
    }

    public String getLastElementAsString() {
        if (this.isRoot()) {
            return SEPARATOR;
        }
        Object last = this.getLastElement();
        if (last instanceof String) {
            return (String)last;
        }
        return String.valueOf(this.getLastElement());
    }

    public List peekElements() {
        return this.elements;
    }

    @Override
    public int compareTo(Fqn fqn) {
        return FqnComparator.INSTANCE.compare(this, fqn);
    }

    public Fqn replaceAncestor(Fqn oldAncestor, Fqn newAncestor) {
        if (!this.isChildOf(oldAncestor)) {
            throw new IllegalArgumentException("Old ancestor must be an ancestor of the current Fqn!");
        }
        Fqn subFqn = this.getSubFqn(oldAncestor.size(), this.size());
        return Fqn.fromRelativeFqn(newAncestor, subFqn);
    }
}

