/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tree.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.marshall.Externalizer;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.NodeKey;

public class NodeKeyExternalizer
implements Externalizer {
    private static final byte DATA_BYTE = 1;
    private static final byte STRUCTURE_BYTE = 2;

    public void writeObject(ObjectOutput output, Object object) throws IOException {
        NodeKey key = (NodeKey)object;
        output.writeObject(key.getFqn());
        int type = 0;
        switch (key.getContents()) {
            case DATA: {
                type = 1;
                break;
            }
            case STRUCTURE: {
                type = 2;
            }
        }
        output.write(type);
    }

    public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Fqn fqn = (Fqn)input.readObject();
        int typeb = input.readUnsignedByte();
        NodeKey.Type type = null;
        switch (typeb) {
            case 1: {
                type = NodeKey.Type.DATA;
                break;
            }
            case 2: {
                type = NodeKey.Type.STRUCTURE;
            }
        }
        return new NodeKey(fqn, type);
    }
}

