/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tree;

import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.batch.AutoBatchSupport;
import org.infinispan.batch.BatchContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.NodeKey;
import org.infinispan.tree.TreeCache;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TreeStructureSupport
extends AutoBatchSupport {
    private static Log log = LogFactory.getLog(TreeStructureSupport.class);
    protected final Cache<NodeKey, AtomicMap<?, ?>> cache;
    protected final InvocationContextContainer icc;

    public TreeStructureSupport(Cache<?, ?> cache, BatchContainer batchContainer, InvocationContextContainer icc) {
        this.cache = cache;
        this.batchContainer = batchContainer;
        this.icc = icc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Fqn f) {
        this.startAtomic();
        try {
            boolean bl = this.cache.containsKey((Object)new NodeKey(f, NodeKey.Type.DATA)) && this.cache.containsKey((Object)new NodeKey(f, NodeKey.Type.STRUCTURE));
            return bl;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createNodeInCache(Fqn fqn) {
        this.startAtomic();
        try {
            NodeKey dataKey = new NodeKey(fqn, NodeKey.Type.DATA);
            NodeKey structureKey = new NodeKey(fqn, NodeKey.Type.STRUCTURE);
            if (this.cache.containsKey((Object)dataKey) && this.cache.containsKey((Object)structureKey)) {
                boolean bl = false;
                return bl;
            }
            Fqn parent = fqn.getParent();
            if (!fqn.isRoot()) {
                if (!this.exists(parent)) {
                    this.createNodeInCache(parent);
                }
                AtomicMap<Object, Fqn> parentStructure = this.getStructure(parent);
                this.icc.getInvocationContext().setFlags(new Flag[]{Flag.SKIP_LOCKING});
                parentStructure.put(fqn.getLastElement(), (Object)fqn);
            }
            this.getAtomicMap(structureKey);
            this.getAtomicMap(dataKey);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Created node " + fqn));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.endAtomic();
        }
    }

    AtomicMap<Object, Fqn> getStructure(Fqn fqn) {
        return this.getAtomicMap(new NodeKey(fqn, NodeKey.Type.STRUCTURE));
    }

    public static boolean isLocked(LockManager lockManager, Fqn fqn) {
        return lockManager.isLocked((Object)new NodeKey(fqn, NodeKey.Type.STRUCTURE)) && lockManager.isLocked((Object)new NodeKey(fqn, NodeKey.Type.DATA));
    }

    public static String printTree(TreeCache<?, ?> cache, boolean details) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n");
        sb.append("+ ").append("/");
        if (details) {
            sb.append("  ").append(cache.getRoot().getData());
        }
        sb.append("\n");
        TreeStructureSupport.addChildren(cache.getRoot(), 1, sb, details);
        return sb.toString();
    }

    private static void addChildren(Node<?, ?> node, int depth, StringBuilder sb, boolean details) {
        for (Node<?, ?> child : node.getChildren()) {
            for (int i = 0; i < depth; ++i) {
                sb.append("  ");
            }
            sb.append("+ ");
            sb.append(child.getFqn().getLastElementAsString()).append("/");
            if (details) {
                sb.append("  ").append(child.getData());
            }
            sb.append("\n");
            TreeStructureSupport.addChildren(child, depth + 1, sb, details);
        }
    }

    protected final <K, V> AtomicMap<K, V> getAtomicMap(NodeKey key) {
        return AtomicMapLookup.getAtomicMap(this.cache, (Object)key);
    }
}

