/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tree;

import java.util.Map;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.config.ConfigurationException;
import org.infinispan.context.Flag;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.NodeImpl;
import org.infinispan.tree.NodeKey;
import org.infinispan.tree.NodeNotExistsException;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeStructureSupport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TreeCacheImpl<K, V>
extends TreeStructureSupport
implements TreeCache<K, V> {
    private static final Log log = LogFactory.getLog(TreeCacheImpl.class);
    private static final boolean trace = log.isTraceEnabled();

    public TreeCacheImpl(Cache<?, ?> cache) {
        super(cache, ((AdvancedCache)cache).getBatchContainer(), ((AdvancedCache)cache).getInvocationContextContainer());
        if (cache.getConfiguration().isIndexingEnabled()) {
            throw new ConfigurationException("TreeCache cannot be used with a Cache instance configured to use indexing!");
        }
        this.assertBatchingSupported(cache.getConfiguration());
        this.createRoot();
    }

    @Override
    public Node<K, V> getRoot() {
        return new NodeImpl(Fqn.ROOT, this.cache, this.batchContainer, this.icc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node<K, V> getRoot(Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            Node<K, V> node = this.getRoot();
            return node;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public V put(String fqn, K key, V value) {
        return this.put(Fqn.fromString(fqn), key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(String fqn, K key, V value, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            V v = this.put(fqn, key, value);
            return v;
        }
        finally {
            this.tcc.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Fqn fqn, Map<? extends K, ? extends V> data) {
        this.startAtomic();
        try {
            Node<? extends K, ? extends V> n = this.getNode(fqn);
            if (n == null) {
                this.createNodeInCache(fqn);
            }
            n = this.getNode(fqn);
            n.putAll(data);
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Fqn fqn, Map<? extends K, ? extends V> data, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            this.put(fqn, data);
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public void put(String fqn, Map<? extends K, ? extends V> data) {
        this.put(Fqn.fromString(fqn), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String fqn, Map<? extends K, ? extends V> data, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            this.put(fqn, data);
        }
        finally {
            this.tcc.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Fqn fqn, K key) {
        this.startAtomic();
        try {
            AtomicMap map = this.getAtomicMap(new NodeKey(fqn, NodeKey.Type.DATA));
            Object object = map == null ? null : map.remove(key);
            return (V)object;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Fqn fqn, K key, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            V v = this.remove(fqn, key);
            return v;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public V remove(String fqn, K key) {
        return this.remove(Fqn.fromString(fqn), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(String fqn, K key, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            V v = this.remove(fqn, key);
            return v;
        }
        finally {
            this.tcc.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNode(Fqn fqn) {
        boolean result;
        if (fqn.isRoot()) {
            return false;
        }
        this.startAtomic();
        try {
            Node<K, V> n;
            if (trace) {
                log.tracef("About to remove node %s", (Object)fqn);
            }
            result = (n = this.getNode(fqn.getParent())) != null && n.removeChild(fqn.getLastElement());
        }
        finally {
            this.endAtomic();
        }
        if (trace) {
            log.trace((Object)"Node successfully removed");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNode(Fqn fqn, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            boolean bl = this.removeNode(fqn);
            return bl;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public boolean removeNode(String fqn) {
        return this.removeNode(Fqn.fromString(fqn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNode(String fqn, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            boolean bl = this.removeNode(fqn);
            return bl;
        }
        finally {
            this.tcc.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node<K, V> getNode(Fqn fqn) {
        this.startAtomic();
        try {
            if (this.exists(fqn)) {
                NodeImpl nodeImpl = new NodeImpl(fqn, this.cache, this.batchContainer, this.icc);
                return nodeImpl;
            }
            Node<K, V> node = null;
            return node;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node<K, V> getNode(Fqn fqn, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            Node<K, V> node = this.getNode(fqn);
            return node;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public Node<K, V> getNode(String fqn) {
        return this.getNode(Fqn.fromString(fqn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node<K, V> getNode(String fqn, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            Node<K, V> node = this.getNode(fqn);
            return node;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public V get(Fqn fqn, K key) {
        AtomicMap m = this.getAtomicMap(new NodeKey(fqn, NodeKey.Type.DATA));
        if (m == null) {
            return null;
        }
        return m.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Fqn fqn, K key, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            V v = this.get(fqn, key);
            return v;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public boolean exists(String f) {
        return this.exists(Fqn.fromString(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String fqn, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            boolean bl = this.exists(fqn);
            return bl;
        }
        finally {
            this.tcc.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(Fqn fqn, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            boolean bl = this.exists(fqn);
            return bl;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public V get(String fqn, K key) {
        return this.get(Fqn.fromString(fqn), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(String fqn, K key, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            V v = this.get(fqn, key);
            return v;
        }
        finally {
            this.tcc.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Fqn nodeToMoveFqn, Fqn newParentFqn) throws NodeNotExistsException {
        if (trace) {
            log.tracef("Moving node '%s' to '%s'", (Object)nodeToMoveFqn, (Object)newParentFqn);
        }
        if (nodeToMoveFqn == null || newParentFqn == null) {
            throw new NullPointerException("Cannot accept null parameters!");
        }
        if (nodeToMoveFqn.getParent().equals(newParentFqn)) {
            if (trace) {
                log.trace((Object)"Not doing anything as this node is equal with its parent");
            }
            return;
        }
        this.startAtomic();
        try {
            Node<K, V> nodeToMove = this.getNode(nodeToMoveFqn, Flag.FORCE_WRITE_LOCK);
            if (nodeToMove == null) {
                if (trace) {
                    log.trace((Object)"Did not find the node that needs to be moved. Returning...");
                }
                return;
            }
            if (!this.exists(newParentFqn)) {
                this.createNodeInCache(newParentFqn);
                if (trace) {
                    log.tracef("The new parent (%s) did not exists, was created", (Object)newParentFqn);
                }
            }
            Fqn newFqn = Fqn.fromRelativeElements(newParentFqn, nodeToMoveFqn.getLastElement());
            this.createNodeInCache(newFqn);
            Node<K, V> newNode = this.getNode(newFqn);
            Map<K, V> oldData = nodeToMove.getData();
            if (oldData != null && !oldData.isEmpty()) {
                newNode.putAll(oldData);
            }
            for (Object child : nodeToMove.getChildrenNames()) {
                if (trace) {
                    log.tracef("Moving child %s", child);
                }
                Fqn oldChildFqn = Fqn.fromRelativeElements(nodeToMoveFqn, child);
                this.move(oldChildFqn, newFqn);
            }
            this.removeNode(nodeToMoveFqn);
        }
        finally {
            this.endAtomic();
        }
        log.tracef("Successfully moved node '%s' to '%s'", (Object)nodeToMoveFqn, (Object)newParentFqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Fqn nodeToMove, Fqn newParent, Flag ... flags) throws NodeNotExistsException {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            this.move(nodeToMove, newParent);
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public void move(String nodeToMove, String newParent) throws NodeNotExistsException {
        this.move(Fqn.fromString(nodeToMove), Fqn.fromString(newParent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(String nodeToMove, String newParent, Flag ... flags) throws NodeNotExistsException {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            this.move(nodeToMove, newParent);
        }
        finally {
            this.tcc.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> getData(Fqn fqn) {
        this.startAtomic();
        try {
            Node<K, V> node = this.getNode(fqn);
            if (node == null) {
                Map<K, V> map = null;
                return map;
            }
            Map<K, V> map = node.getData();
            return map;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> getData(Fqn fqn, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            Map<K, V> map = this.getData(fqn);
            return map;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public Set<K> getKeys(String fqn) {
        return this.getKeys(Fqn.fromString(fqn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> getKeys(String fqn, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            Set<K> set = this.getKeys(fqn);
            return set;
        }
        finally {
            this.tcc.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> getKeys(Fqn fqn) {
        this.startAtomic();
        try {
            Node<K, V> node = this.getNode(fqn);
            if (node == null) {
                Set<K> set = null;
                return set;
            }
            Set<K> set = node.getKeys();
            return set;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> getKeys(Fqn fqn, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            Set<K> set = this.getKeys(fqn);
            return set;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public void clearData(String fqn) {
        this.clearData(Fqn.fromString(fqn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearData(String fqn, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            this.clearData(fqn);
        }
        finally {
            this.tcc.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearData(Fqn fqn) {
        this.startAtomic();
        try {
            Node<K, V> node = this.getNode(fqn);
            if (node != null) {
                node.clearData();
            }
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearData(Fqn fqn, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            this.clearData(fqn);
        }
        finally {
            this.tcc.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(Fqn fqn, K key, V value) {
        if (trace) {
            log.tracef("Start: Putting value under key [%s] for node [%s]", key, (Object)fqn);
        }
        this.startAtomic();
        try {
            this.createNodeInCache(fqn);
            AtomicMap<K, V> m = this.getAtomicMap(new NodeKey(fqn, NodeKey.Type.DATA));
            V v = m.put(key, value);
            return v;
        }
        finally {
            this.endAtomic();
            if (trace) {
                log.tracef("End: Putting value under key [%s] for node [%s]", key, (Object)fqn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(Fqn fqn, K key, V value, Flag ... flags) {
        this.tcc.createTreeContext().setFlags(flags);
        try {
            V v = this.put(fqn, key, value);
            return v;
        }
        finally {
            this.tcc.suspend();
        }
    }

    @Override
    public Cache<?, ?> getCache() {
        return this.cache.getAdvancedCache();
    }

    public void start() throws CacheException {
        this.cache.start();
        this.createRoot();
    }

    public void stop() {
        this.cache.stop();
    }

    private void createRoot() {
        if (!this.exists(Fqn.ROOT)) {
            this.createNodeInCache(Fqn.ROOT);
        }
    }

    public String toString() {
        return this.cache.toString();
    }
}

