/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.upgrade.hotrod;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.remote.RemoteCacheStore;
import org.infinispan.loaders.remote.RemoteCacheStoreConfig;
import org.infinispan.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.upgrade.TargetMigrator;
import org.infinispan.upgrade.logging.Log;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.logging.LogFactory;

public class HotRodTargetMigrator
implements TargetMigrator {
    private static final String MIGRATION_MANAGER_HOT_ROD_KNOWN_KEYS = "___MigrationManager_HotRod_KnownKeys___";
    private static final Log log = (Log)LogFactory.getLog(HotRodTargetMigrator.class, Log.class);

    public String getName() {
        return "hotrod";
    }

    public long synchronizeData(final Cache<Object, Object> cache) throws CacheException {
        ByteArrayKey knownKeys;
        int threads = Runtime.getRuntime().availableProcessors();
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        CacheLoaderManager loaderManager = (CacheLoaderManager)cr.getComponent(CacheLoaderManager.class);
        List stores = loaderManager.getCacheLoaders(RemoteCacheStore.class);
        GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
        try {
            knownKeys = new ByteArrayKey(marshaller.objectToByteBuffer((Object)MIGRATION_MANAGER_HOT_ROD_KNOWN_KEYS));
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        for (RemoteCacheStore store : stores) {
            Set keys;
            RemoteCache storeCache = store.getRemoteCache();
            if (!storeCache.containsKey((Object)knownKeys)) continue;
            RemoteCacheStoreConfig storeConfig = (RemoteCacheStoreConfig)store.getCacheStoreConfig();
            if (!storeConfig.isHotRodWrapping()) {
                throw log.remoteStoreNoHotRodWrapping(cache.getName());
            }
            try {
                keys = (Set)marshaller.objectFromByteBuffer((byte[])storeCache.get((Object)knownKeys));
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
            ExecutorService es = Executors.newFixedThreadPool(threads);
            final AtomicInteger count = new AtomicInteger(0);
            for (final ByteArrayKey key : keys) {
                es.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            cache.get((Object)key);
                            int i = count.getAndIncrement();
                            if (log.isDebugEnabled() && i % 100 == 0) {
                                log.debugf(">>    Moved %s keys\n", i);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            es.shutdown();
            try {
                while (!es.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                }
            }
            catch (InterruptedException e) {
                throw new CacheException((Throwable)e);
            }
            return count.longValue();
        }
        throw log.missingMigrationData(cache.getName());
    }

    public void disconnectSource(Cache<Object, Object> cache) throws CacheException {
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        CacheLoaderManager loaderManager = (CacheLoaderManager)cr.getComponent(CacheLoaderManager.class);
        loaderManager.disableCacheStore(RemoteCacheStore.class.getName());
    }
}

