/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.plugins.proto.compatibility;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="proto-schema-compatibility-check", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class ProtoCompatibilityMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${basedir}")
    private String protoLockRoot;
    @Parameter(defaultValue="${project.build.directory}/classes/proto", readonly=true)
    private String protoSourceRoot;
    @Parameter(defaultValue="false", readonly=true)
    private boolean commitProtoLock;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String classifier;
        Path exeDirPath = Paths.get(this.mavenProject.getBuild().getDirectory(), "protolock-bin");
        if (!Files.isDirectory(exeDirPath, new LinkOption[0])) {
            try {
                Files.createDirectory(exeDirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create the protolock binary directory", (Exception)e);
            }
        }
        String exeExtension = (classifier = this.mavenProject.getProperties().getProperty("os.detected.classifier")).startsWith("windows") ? ".exe" : "";
        Path exePath = exeDirPath.resolve("protolock" + exeExtension);
        if (!Files.exists(exePath, new LinkOption[0])) {
            String protolockResourcePath = classifier + "/protolock" + exeExtension;
            try (InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(protolockResourcePath);){
                if (in == null) {
                    throw new MojoExecutionException("OS not supported. Unable to find a protolock binary for the classifier " + classifier);
                }
                Files.copy(in, exePath, new CopyOption[0]);
                PosixFileAttributeView attributes = Files.getFileAttributeView(exePath, PosixFileAttributeView.class, new LinkOption[0]);
                if (attributes != null) {
                    attributes.setPermissions(PosixFilePermissions.fromString("rwxrwxr-x"));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write the protolock binary", (Exception)e);
            }
        }
        try {
            Path lockFile = Paths.get(this.protoLockRoot, "proto.lock");
            boolean lockFileExists = Files.exists(lockFile, new LinkOption[0]);
            if (!this.commitProtoLock && !lockFileExists) {
                this.getLog().info((CharSequence)"Ignoring protolock check as there isn't an existing proto.lock file and commitProtoLock=false.");
                return;
            }
            if (!lockFileExists) {
                this.runCmd(exePath, "init");
                this.getLog().info((CharSequence)"Initialized protolock.");
            } else {
                this.runCmd(exePath, "status");
                this.getLog().info((CharSequence)"Backwards compatibility check passed.");
                if (this.commitProtoLock) {
                    this.runCmd(exePath, "commit");
                    this.getLog().info((CharSequence)"Schema changes committed to proto.lock.");
                }
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("An error occurred while running protolock", e);
        }
    }

    private void runCmd(Path exePath, String action) throws InterruptedException, IOException, MojoFailureException {
        String errorMsg;
        String cmd = String.format("%s %s --lockdir %s --protoroot %s", exePath, action, this.protoLockRoot, this.protoSourceRoot);
        Process protolock = Runtime.getRuntime().exec(cmd, null, this.mavenProject.getBasedir());
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(protolock.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((errorMsg = stdInput.readLine()) != null) {
            this.getLog().error((CharSequence)errorMsg);
            sb.append(errorMsg).append("\n");
        }
        int exitVal = protolock.waitFor();
        if (exitVal != 0) {
            throw new MojoFailureException(String.format("Backwards compatibility check failed with: %s", sb.toString()));
        }
    }
}

