/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.ppg.generator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.ppg.generator.Element;
import org.infinispan.ppg.generator.Grammar;
import org.infinispan.ppg.generator.Machine;
import org.infinispan.ppg.generator.Reference;
import org.infinispan.ppg.generator.Resolvable;
import org.infinispan.ppg.generator.RuleDefinition;

class Action
implements Element {
    private static final Set<String> DOUBLE_TOKEN_OPERATORS = new HashSet<String>(Arrays.asList("&&", "||", "!=", "==", "+=", "-=", "*=", "/=", "++", "--", "<<", ">>", "<=", ">=", "->"));
    private final String ns;
    private final List<String> action;
    private final String file;
    private final int line;

    Action(String ns, List<String> action, String file, int line) {
        this.ns = ns;
        this.action = action;
        this.file = file;
        this.line = line;
    }

    public String toString() {
        return "{ " + this.action + "}";
    }

    @Override
    public void addReferences(Set<Reference> references) {
    }

    @Override
    public Machine.State addStates(Machine.State prev, Machine.State target, Machine machine, Grammar grammar, List<RuleDefinition> ruleStack) {
        Object code = this.code(grammar);
        if (!((String)code).endsWith(";\n")) {
            code = (String)code + ";\n";
        }
        return prev.addAction((String)code, target);
    }

    @Override
    public String analyzeType(Grammar grammar) {
        if (this.action.size() >= 1 && "throw".equals(this.action.get(0))) {
            return "throw";
        }
        if (this.action.size() >= 2 && "new".equals(this.action.get(0))) {
            String array = "";
            if (this.action.size() > 2 && "[".equals(this.action.get(2))) {
                array = "[";
            }
            return this.action.get(1) + array;
        }
        if (this.action.size() == 1) {
            String token = this.action.get(0);
            if (token.equals("true") || token.equals("false")) {
                return "boolean";
            }
            if (token.matches("[0-9]*[Ll]")) {
                return "long";
            }
            if (token.matches("[0-9]*")) {
                return "int";
            }
        }
        return "void";
    }

    public String code(Grammar grammar) {
        StringBuilder sb = new StringBuilder();
        boolean requiresSpace = false;
        for (int i = 0; i < this.action.size(); ++i) {
            boolean reservedWord;
            String lookeahead;
            String item = this.action.get(i);
            String string = lookeahead = i + 1 < this.action.size() ? this.action.get(i + 1) : "";
            assert (!item.isEmpty());
            char firstChar = item.charAt(0);
            if (firstChar == ';') {
                sb.append(item).append('\n');
                requiresSpace = false;
                continue;
            }
            if (firstChar == ')' || firstChar == ']' || firstChar == ',') {
                sb.append(item);
                requiresSpace = true;
                continue;
            }
            if (firstChar == '(' || firstChar == '[' || firstChar == '.') {
                sb.append(item);
                requiresSpace = false;
                continue;
            }
            if (requiresSpace) {
                sb.append(' ');
            }
            switch (item) {
                case "boolean": 
                case "byte": 
                case "char": 
                case "double": 
                case "float": 
                case "int": 
                case "long": 
                case "short": {
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = reservedWord = false;
                }
            }
            if (!reservedWord && Character.isLetter(firstChar) || firstChar == '@') {
                String varName;
                requiresSpace = true;
                Resolvable resolvable = grammar.qualified.get(item);
                if (resolvable != null) {
                    sb.append(resolvable.sourceName());
                    continue;
                }
                resolvable = grammar.qualified.get(this.ns + "." + item);
                if (resolvable != null) {
                    sb.append(resolvable.sourceName());
                    continue;
                }
                int dotIndex = item.indexOf(46);
                if (dotIndex > 0 && (resolvable = grammar.qualified.get(this.ns + "." + (varName = item.substring(0, dotIndex)))) != null) {
                    sb.append(resolvable.sourceName()).append('.').append(item.substring(dotIndex + 1));
                    continue;
                }
            }
            sb.append(item);
            if ("if".equals(item) || "while".equals(item)) {
                sb.append(' ');
                continue;
            }
            if (firstChar == '@' || firstChar == '{' || firstChar == '}' && !lookeahead.equals("else")) {
                sb.append('\n');
                requiresSpace = false;
                continue;
            }
            requiresSpace = !DOUBLE_TOKEN_OPERATORS.contains(item + lookeahead);
        }
        return sb.toString();
    }
}

