/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.ppg.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.infinispan.ppg.generator.Action;
import org.infinispan.ppg.generator.Constant;
import org.infinispan.ppg.generator.Intrinsic;
import org.infinispan.ppg.generator.Machine;
import org.infinispan.ppg.generator.ParserException;
import org.infinispan.ppg.generator.Reference;
import org.infinispan.ppg.generator.Resolvable;
import org.infinispan.ppg.generator.RuleDefinition;

public class Grammar {
    final Map<String, Resolvable> qualified = new HashMap<String, Resolvable>();
    final List<RuleDefinition> rules = new ArrayList<RuleDefinition>();
    final List<String> imports = new ArrayList<String>();
    final List<Constant> constants = new ArrayList<Constant>();
    final List<Intrinsic> intrinsics = new ArrayList<Intrinsic>();
    String pkg;
    String simpleName;
    String baseClassName;
    RuleDefinition root;
    Action beforeDecodeAction;
    Action initAction;
    Action exceptionally;
    Action deadEnd;

    public void checkReferences() {
        HashSet<Reference> references = new HashSet<Reference>();
        for (RuleDefinition rule : this.rules) {
            rule.addReferences(references);
        }
        for (Reference reference : references) {
            if (this.qualified.containsKey(reference.qualifiedName)) continue;
            throw new ParserException(reference.file + ":" + reference.line + ": Reference to unknown element '" + reference.qualifiedName + "'");
        }
    }

    public Machine build(int maxSwitchStates, int userSwitchThreshold, boolean passContext) {
        Machine machine = new Machine(this.pkg, this.simpleName, this.baseClassName, this.initAction == null ? null : this.initAction.code(this), this.exceptionally == null ? null : this.exceptionally.code(this), this.deadEnd == null ? null : this.deadEnd.code(this), this.beforeDecodeAction == null ? null : this.beforeDecodeAction.code(this), maxSwitchStates, userSwitchThreshold, passContext);
        this.imports.forEach(machine::addImport);
        for (RuleDefinition rule : this.rules) {
            String type = rule.analyzeType(this);
            if ("void".equals(type)) continue;
            machine.addVariable(type, rule.sourceName);
        }
        for (Intrinsic intrinsic : this.intrinsics) {
            machine.addVariable(intrinsic.analyzeType(this), intrinsic.sourceName());
        }
        ArrayList<RuleDefinition> ruleStack = new ArrayList<RuleDefinition>();
        Machine.State initialState = machine.addState(ruleStack);
        Machine.State afterReset = initialState.addAction("reset(); ", machine.addState(ruleStack));
        this.root.addStates(afterReset, initialState, machine, this, ruleStack, new Reference("<root>", this.root.file, this.root.line));
        machine.contractStates();
        return machine;
    }

    public void addRule(RuleDefinition rule) {
        this.rules.add(rule);
        this.addResolvable(rule, rule.file, rule.line);
    }

    public void addIntrinsic(Intrinsic intrinsic) {
        this.intrinsics.add(intrinsic);
        this.addResolvable(intrinsic, intrinsic.file, intrinsic.line);
    }

    public void addConstant(Constant constant) {
        this.constants.add(constant);
        this.addResolvable(constant, constant.file, constant.line);
    }

    public void addResolvable(Resolvable resolvable, String file, int line) {
        Resolvable prev = this.qualified.put(resolvable.qualifiedName(), resolvable);
        if (prev != null) {
            throw new ParserException(file + ":" + line + ": Duplicate definition for " + resolvable.qualifiedName() + ", already defined: " + prev);
        }
    }

    public String getPackage() {
        return this.pkg;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setClassName(String fqcn) {
        if (this.pkg != null || this.simpleName != null) {
            throw new ParserException("Class name already set: package=" + this.pkg + ", name=" + this.simpleName + ", now got " + fqcn);
        }
        int dotIndex = fqcn.lastIndexOf(46);
        if (dotIndex < 0) {
            throw new ParserException("Expected qualified class name, found '" + fqcn + "'");
        }
        this.pkg = fqcn.substring(0, dotIndex);
        this.simpleName = fqcn.substring(dotIndex + 1);
        if (this.pkg.isEmpty() || this.simpleName.isEmpty()) {
            throw new ParserException("Invalid class name '" + fqcn + "'");
        }
    }

    public void setBaseClassName(String baseClassName) {
        this.baseClassName = baseClassName;
    }
}

