/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.impl.AbstractMarshallerCodeGenerator;
import org.infinispan.protostream.annotations.impl.GeneratedMarshallerBase;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoFieldMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMapMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.processor.AutoProtoSchemaBuilderAnnotationProcessor;
import org.infinispan.protostream.annotations.impl.processor.GeneratedFilesWriter;
import org.infinispan.protostream.annotations.impl.processor.types.HasModelElement;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.containers.IndexedElementContainerAdapter;
import org.infinispan.protostream.containers.IterableElementContainerAdapter;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.EnumMarshallerDelegate;
import org.infinispan.protostream.impl.Log;

final class MarshallerSourceCodeGenerator
extends AbstractMarshallerCodeGenerator {
    private static final Log log = Log.LogFactory.getLog(MarshallerSourceCodeGenerator.class);
    private static final String DIGEST_ALG = "SHA-256";
    private final GeneratedFilesWriter generatedFilesWriter;
    private final Set<String> generatedClasses = new LinkedHashSet<String>();

    MarshallerSourceCodeGenerator(GeneratedFilesWriter generatedFilesWriter, XTypeFactory typeFactory, String protobufSchemaPackage) {
        super(typeFactory, protobufSchemaPackage);
        this.generatedFilesWriter = generatedFilesWriter;
    }

    public void generateMarshaller(SerializationContext serCtx, ProtoTypeMetadata ptm) throws IOException {
        if (ptm instanceof ProtoMessageTypeMetadata) {
            this.generateMessageMarshaller((ProtoMessageTypeMetadata)ptm);
        } else if (ptm instanceof ProtoEnumTypeMetadata) {
            this.generateEnumMarshaller((ProtoEnumTypeMetadata)ptm);
        }
    }

    private String makeUniqueMarshallerClassName(ProtoTypeMetadata ptm) {
        String hash = MarshallerSourceCodeGenerator.hashStrings(ptm.getAnnotatedClass().getName(), this.makeQualifiedTypeName(ptm.getFullName()));
        return ptm.getAnnotatedClass().getSimpleName() + "$___Marshaller_" + hash;
    }

    private static String hashStrings(String ... strings) {
        try {
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALG);
            for (int i = 0; i < strings.length; ++i) {
                if (i > 0) {
                    md.update((byte)0);
                }
                byte[] bytes = strings[i].getBytes(StandardCharsets.UTF_8);
                md.update(bytes);
            }
            byte[] digest = md.digest();
            return new BigInteger(1, digest).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to compute SHA-256 digest of strings", e);
        }
    }

    private void generateEnumMarshaller(ProtoEnumTypeMetadata petm) throws IOException {
        Object fqn;
        String marshallerClassName = this.makeUniqueMarshallerClassName((ProtoTypeMetadata)petm);
        if (log.isTraceEnabled()) {
            log.tracef("Generating enum marshaller %s for %s", (Object)marshallerClassName, (Object)petm.getJavaClass().getName());
        }
        StringWriter sw = new StringWriter();
        IndentWriter iw = new IndentWriter((Writer)sw);
        this.addFileHeader(iw, petm.getAnnotatedClassName());
        if (petm.getAnnotatedClass().getPackageName() != null) {
            fqn = petm.getAnnotatedClass().getPackageName() + "." + marshallerClassName;
            iw.printf("package %s;\n", new Object[]{petm.getAnnotatedClass().getPackageName()});
            iw.println();
        } else {
            fqn = marshallerClassName;
        }
        if (petm.getJavaClass().getPackageName() != null) {
            iw.append((CharSequence)"import ").append((CharSequence)petm.getJavaClassName()).append((CharSequence)";\n\n");
        }
        iw.append((CharSequence)"public final class ").append((CharSequence)marshallerClassName).append((CharSequence)" implements ").append((CharSequence)EnumMarshaller.class.getName()).append('<').append((CharSequence)petm.getJavaClassName()).append((CharSequence)"> {\n\n");
        iw.inc();
        iw.println("@Override");
        iw.append((CharSequence)"public Class<").append((CharSequence)petm.getJavaClassName()).append((CharSequence)"> getJavaClass() { return ").append((CharSequence)petm.getJavaClassName()).append((CharSequence)".class; }\n\n");
        iw.println("@Override");
        iw.append((CharSequence)"public String getTypeName() { return \"").append((CharSequence)this.makeQualifiedTypeName(petm.getFullName())).append((CharSequence)"\"; }\n\n");
        String decodeSrc = this.generateEnumDecodeMethodBody(petm);
        String decodeSig = "public " + petm.getJavaClassName() + " decode(int $1)";
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", (Object)decodeSig, (Object)decodeSrc);
        }
        iw.append((CharSequence)"@Override\n").append((CharSequence)decodeSig).append(' ').append((CharSequence)decodeSrc).append('\n');
        String encodeSrc = this.generateEnumEncodeMethodBody(petm);
        String encodeSig = "public int encode(" + petm.getJavaClassName() + " $1) throws IllegalArgumentException";
        if (log.isTraceEnabled()) {
            log.tracef("%s %s", (Object)encodeSig, (Object)encodeSrc);
        }
        iw.append((CharSequence)"@Override\n").append((CharSequence)encodeSig).append(' ').append((CharSequence)encodeSrc);
        iw.dec();
        iw.append((CharSequence)"}\n");
        this.emitSource((String)fqn, sw.toString(), (ProtoTypeMetadata)petm);
    }

    private void addFileHeader(IndentWriter iw, String className) {
        iw.println("/*");
        iw.printf(" Generated by %s\n", new Object[]{((Object)((Object)this)).getClass().getName()});
        iw.printf(" for class %s\n", new Object[]{className});
        iw.println("*/");
        iw.println();
    }

    private void generateMessageMarshaller(ProtoMessageTypeMetadata pmtm) throws IOException {
        Object fqn;
        String marshallerClassName = this.makeUniqueMarshallerClassName((ProtoTypeMetadata)pmtm);
        if (log.isTraceEnabled()) {
            log.tracef("Generating message marshaller %s for %s", (Object)marshallerClassName, (Object)pmtm.getJavaClass().getName());
        }
        StringWriter sw = new StringWriter();
        IndentWriter iw = new IndentWriter((Writer)sw);
        this.addFileHeader(iw, pmtm.getAnnotatedClassName());
        if (pmtm.getAnnotatedClass().getPackageName() != null) {
            fqn = pmtm.getAnnotatedClass().getPackageName() + "." + marshallerClassName;
            iw.printf("package %s;\n", new Object[]{pmtm.getAnnotatedClass().getPackageName()});
            iw.println();
        } else {
            fqn = marshallerClassName;
        }
        if (pmtm.getJavaClass().getPackageName() != null) {
            XClass toImport = pmtm.getJavaClass().isArray() ? pmtm.getJavaClass().getComponentType() : pmtm.getJavaClass();
            String toImportName = toImport.getCanonicalName();
            iw.printf("import %s;\n", new Object[]{toImportName != null ? toImportName : toImport.getName()});
            iw.println();
        }
        AutoProtoSchemaBuilderAnnotationProcessor.addGeneratedClassHeader(iw, true, new String[0]);
        iw.println("@SuppressWarnings(\"all\")");
        iw.printf("public final class %s extends %s implements %s<%s>", new Object[]{marshallerClassName, GeneratedMarshallerBase.class.getName(), ProtobufTagMarshaller.class.getName(), pmtm.getJavaClassName()});
        String elementType = null;
        if (pmtm.isIndexedContainer()) {
            elementType = pmtm.getAnnotatedClass().getGenericInterfaceParameterTypes(IndexedElementContainerAdapter.class)[1];
            iw.printf(", %s<%s, %s>", new Object[]{IndexedElementContainerAdapter.class.getName(), pmtm.getJavaClassName(), elementType});
        } else if (pmtm.isIterableContainer()) {
            elementType = pmtm.getAnnotatedClass().getGenericInterfaceParameterTypes(IterableElementContainerAdapter.class)[1];
            iw.printf(", %s<%s, %s>", new Object[]{IterableElementContainerAdapter.class.getName(), pmtm.getJavaClassName(), elementType});
        }
        iw.println(" {");
        iw.println();
        iw.inc();
        if (pmtm.isAdapter()) {
            this.addAdapterField(iw, pmtm);
        }
        this.addMarshallerDelegateFields(iw, pmtm);
        iw.println("@Override");
        iw.printf("public Class<%s> getJavaClass() { return %s.class; }\n", new Object[]{pmtm.getJavaClassName(), pmtm.getJavaClassName()});
        iw.println();
        iw.println("@Override");
        iw.printf("public String getTypeName() { return \"%s\"; }\n", new Object[]{this.makeQualifiedTypeName(pmtm.getFullName())});
        iw.println();
        String[] subClassNames = pmtm.getSubClassNames();
        if (subClassNames != null && subClassNames.length > 0) {
            iw.println("@Override");
            iw.println("public String[] getSubClassNames() {");
            iw.inc().print("return new String[] {");
            iw.print(Arrays.stream(subClassNames).collect(Collectors.joining(",", "\"", "\"")));
            iw.println("};");
            iw.dec().println("}");
        }
        if (pmtm.isIndexedContainer()) {
            if (pmtm.isAdapter()) {
                iw.println("@Override");
                iw.printf("public int getNumElements(%s container) { return %s.getNumElements(container); }\n", new Object[]{pmtm.getJavaClassName(), "__a$"});
                iw.println("@Override");
                iw.printf("public %s getElement(%s container, int index) { return %s.getElement(container, index); }\n", new Object[]{elementType, pmtm.getJavaClassName(), "__a$"});
                iw.println("@Override");
                iw.printf("public void setElement(%s container, int index, %s element) { %s.setElement(container, index, element); }\n", new Object[]{pmtm.getJavaClassName(), elementType, "__a$"});
            } else {
                iw.println("@Override");
                iw.printf("public int getNumElements(%s container) { return ((%s) container).getNumElements(); }\n", new Object[]{pmtm.getJavaClassName(), IndexedElementContainerAdapter.class.getName()});
                iw.println("@Override");
                iw.printf("public %s getElement(%s container, int index) { return ((%s) container).getElement(index); }\n", new Object[]{elementType, pmtm.getJavaClassName(), IndexedElementContainerAdapter.class.getName()});
                iw.println("@Override");
                iw.append((CharSequence)"public void setElement(").append((CharSequence)pmtm.getJavaClassName()).append((CharSequence)" container, int index, ").append((CharSequence)elementType).append((CharSequence)" element) { ((").append((CharSequence)IndexedElementContainerAdapter.class.getName()).append((CharSequence)") container).setElement(index, element); }\n");
            }
        } else if (pmtm.isIterableContainer()) {
            if (pmtm.isAdapter()) {
                iw.println("@Override");
                iw.append((CharSequence)"public int getNumElements(").append((CharSequence)pmtm.getJavaClassName()).append((CharSequence)" container) { return ").append((CharSequence)"__a$").append((CharSequence)".getNumElements(container); }\n");
                iw.println("@Override");
                iw.append((CharSequence)"public java.util.Iterator getElements(").append((CharSequence)pmtm.getJavaClassName()).append((CharSequence)" container) { return ").append((CharSequence)"__a$").append((CharSequence)".getElements(container); }\n");
                iw.println("@Override");
                iw.append((CharSequence)"public void appendElement(").append((CharSequence)pmtm.getJavaClassName()).append((CharSequence)" container, ").append((CharSequence)elementType).append((CharSequence)" element) { ").append((CharSequence)"__a$").append((CharSequence)".appendElement(container, element); }\n");
            } else {
                iw.println("@Override");
                iw.append((CharSequence)"public int getNumElements(").append((CharSequence)pmtm.getJavaClassName()).append((CharSequence)" container) { return ((").append((CharSequence)IterableElementContainerAdapter.class.getName()).append((CharSequence)") container).getNumElements(); }\n");
                iw.println("@Override");
                iw.append((CharSequence)"public java.util.Iterator getElements(").append((CharSequence)pmtm.getJavaClassName()).append((CharSequence)" container) { return ((").append((CharSequence)IterableElementContainerAdapter.class.getName()).append((CharSequence)") container).getElements(); }\n");
                iw.println("@Override");
                iw.append((CharSequence)"public void appendElement(").append((CharSequence)pmtm.getJavaClassName()).append((CharSequence)" container, ").append((CharSequence)elementType).append((CharSequence)" element) { ((").append((CharSequence)IterableElementContainerAdapter.class.getName()).append((CharSequence)") container).appendElement(element); }\n");
            }
        }
        iw.println("@Override");
        iw.printf("public %s read(%s $1) throws java.io.IOException {\n", new Object[]{pmtm.getJavaClassName(), ProtobufTagMarshaller.ReadContext.class.getCanonicalName()});
        iw.inc();
        this.generateReadMethodBody(iw, pmtm);
        iw.dec();
        iw.println("}");
        iw.println();
        iw.println("@Override");
        iw.printf("public void write(%s $1, %s $2) throws java.io.IOException {\n", new Object[]{ProtobufTagMarshaller.WriteContext.class.getCanonicalName(), pmtm.getJavaClassName()});
        iw.inc();
        this.generateWriteMethodBody(iw, pmtm);
        iw.dec();
        iw.println("}");
        iw.dec();
        iw.println("}");
        if (log.isTraceEnabled()) {
            log.trace((Object)sw.toString());
        }
        this.emitSource((String)fqn, sw.toString(), (ProtoTypeMetadata)pmtm);
    }

    private void addAdapterField(IndentWriter iw, ProtoMessageTypeMetadata messageTypeMetadata) {
        iw.append((CharSequence)"private final ").append((CharSequence)messageTypeMetadata.getAnnotatedClassName()).append(' ').append((CharSequence)"__a$").append((CharSequence)" = new ").append((CharSequence)messageTypeMetadata.getAnnotatedClassName()).append((CharSequence)"();\n\n");
    }

    private void addMarshallerDelegateFields(IndentWriter iw, ProtoMessageTypeMetadata messageTypeMetadata) {
        HashSet<String> addedFields = new HashSet<String>();
        for (ProtoFieldMetadata fieldMetadata : messageTypeMetadata.getFields().values()) {
            this.addMarshallerDelegateField(iw, fieldMetadata, addedFields);
        }
    }

    private void addMarshallerDelegateField(IndentWriter iw, ProtoFieldMetadata fieldMetadata, Set<String> addedFields) {
        switch (fieldMetadata.getProtobufType()) {
            case GROUP: 
            case MESSAGE: 
            case ENUM: {
                String fieldName = this.makeMarshallerDelegateFieldName(fieldMetadata);
                if (!addedFields.add(fieldName)) break;
                Class marshallerDelegateClass = fieldMetadata.getJavaType().isEnum() ? EnumMarshallerDelegate.class : BaseMarshallerDelegate.class;
                iw.append((CharSequence)"private ").append((CharSequence)marshallerDelegateClass.getName()).append(' ').append((CharSequence)fieldName).append((CharSequence)";\n\n");
                break;
            }
            case MAP: {
                ProtoMapMetadata mapMetadata = (ProtoMapMetadata)fieldMetadata;
                this.addMarshallerDelegateField(iw, mapMetadata.getKey(), addedFields);
                this.addMarshallerDelegateField(iw, mapMetadata.getValue(), addedFields);
            }
        }
    }

    private void emitSource(String fqn, String source, ProtoTypeMetadata ptm) throws IOException {
        Element originatingElement = ((HasModelElement)ptm.getJavaClass()).getElement();
        this.generatedFilesWriter.addMarshallerSourceFile(fqn, source, originatingElement);
        this.generatedClasses.add(fqn);
    }

    public Set<String> getGeneratedClasses() {
        return this.generatedClasses;
    }
}

