/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.cli.handlers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.infinispan.server.cli.CliInterpreterException;
import org.infinispan.server.cli.handlers.CacheCommand;
import org.infinispan.server.cli.util.CliCommandBuffer;
import org.infinispan.server.cli.util.InfinispanUtil;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandHandlerProvider;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.util.HelpFormatter;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.manager.WildFlySecurityManager;

public class NoArgumentsCliCommandHandler
extends CommandHandlerWithArguments {
    protected final CacheCommand cacheCommand;
    protected final CliCommandBuffer buffer;
    protected final ArgumentWithoutValue help;

    public NoArgumentsCliCommandHandler(CacheCommand cacheCommand, CliCommandBuffer buffer) {
        this.cacheCommand = cacheCommand;
        this.buffer = buffer;
        this.help = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--help", "-h");
        this.help.setExclusive(true);
    }

    public boolean isAvailable(CommandContext ctx) {
        return ctx.getModelControllerClient() != null && InfinispanUtil.getCacheInfo(ctx).getContainer() != null;
    }

    public boolean isBatchMode(CommandContext ctx) {
        return false;
    }

    public void handle(CommandContext ctx) throws CommandLineException {
        this.recognizeArguments(ctx);
        if (this.help.isPresent(ctx.getParsedCommandLine())) {
            this.printHelp(ctx);
        } else if (this.buffer.append(this.buildCommandString(ctx), this.cacheCommand.getNesting())) {
            try {
                this.invokeCliRequestIfNeeded(ctx);
            }
            catch (CliInterpreterException e) {
                ctx.printLine(e.getLocalizedMessage());
            }
        }
    }

    protected void printHelp(CommandContext ctx) throws CommandLineException {
        String filename = "help/" + this.cacheCommand.getName() + ".txt";
        InputStream helpInput = WildFlySecurityManager.getClassLoaderPrivileged(NoArgumentsCliCommandHandler.class).getResourceAsStream(filename);
        if (helpInput != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(helpInput));
            try {
                HelpFormatter.format((CommandContext)ctx, (BufferedReader)reader);
            }
            catch (IOException e) {
                throw new CommandFormatException("Failed to read " + filename + ": " + e.getLocalizedMessage());
            }
            finally {
                StreamUtils.safeClose((Closeable)reader);
            }
        } else {
            throw new CommandFormatException("Failed to locate command description " + filename);
        }
    }

    protected void printResult(ModelNode result, CommandContext context) throws CommandLineException {
        if (result == null || !result.has("result")) {
            return;
        }
        context.printLine(result.get("result").asString());
    }

    private void invokeCliRequestIfNeeded(CommandContext context) throws CommandLineException, CliInterpreterException {
        this.printResult(InfinispanUtil.cliRequest(context, this.buffer.getCommandAndReset()), context);
    }

    private String buildCommandString(CommandContext ctx) {
        StringBuilder command = new StringBuilder(this.cacheCommand.getName());
        if (ctx.getArgumentsString() != null) {
            command.append(' ').append(ctx.getArgumentsString());
        }
        command.append('\n');
        return command.toString();
    }

    public static class EndProvider
    implements CommandHandlerProvider {
        public CommandHandler createCommandHandler(CommandContext ctx) {
            return new NoArgumentsCliCommandHandler(CacheCommand.END, CliCommandBuffer.INSTANCE);
        }

        public boolean isTabComplete() {
            return true;
        }

        public String[] getNames() {
            return new String[]{CacheCommand.END.getName()};
        }
    }

    public static class AbortProvider
    implements CommandHandlerProvider {
        public CommandHandler createCommandHandler(CommandContext ctx) {
            return new NoArgumentsCliCommandHandler(CacheCommand.ABORT, CliCommandBuffer.INSTANCE);
        }

        public boolean isTabComplete() {
            return true;
        }

        public String[] getNames() {
            return new String[]{CacheCommand.ABORT.getName()};
        }
    }
}

