/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.cli.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infinispan.server.cli.CliInterpreterException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.CommandLineParser;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class InfinispanUtil {
    private static final String SUBSYSTEM = "subsystem";
    private static final String INFINISPAN = "datagrid-infinispan";
    private static final String INFINISPAN_SUBSYSTEM = "/subsystem=datagrid-infinispan";
    private static final String CONTAINER_TYPE = "cache-container";
    private static final String CONTAINER_ADDRESS = "/subsystem=datagrid-infinispan/cache-container";

    private InfinispanUtil() {
    }

    public static List<String> getContainerNames(CommandContext ctx) throws OperationFormatException {
        OperationRequestAddress address = InfinispanUtil.buildOperationRequest(ctx, INFINISPAN_SUBSYSTEM);
        return Util.getNodeNames((ModelControllerClient)ctx.getModelControllerClient(), (OperationRequestAddress)address, (String)CONTAINER_TYPE);
    }

    public static boolean containsContainer(CommandContext ctx, String container) throws OperationFormatException {
        return new HashSet<String>(InfinispanUtil.getContainerNames(ctx)).contains(container);
    }

    public static void changeToContainer(CommandContext ctx, String container) throws CommandLineException {
        if (!InfinispanUtil.containsContainer(ctx, container)) {
            throw new CommandLineException("No such container: " + container);
        }
        OperationRequestAddress address = ctx.getCurrentNodePath();
        address.reset();
        address.toNode(SUBSYSTEM, INFINISPAN);
        address.toNode(CONTAINER_TYPE, container);
    }

    public static Map<String, List<String>> getCachesNames(CommandContext ctx, String container) throws CommandLineException {
        if (!InfinispanUtil.containsContainer(ctx, container)) {
            throw new CommandLineException("No such container: " + container);
        }
        OperationRequestAddress address = InfinispanUtil.buildOperationRequest(ctx, "/subsystem=datagrid-infinispan/cache-container=" + container);
        List cacheModes = Util.getNodeTypes((ModelControllerClient)ctx.getModelControllerClient(), (OperationRequestAddress)address);
        HashMap<String, List<String>> caches = new HashMap<String, List<String>>();
        for (String cacheMode : cacheModes) {
            caches.put(cacheMode, Util.getNodeNames((ModelControllerClient)ctx.getModelControllerClient(), (OperationRequestAddress)address, (String)cacheMode));
        }
        return caches;
    }

    public static void changeToCache(CommandContext ctx, String container, String cache) throws CommandLineException {
        Map<String, List<String>> caches = InfinispanUtil.getCachesNames(ctx, container);
        for (Map.Entry<String, List<String>> entry : caches.entrySet()) {
            if (!entry.getValue().contains(cache)) continue;
            InfinispanUtil.changeToContainer(ctx, container);
            OperationRequestAddress address = ctx.getCurrentNodePath();
            address.toNode(entry.getKey(), cache);
            return;
        }
    }

    public static void connect(CommandContext ctx, String container, String cache) throws CommandLineException {
        if (container == null) {
            List<String> containers = InfinispanUtil.getContainerNames(ctx);
            if (containers.isEmpty()) {
                throw new CommandLineException("No containers found!");
            }
            container = containers.get(0);
        }
        try {
            if (cache != null) {
                InfinispanUtil.changeToCache(ctx, container, cache);
                InfinispanUtil.cliRequest(ctx, "cache " + cache + "\n");
            } else {
                InfinispanUtil.changeToContainer(ctx, container);
            }
        }
        catch (CommandLineException e) {
            ctx.getCurrentNodePath().reset();
            throw e;
        }
        catch (CliInterpreterException e) {
            ctx.getCurrentNodePath().reset();
            throw new CommandLineException(e.getLocalizedMessage());
        }
    }

    public static void disconnect(CommandContext ctx) {
        ctx.getCurrentNodePath().reset();
    }

    public static ModelNode cliRequest(CommandContext ctx, String command) throws CommandLineException, CliInterpreterException {
        ModelNode response;
        ModelNode request = InfinispanUtil.buildCliRequest(ctx, command);
        ModelControllerClient client = ctx.getModelControllerClient();
        try {
            response = client.execute(request);
        }
        catch (Exception e) {
            throw new CommandFormatException("Failed to perform operation: " + e.getLocalizedMessage());
        }
        if (!Util.isSuccess((ModelNode)response)) {
            throw new CommandFormatException(Util.getFailureDescription((ModelNode)response));
        }
        if (!response.has("result")) {
            return null;
        }
        ModelNode result = response.get("result");
        if (Boolean.parseBoolean(result.get("isError").asString())) {
            throw new CliInterpreterException(result.get("result").asString());
        }
        InfinispanUtil.updateStateFromResponse(result, ctx);
        return result;
    }

    public static ModelNode buildCliRequest(CommandContext ctx, String command) throws CommandLineException {
        CacheInfo cacheInfo = InfinispanUtil.getCacheInfo(ctx);
        OperationRequestAddress requestAddress = InfinispanUtil.getContainerAddress(ctx, cacheInfo.getContainer());
        ModelNode req = Util.buildRequest((CommandContext)ctx, (OperationRequestAddress)requestAddress, (String)"cli-interpreter");
        InfinispanUtil.updateRequest(req, ctx, command, cacheInfo);
        return req;
    }

    public static void updateStateFromResponse(ModelNode node, CommandContext context) {
        if (node.has("sessionId")) {
            context.set(InfinispanUtil.getCacheInfo(context).getContainer() + "-sessionId", (Object)node.get("sessionId").asString());
        }
    }

    public static OperationRequestAddress buildOperationRequest(CommandContext ctx, String address) throws OperationFormatException {
        DefaultCallbackHandler handler = new DefaultCallbackHandler();
        ctx.getCommandLineParser().parse(address, (CommandLineParser.CallbackHandler)handler);
        return handler.getAddress();
    }

    public static CacheInfo getCacheInfo(CommandContext context) {
        String container = null;
        String cache = null;
        Iterator iterator = context.getCurrentNodePath().iterator();
        for (int i = 0; i < 3 && iterator.hasNext(); ++i) {
            OperationRequestAddress.Node node = (OperationRequestAddress.Node)iterator.next();
            if (node.getType().equals(CONTAINER_TYPE)) {
                container = node.getName();
                continue;
            }
            if (!node.getType().endsWith("-cache")) continue;
            cache = node.getName();
        }
        return new CacheInfo(container, cache);
    }

    private static void updateRequest(ModelNode request, CommandContext context, String command, CacheInfo cacheInfo) {
        InfinispanUtil.setInModelNode(request, "cacheName", cacheInfo.getCache());
        InfinispanUtil.setInModelNode(request, "sessionId", (String)context.get(cacheInfo.getContainer() + "-sessionId"));
        InfinispanUtil.setInModelNode(request, "command", command);
    }

    private static void setInModelNode(ModelNode node, String key, String value) {
        if (value != null) {
            node.get(key).set(value);
        }
    }

    private static OperationRequestAddress getContainerAddress(CommandContext ctx, String container) throws CommandLineException {
        if (container == null) {
            throw new CommandLineException("Container does not exists");
        }
        return InfinispanUtil.buildOperationRequest(ctx, "/subsystem=datagrid-infinispan/cache-container=" + container);
    }

    public static class CacheInfo {
        private final String container;
        private final String cache;

        public CacheInfo(String container, String cache) {
            this.container = container;
            this.cache = cache;
        }

        public String getContainer() {
            return this.container;
        }

        public String getCache() {
            return this.cache;
        }
    }
}

