/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.SubjectUserInfo;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.subsystem.RealmSubjectUserInfo;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.wildfly.security.auth.callback.AvailableRealmsCallback;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;

public class EndpointServerAuthenticationProvider
implements ServerAuthenticationProvider {
    private static final String SASL_OPT_PRE_DIGESTED_PROPERTY = "org.wildfly.security.sasl.digest.pre_digested";
    private final SecurityRealm realm;
    private String[] realmList;

    EndpointServerAuthenticationProvider(SecurityRealm realm) {
        this.realm = realm;
    }

    public org.infinispan.server.core.security.AuthorizingCallbackHandler getCallbackHandler(String mechanismName, Map<String, String> mechanismProperties) {
        if ("GSSAPI".equals(mechanismName)) {
            return new GSSAPIEndpointAuthorizingCallbackHandler();
        }
        if ("PLAIN".equals(mechanismName)) {
            return new RealmAuthorizingCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.PLAIN));
        }
        if ("DIGEST-MD5".equals(mechanismName)) {
            String[] stringArray;
            String realmStr = mechanismProperties.get("com.sun.security.sasl.digest.realm");
            if (realmStr == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.realm.getName();
            } else {
                stringArray = realmStr.split(" ");
            }
            this.realmList = stringArray;
            Map mechConfig = this.realm.getMechanismConfig(AuthMechanism.DIGEST);
            boolean plainTextDigest = true;
            if (mechConfig.containsKey("org.jboss.as.domain.management.digest.plain_text")) {
                plainTextDigest = Boolean.parseBoolean((String)mechConfig.get("org.jboss.as.domain.management.digest.plain_text"));
            }
            if (!plainTextDigest) {
                mechanismProperties.put(SASL_OPT_PRE_DIGESTED_PROPERTY, "true");
            }
            return new RealmAuthorizingCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.DIGEST));
        }
        if ("EXTERNAL".equals(mechanismName)) {
            return new RealmAuthorizingCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.CLIENT_CERT));
        }
        throw new IllegalArgumentException("Unsupported mech " + mechanismName);
    }

    public class RealmAuthorizingCallbackHandler
    implements org.infinispan.server.core.security.AuthorizingCallbackHandler {
        private final AuthorizingCallbackHandler delegate;

        RealmAuthorizingCallbackHandler(AuthorizingCallbackHandler authorizingCallbackHandler) {
            this.delegate = authorizingCallbackHandler;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            ArrayList<Callback> list = new ArrayList<Callback>(Arrays.asList(callbacks));
            Iterator<Callback> it = list.iterator();
            CredentialCallback cb = null;
            while (it.hasNext()) {
                Callback callback = it.next();
                if (callback instanceof AvailableRealmsCallback) {
                    ((AvailableRealmsCallback)callback).setRealmNames(EndpointServerAuthenticationProvider.this.realmList);
                    it.remove();
                    continue;
                }
                if (!(callback instanceof CredentialCallback)) continue;
                cb = (CredentialCallback)callback;
            }
            if (!list.isEmpty()) {
                if (cb != null && cb.getAlgorithm().equals("digest-md5")) {
                    DigestPasswordAlgorithmSpec spec = (DigestPasswordAlgorithmSpec)cb.getParameterSpec();
                    list.add(new NameCallback("User", spec.getUsername()));
                    callbacks = list.toArray(new Callback[list.size()]);
                }
                this.delegate.handle(callbacks);
            }
        }

        public SubjectUserInfo getSubjectUserInfo(Collection<Principal> principals) {
            try {
                org.jboss.as.core.security.SubjectUserInfo realmUserInfo = this.delegate.createSubjectUserInfo(principals);
                return new RealmSubjectUserInfo(realmUserInfo.getUserName(), realmUserInfo.getSubject());
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    public class GSSAPIEndpointAuthorizingCallbackHandler
    implements org.infinispan.server.core.security.AuthorizingCallbackHandler {
        private final AuthorizingCallbackHandler delegate;
        private RealmUser realmUser;

        GSSAPIEndpointAuthorizingCallbackHandler() {
            this.delegate = EndpointServerAuthenticationProvider.this.realm.getAuthorizingCallbackHandler(AuthMechanism.PLAIN);
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof AvailableRealmsCallback) {
                    ((AvailableRealmsCallback)callback).setRealmNames(new String[]{EndpointServerAuthenticationProvider.this.realm.getName()});
                    continue;
                }
                if (!(callback instanceof AuthorizeCallback)) continue;
                AuthorizeCallback acb = (AuthorizeCallback)callback;
                String authenticationId = acb.getAuthenticationID();
                String authorizationId = acb.getAuthorizationID();
                acb.setAuthorized(authenticationId.equals(authorizationId));
                int realmSep = authorizationId.indexOf(64);
                this.realmUser = realmSep <= 0 ? new RealmUser(authorizationId) : new RealmUser(authorizationId.substring(realmSep + 1), authorizationId.substring(0, realmSep));
            }
        }

        public SubjectUserInfo getSubjectUserInfo(Collection<Principal> principals) {
            ArrayList<RealmUser> realmPrincipals = new ArrayList<RealmUser>();
            realmPrincipals.add(this.realmUser);
            try {
                org.jboss.as.core.security.SubjectUserInfo userInfo = this.delegate.createSubjectUserInfo(realmPrincipals);
                userInfo.getPrincipals().addAll(principals);
                return new RealmSubjectUserInfo(userInfo);
            }
            catch (IOException e) {
                throw EndpointLogger.ROOT_LOGGER.cannotRetrieveAuthorizationInformation(e, this.realmUser.toString());
            }
        }
    }
}

