/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.Optional;
import org.infinispan.server.endpoint.subsystem.EndpointUtils;
import org.infinispan.server.endpoint.subsystem.MultiTenantHotRodResource;
import org.infinispan.server.endpoint.subsystem.MultiTenantRestResource;
import org.infinispan.server.endpoint.subsystem.PrefixResource;
import org.infinispan.server.endpoint.subsystem.RouterConnectorResource;
import org.infinispan.server.endpoint.subsystem.RouterService;
import org.infinispan.server.endpoint.subsystem.SinglePortHotRodResource;
import org.infinispan.server.endpoint.subsystem.SinglePortResource;
import org.infinispan.server.endpoint.subsystem.SinglePortRestResource;
import org.infinispan.server.endpoint.subsystem.SniResource;
import org.infinispan.server.router.configuration.builder.RouterConfigurationBuilder;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

class RouterSubsystemAdd
extends AbstractAddStepHandler {
    static final RouterSubsystemAdd INSTANCE = new RouterSubsystemAdd();

    RouterSubsystemAdd() {
    }

    protected void populateModel(ModelNode source, ModelNode target) throws OperationFailedException {
        for (SimpleAttributeDefinition attr : RouterConnectorResource.ROUTER_CONNECTOR_ATTRIBUTES) {
            attr.validateAndSet(source, target);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode config = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        RouterConfigurationBuilder configuration = new RouterConfigurationBuilder();
        RouterService routerService = new RouterService(configuration, this.getServiceName(config));
        ServiceName routerServiceName = EndpointUtils.getServiceName(operation, "router");
        ServiceBuilder builder = context.getServiceTarget().addService(routerServiceName, (Service)routerService);
        ModelNode multiTenancyInnerConfiguration = config.get(new String[]{"multi-tenancy", "MULTI_TENANCY"});
        ModelNode SinglePortInnerConfiguration = config.get(new String[]{"single-port", "SINGLE_PORT"});
        this.addMultiTenantRest(context, operation, multiTenancyInnerConfiguration, routerService, builder);
        this.addMultiTenantHotRod(context, operation, multiTenancyInnerConfiguration, routerService, builder);
        this.addSinglePortHotRod(context, operation, SinglePortInnerConfiguration, routerService, builder);
        builder.install();
    }

    private void addSinglePortHotRod(OperationContext context, ModelNode operation, ModelNode config, RouterService routerService, ServiceBuilder<?> builder) throws OperationFailedException {
        if (config.isDefined()) {
            EndpointUtils.addSocketBindingDependency(context, builder, operation.get("single-port-socket-binding").asString(), routerService.getSinglePortSocketBinding());
            RouterService.SinglePortRouting singlePortRouting = routerService.getSinglePortRouting();
            ModelNode hotRodModelNode = ((ModelNode)config.get("hotrod").asList().get(0)).get(0);
            ModelNode restModelNode = ((ModelNode)config.get("rest").asList().get(0)).get(0);
            ModelNode securityRealmModelNode = SinglePortResource.SECURITY_REALM.resolveModelAttribute(context, config);
            String securityRealm = securityRealmModelNode.asString();
            String hotRodServerName = SinglePortHotRodResource.NAME.resolveModelAttribute(context, hotRodModelNode).asString();
            String restServerName = SinglePortRestResource.NAME.resolveModelAttribute(context, restModelNode).asString();
            if (hotRodModelNode.isDefined()) {
                EndpointUtils.addHotRodDependency(builder, hotRodServerName, singlePortRouting.getHotrodServer());
            }
            if (restModelNode.isDefined()) {
                EndpointUtils.addRestDependency(builder, restServerName, singlePortRouting.getRestServer());
            }
            if (securityRealmModelNode.isDefined()) {
                EndpointUtils.addSecurityRealmDependency(builder, securityRealm, singlePortRouting.getSecurityRealm());
            }
        }
    }

    private void addMultiTenantRest(OperationContext context, ModelNode operation, ModelNode config, RouterService routerService, ServiceBuilder<?> builder) throws OperationFailedException {
        if (config.get("rest").isDefined()) {
            EndpointUtils.addSocketBindingDependency(context, builder, operation.get("rest-socket-binding").asString(), routerService.getRestSocketBinding());
            for (ModelNode r : config.get("rest").asList()) {
                ModelNode restNode = r.get(0);
                String restName = MultiTenantRestResource.NAME.resolveModelAttribute(context, restNode).asString();
                if (!restNode.get("prefix").isDefined()) continue;
                for (ModelNode prefixNode : restNode.get("prefix").asList()) {
                    String pathPrefix = PrefixResource.PATH.resolveModelAttribute(context, prefixNode.get(0)).asString();
                    RouterService.RestRouting restRouting = routerService.getRestRouting(pathPrefix, restName);
                    EndpointUtils.addRestDependency(builder, restName, restRouting.getRest());
                }
            }
        }
    }

    private void addMultiTenantHotRod(OperationContext context, ModelNode operation, ModelNode config, RouterService routerService, ServiceBuilder<?> builder) throws OperationFailedException {
        if (config.get("hotrod").isDefined()) {
            EndpointUtils.addSocketBindingDependency(context, builder, operation.get("hotrod-socket-binding").asString(), routerService.getHotrodSocketBinding());
            for (ModelNode hr : config.get("hotrod").asList()) {
                ModelNode hotRod = hr.get(0);
                String hotRodName = MultiTenantHotRodResource.NAME.resolveModelAttribute(context, hotRod).asString();
                routerService.tcpNoDelay(RouterConnectorResource.TCP_NODELAY.resolveModelAttribute(context, hotRod).asBoolean());
                routerService.tcpKeepAlive(RouterConnectorResource.TCP_KEEPALIVE.resolveModelAttribute(context, hotRod).asBoolean());
                routerService.sendBufferSize(RouterConnectorResource.SEND_BUFFER_SIZE.resolveModelAttribute(context, hotRod).asInt());
                routerService.receiveBufferSize(RouterConnectorResource.RECEIVE_BUFFER_SIZE.resolveModelAttribute(context, hotRod).asInt());
                if (!hotRod.get("sni").isDefined()) continue;
                for (ModelNode sni : hotRod.get("sni").asList()) {
                    ModelNode sniNode = sni.get(0);
                    String sniHostName = SniResource.HOST_NAME.resolveModelAttribute(context, sniNode).asString();
                    String securityRealm = SniResource.SECURITY_REALM.resolveModelAttribute(context, sniNode).asString();
                    RouterService.HotRodRouting hotRodRouting = routerService.getHotRodRouting(sniHostName);
                    EndpointUtils.addHotRodDependency(builder, hotRodName, hotRodRouting.getHotRod());
                    EndpointUtils.addSecurityRealmDependency(builder, securityRealm, hotRodRouting.getSecurityRealm());
                }
            }
        }
    }

    private Optional<String> getServiceName(ModelNode config) {
        return Optional.ofNullable(config.get("name")).map(ModelNode::asString);
    }
}

