/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.eventlogger;

import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.server.eventlogger.PersistenceContextInitializerImpl;
import org.infinispan.server.eventlogger.ServerEventLogger;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.EventLogger;

@InfinispanModule(name="server-event-logger", requiredModules={"core"})
public class LifecycleCallbacks
implements ModuleLifecycle {
    private EventLogger oldEventLogger;

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration gc) {
        BasicComponentRegistry bcr = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
        PersistenceMarshaller persistenceMarshaller = (PersistenceMarshaller)bcr.getComponent("org.infinispan.marshaller.persistence", PersistenceMarshaller.class).wired();
        persistenceMarshaller.register((SerializationContextInitializer)new PersistenceContextInitializerImpl());
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class);
        InternalCacheRegistry internalCacheRegistry = (InternalCacheRegistry)gcr.getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.registerInternalCache("___event_log_cache", this.getTaskHistoryCacheConfiguration(cacheManager).build(), EnumSet.of(InternalCacheRegistry.Flag.PERSISTENT, InternalCacheRegistry.Flag.QUERYABLE));
        this.oldEventLogger = ((EventLogManager)gcr.getComponent(EventLogManager.class)).replaceEventLogger((EventLogger)new ServerEventLogger(cacheManager, gcr.getTimeService()));
    }

    public void cacheManagerStopping(GlobalComponentRegistry gcr) {
        ((EventLogManager)gcr.getComponent(EventLogManager.class)).replaceEventLogger(this.oldEventLogger);
    }

    private ConfigurationBuilder getTaskHistoryCacheConfiguration(EmbeddedCacheManager cacheManager) {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.memory().size(100L).persistence().passivation(true).expiration().lifespan(7L, TimeUnit.DAYS);
        return cfg;
    }
}

