/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.eventlogger;

import java.time.Instant;
import java.util.Optional;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.util.logging.events.EventLog;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;

public class ServerEventImpl
implements EventLog {
    private Instant when;
    @ProtoField(number=1)
    EventLogLevel level;
    @ProtoField(number=2)
    EventLogCategory category;
    @ProtoField(number=3)
    String message;
    @ProtoField(number=5, name="detail")
    String detail;
    @ProtoField(number=6, name="who")
    String who;
    @ProtoField(number=7, name="context")
    String context;
    @ProtoField(number=8, name="scope")
    String scope;

    @ProtoField(number=4, name="epoch", defaultValue="0")
    long getEpoch() {
        return this.when.getEpochSecond();
    }

    ServerEventImpl() {
    }

    ServerEventImpl(EventLogLevel level, EventLogCategory category, Instant when, String message, String detail, String context, String who, String scope) {
        this.level = level;
        this.category = category;
        this.message = message;
        this.when = when;
        this.detail = detail;
        this.context = context;
        this.who = who;
        this.scope = scope;
    }

    ServerEventImpl(EventLogLevel level, EventLogCategory category, Instant when, String message) {
        this(level, category, when, message, null, null, null, null);
    }

    public Instant getWhen() {
        return this.when;
    }

    public EventLogLevel getLevel() {
        return this.level;
    }

    public EventLogCategory getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public Optional<String> getDetail() {
        return Optional.ofNullable(this.detail);
    }

    public Optional<String> getWho() {
        return Optional.ofNullable(this.who);
    }

    public Optional<String> getContext() {
        return Optional.ofNullable(this.context);
    }

    public Optional<String> getScope() {
        return Optional.ofNullable(this.scope);
    }

    void setEpoch(long epoch) {
        this.when = Instant.ofEpochSecond(epoch);
    }

    public int compareTo(EventLog that) {
        return that.getWhen().compareTo(this.when);
    }

    public String toString() {
        return "ServerEventImpl{level=" + this.level + ", category=" + this.category + ", when=" + this.when + ", message='" + this.message + '\'' + ", detail=" + this.detail + ", context=" + this.context + ", who=" + this.who + ", scope=" + this.scope + '}';
    }
}

