/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.eventlogger;

import java.io.File;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.eventlogger.ServerEventLogger;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.MultiCacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.events.EventLog;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.EventLogger;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="server.eventlogger.ServerEventLoggerTest", groups={"functional"})
public class ServerEventLoggerTest
extends AbstractInfinispanTest {
    public void testLocalServerEventLogging() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            public void call() throws Exception {
                this.cm.getCache();
                EventLogger eventLogger = EventLogManager.getEventLogger((EmbeddedCacheManager)this.cm);
                AssertJUnit.assertTrue((String)eventLogger.getClass().getName(), (boolean)(eventLogger instanceof ServerEventLogger));
                eventLogger.info(EventLogCategory.CLUSTER, "message #1");
                eventLogger.info(EventLogCategory.TASKS, "message #2");
                eventLogger.warn(EventLogCategory.CLUSTER, "message #3");
                eventLogger.warn(EventLogCategory.TASKS, "message #4");
                List events = eventLogger.getEvents(Instant.now(), 10, Optional.of(EventLogCategory.CLUSTER), Optional.empty());
                AssertJUnit.assertEquals((int)2, (int)events.size());
                AssertJUnit.assertEquals((String)"message #3", (String)((EventLog)events.get(0)).getMessage());
                AssertJUnit.assertEquals((Object)EventLogLevel.WARN, (Object)((EventLog)events.get(0)).getLevel());
                AssertJUnit.assertEquals((String)"message #1", (String)((EventLog)events.get(1)).getMessage());
                AssertJUnit.assertEquals((Object)EventLogLevel.INFO, (Object)((EventLog)events.get(1)).getLevel());
                events = eventLogger.getEvents(Instant.now(), 10, Optional.empty(), Optional.of(EventLogLevel.INFO));
                AssertJUnit.assertEquals((int)2, (int)events.size());
                AssertJUnit.assertEquals((String)"message #2", (String)((EventLog)events.get(0)).getMessage());
                AssertJUnit.assertEquals((Object)EventLogCategory.TASKS, (Object)((EventLog)events.get(0)).getCategory());
                AssertJUnit.assertEquals((String)"message #1", (String)((EventLog)events.get(1)).getMessage());
                AssertJUnit.assertEquals((Object)EventLogCategory.CLUSTER, (Object)((EventLog)events.get(1)).getCategory());
            }
        });
    }

    public void testClusteredServerEventLogging() {
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager((CacheMode)CacheMode.DIST_SYNC, (boolean)false), TestCacheManagerFactory.createCacheManager((CacheMode)CacheMode.DIST_SYNC, (boolean)false), TestCacheManagerFactory.createCacheManager((CacheMode)CacheMode.DIST_SYNC, (boolean)false)}){

            public void call() throws Exception {
                EventLogger eventLogger;
                int i;
                int msg = 1;
                TestingUtil.blockUntilViewReceived((Cache)this.cms[0].getCache(), (int)3);
                for (i = 0; i < this.cms.length; ++i) {
                    eventLogger = EventLogManager.getEventLogger((EmbeddedCacheManager)this.cms[i]);
                    AssertJUnit.assertTrue((String)eventLogger.getClass().getName(), (boolean)(eventLogger instanceof ServerEventLogger));
                    eventLogger.info(EventLogCategory.SECURITY, "message #" + Integer.toString(msg++));
                    eventLogger.warn(EventLogCategory.SECURITY, "message #" + Integer.toString(msg++));
                    eventLogger.info(EventLogCategory.TASKS, "message #" + Integer.toString(msg++));
                    eventLogger.warn(EventLogCategory.TASKS, "message #" + Integer.toString(msg++));
                }
                for (i = 0; i < this.cms.length; ++i) {
                    eventLogger = EventLogManager.getEventLogger((EmbeddedCacheManager)this.cms[i]);
                    List events = eventLogger.getEvents(Instant.now(), 10, Optional.of(EventLogCategory.TASKS), Optional.empty());
                    AssertJUnit.assertEquals((String)("Result count discrepancy on node " + i), (int)(2 * this.cms.length), (int)events.size());
                    for (EventLog event : events) {
                        AssertJUnit.assertEquals((Object)EventLogCategory.TASKS, (Object)event.getCategory());
                    }
                    events = eventLogger.getEvents(Instant.now(), 10, Optional.empty(), Optional.of(EventLogLevel.INFO));
                    for (EventLog event : events) {
                        AssertJUnit.assertEquals((Object)EventLogLevel.INFO, (Object)event.getLevel());
                    }
                }
            }
        });
    }

    public void testLocalServerEventLoggingPreloading() {
        ServerEventLoggerTest.deleteGlobalPersistentState();
        EmbeddedCacheManager cm = this.startCacheManager();
        EventLogger eventLogger = EventLogManager.getEventLogger((EmbeddedCacheManager)cm);
        eventLogger.info(EventLogCategory.CLUSTER, "message #1");
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm});
        cm = this.startCacheManager();
        eventLogger = EventLogManager.getEventLogger((EmbeddedCacheManager)cm);
        eventLogger.info(EventLogCategory.CLUSTER, "message #5");
    }

    public EmbeddedCacheManager startCacheManager() {
        GlobalConfigurationBuilder globaCfg = new GlobalConfigurationBuilder();
        globaCfg.globalState().enable();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globaCfg, (ConfigurationBuilder)new ConfigurationBuilder());
        cm.getCache();
        return cm;
    }

    private static void deleteGlobalPersistentState() {
        GlobalConfiguration globalCfg = new GlobalConfigurationBuilder().build();
        new File(globalCfg.globalState().persistentLocation() + "/___event_log_cache.dat").delete();
    }
}

