/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.BaseJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.ClusterLoaderResource;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResource;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResource;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.LoaderPropertyResource;
import org.jboss.as.clustering.infinispan.subsystem.LoaderResource;
import org.jboss.as.clustering.infinispan.subsystem.LockingResource;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResource;
import org.jboss.as.clustering.infinispan.subsystem.StorePropertyResource;
import org.jboss.as.clustering.infinispan.subsystem.StoreResource;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResource;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResource;
import org.jboss.as.clustering.infinispan.subsystem.TransportResource;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;

public class CacheConfigOperationHandlers {
    static final OperationStepHandler TRANSPORT_ADD = new CacheConfigAdd(TransportResource.TRANSPORT_ATTRIBUTES);
    static final OperationStepHandler LOCKING_ADD = new CacheConfigAdd(LockingResource.LOCKING_ATTRIBUTES);
    static final OperationStepHandler TRANSACTION_ADD = new CacheConfigAdd(TransactionResource.TRANSACTION_ATTRIBUTES);
    static final OperationStepHandler EVICTION_ADD = new CacheConfigAdd(EvictionResource.EVICTION_ATTRIBUTES);
    static final OperationStepHandler EXPIRATION_ADD = new CacheConfigAdd(ExpirationResource.EXPIRATION_ATTRIBUTES);
    static final OperationStepHandler STATE_TRANSFER_ADD = new CacheConfigAdd(StateTransferResource.STATE_TRANSFER_ATTRIBUTES);
    static final OperationStepHandler LOADER_ADD = new CacheLoaderAdd();
    static final OperationStepHandler LOADER_PROPERTY_ADD = new CacheConfigAdd(new AttributeDefinition[]{LoaderPropertyResource.VALUE});
    static final OperationStepHandler CLUSTER_LOADER_ADD = new ClusterCacheLoaderAdd();
    static final OperationStepHandler STORE_ADD = new CacheStoreAdd();
    static final OperationStepHandler STORE_WRITE_BEHIND_ADD = new CacheConfigAdd(StoreWriteBehindResource.WRITE_BEHIND_ATTRIBUTES);
    static final OperationStepHandler STORE_PROPERTY_ADD = new CacheConfigAdd(new AttributeDefinition[]{StorePropertyResource.VALUE});
    static final OperationStepHandler FILE_STORE_ADD = new FileCacheStoreAdd();
    static final OperationStepHandler STRING_KEYED_JDBC_STORE_ADD = new StringKeyedJDBCCacheStoreAdd();
    static final OperationStepHandler BINARY_KEYED_JDBC_STORE_ADD = new BinaryKeyedJDBCCacheStoreAdd();
    static final OperationStepHandler MIXED_KEYED_JDBC_STORE_ADD = new MixedKeyedJDBCCacheStoreAdd();
    static final OperationStepHandler REMOTE_STORE_ADD = new RemoteCacheStoreAdd();

    private static PathAddress getCacheAddress(ModelNode operation) {
        PathAddress cacheStoreAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress cacheAddress = cacheStoreAddress.subAddress(0, cacheStoreAddress.size() - 1);
        return cacheAddress;
    }

    private static ModelNode getCache(OperationContext context, PathAddress cacheAddress) {
        ModelNode cache = Resource.Tools.readModel((Resource)context.readResourceFromRoot(cacheAddress));
        return cache;
    }

    private static boolean isCacheLoaderDefined(OperationContext context, ModelNode operation) {
        ModelNode cache = CacheConfigOperationHandlers.getCache(context, CacheConfigOperationHandlers.getCacheAddress(operation));
        return CacheConfigOperationHandlers.hasCustomLoader(cache) || CacheConfigOperationHandlers.hasClusterLoader(cache);
    }

    private static String getDefinedCacheLoader(OperationContext context, ModelNode operation) {
        ModelNode cache = CacheConfigOperationHandlers.getCache(context, CacheConfigOperationHandlers.getCacheAddress(operation));
        if (CacheConfigOperationHandlers.hasCustomLoader(cache)) {
            return "loader";
        }
        if (CacheConfigOperationHandlers.hasClusterLoader(cache)) {
            return "cluster-loader";
        }
        return null;
    }

    private static boolean hasCustomLoader(ModelNode cache) {
        return cache.hasDefined("loader") && cache.get(new String[]{"loader", "LOADER"}).isDefined();
    }

    private static boolean hasClusterLoader(ModelNode cache) {
        return cache.hasDefined("cluster-loader") && cache.get(new String[]{"cluster-loader", "CLUSTER_LOADER"}).isDefined();
    }

    private static boolean isCacheStoreDefined(OperationContext context, ModelNode operation) {
        ModelNode cache = CacheConfigOperationHandlers.getCache(context, CacheConfigOperationHandlers.getCacheAddress(operation));
        return CacheConfigOperationHandlers.hasCustomStore(cache) || CacheConfigOperationHandlers.hasFileStore(cache) || CacheConfigOperationHandlers.hasStringKeyedJdbcStore(cache) || CacheConfigOperationHandlers.hasBinaryKeyedJdbcStore(cache) || CacheConfigOperationHandlers.hasMixedKeyedJdbcStore(cache) || CacheConfigOperationHandlers.hasRemoteStore(cache);
    }

    private static String getDefinedCacheStore(OperationContext context, ModelNode operation) {
        ModelNode cache = CacheConfigOperationHandlers.getCache(context, CacheConfigOperationHandlers.getCacheAddress(operation));
        if (CacheConfigOperationHandlers.hasCustomStore(cache)) {
            return "store";
        }
        if (CacheConfigOperationHandlers.hasFileStore(cache)) {
            return "file-store";
        }
        if (CacheConfigOperationHandlers.hasStringKeyedJdbcStore(cache)) {
            return "string-keyed-jdbc-store";
        }
        if (CacheConfigOperationHandlers.hasBinaryKeyedJdbcStore(cache)) {
            return "binary-keyed-jdbc-store";
        }
        if (CacheConfigOperationHandlers.hasMixedKeyedJdbcStore(cache)) {
            return "mixed-keyed-jdbc-store";
        }
        if (CacheConfigOperationHandlers.hasRemoteStore(cache)) {
            return "remote-store";
        }
        return null;
    }

    private static boolean hasCustomStore(ModelNode cache) {
        return cache.hasDefined("store") && cache.get(new String[]{"store", "STORE"}).isDefined();
    }

    private static boolean hasFileStore(ModelNode cache) {
        return cache.hasDefined("file-store") && cache.get(new String[]{"file-store", "FILE_STORE"}).isDefined();
    }

    private static boolean hasStringKeyedJdbcStore(ModelNode cache) {
        return cache.hasDefined("string-keyed-jdbc-store") && cache.get(new String[]{"string-keyed-jdbc-store", "STRING_KEYED_JDBC_STORE"}).isDefined();
    }

    private static boolean hasBinaryKeyedJdbcStore(ModelNode cache) {
        return cache.hasDefined("binary-keyed-jdbc-store") && cache.get(new String[]{"binary-keyed-jdbc-store", "BINARY_KEYED_JDBC_STORE"}).isDefined();
    }

    private static boolean hasMixedKeyedJdbcStore(ModelNode cache) {
        return cache.hasDefined("mixed-keyed-jdbc-store") && cache.get(new String[]{"mixed-keyed-jdbc-store", "MIXED_KEYED_JDBC_STORE"}).isDefined();
    }

    private static boolean hasRemoteStore(ModelNode cache) {
        return cache.hasDefined("remote-store") && cache.get(new String[]{"remote-store", "REMOTE_STORE"}).isDefined();
    }

    private static class RemoteCacheStoreAdd
    extends AbstractCacheStoreAdd {
        private final AttributeDefinition[] attributes = RemoteStoreResource.REMOTE_STORE_ATTRIBUTES;

        RemoteCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class MixedKeyedJDBCCacheStoreAdd
    extends JDBCCacheStoreAdd {
        private final AttributeDefinition[] attributes = MixedKeyedJDBCStoreResource.MIXED_KEYED_JDBC_STORE_ATTRIBUTES;

        MixedKeyedJDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateSubclassModel(context, operation, model);
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class BinaryKeyedJDBCCacheStoreAdd
    extends JDBCCacheStoreAdd {
        private final AttributeDefinition[] attributes = BinaryKeyedJDBCStoreResource.BINARY_KEYED_JDBC_STORE_ATTRIBUTES;

        BinaryKeyedJDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateSubclassModel(context, operation, model);
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class StringKeyedJDBCCacheStoreAdd
    extends JDBCCacheStoreAdd {
        private final AttributeDefinition[] attributes = StringKeyedJDBCStoreResource.STRING_KEYED_JDBC_STORE_ATTRIBUTES;

        StringKeyedJDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateSubclassModel(context, operation, model);
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class JDBCCacheStoreAdd
    extends AbstractCacheStoreAdd {
        private final AttributeDefinition[] attributes = BaseJDBCStoreResource.COMMON_JDBC_STORE_ATTRIBUTES;

        JDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class FileCacheStoreAdd
    extends AbstractCacheStoreAdd {
        private final AttributeDefinition[] attributes = FileStoreResource.FILE_STORE_ATTRIBUTES;

        FileCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class CacheStoreAdd
    extends AbstractCacheStoreAdd {
        private final AttributeDefinition[] attributes = StoreResource.STORE_ATTRIBUTES;

        CacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    static abstract class AbstractCacheStoreAdd
    extends AbstractAddStepHandler {
        private final AttributeDefinition[] attributes = BaseStoreResource.COMMON_STORE_PARAMETERS;

        AbstractCacheStoreAdd() {
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            ModelNode model = resource.getModel();
            if (CacheConfigOperationHandlers.isCacheStoreDefined(context, operation)) {
                String storeName = CacheConfigOperationHandlers.getDefinedCacheStore(context, operation);
                throw InfinispanMessages.MESSAGES.cacheStoreAlreadyDefined(storeName);
            }
            for (AttributeDefinition attribute : this.attributes) {
                if (attribute.getName().equals(BaseStoreResource.PROPERTIES.getName())) continue;
                attribute.validateAndSet(operation, model);
            }
            this.populateSubclassModel(context, operation, model);
            if (operation.hasDefined("properties")) {
                for (Property property : operation.get("properties").asPropertyList()) {
                    Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"property", (String)property.getName())}));
                    ModelNode value = property.getValue();
                    if (!value.isDefined()) {
                        throw InfinispanMessages.MESSAGES.propertyValueNotDefined(property.getName());
                    }
                    param.getModel().get("value").set(value);
                }
            }
        }

        abstract void populateSubclassModel(OperationContext var1, ModelNode var2, ModelNode var3) throws OperationFailedException;

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        }
    }

    private static class ClusterCacheLoaderAdd
    extends AbstractCacheLoaderAdd {
        private final AttributeDefinition[] attributes = ClusterLoaderResource.CLUSTER_LOADER_ATTRIBUTES;

        ClusterCacheLoaderAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class CacheLoaderAdd
    extends AbstractCacheLoaderAdd {
        private final AttributeDefinition[] attributes = LoaderResource.LOADER_ATTRIBUTES;

        CacheLoaderAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    static abstract class AbstractCacheLoaderAdd
    extends AbstractAddStepHandler {
        private final AttributeDefinition[] attributes = BaseStoreResource.COMMON_LOADER_PARAMETERS;

        AbstractCacheLoaderAdd() {
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            ModelNode model = resource.getModel();
            if (CacheConfigOperationHandlers.isCacheLoaderDefined(context, operation)) {
                String loaderName = CacheConfigOperationHandlers.getDefinedCacheLoader(context, operation);
                throw InfinispanMessages.MESSAGES.cacheLoaderAlreadyDefined(loaderName);
            }
            for (AttributeDefinition attribute : this.attributes) {
                if (attribute.getName().equals(BaseStoreResource.PROPERTIES.getName())) continue;
                attribute.validateAndSet(operation, model);
            }
            this.populateSubclassModel(context, operation, model);
            if (operation.hasDefined("properties")) {
                for (Property property : operation.get("properties").asPropertyList()) {
                    Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"property", (String)property.getName())}));
                    ModelNode value = property.getValue();
                    if (!value.isDefined()) {
                        throw InfinispanMessages.MESSAGES.propertyValueNotDefined(property.getName());
                    }
                    param.getModel().get("value").set(value);
                }
            }
        }

        abstract void populateSubclassModel(OperationContext var1, ModelNode var2, ModelNode var3) throws OperationFailedException;

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        }
    }

    public static class CacheConfigAdd
    extends AbstractAddStepHandler {
        private final AttributeDefinition[] attributes;

        CacheConfigAdd(AttributeDefinition[] attributes) {
            this.attributes = attributes;
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attr : this.attributes) {
                attr.validateAndSet(operation, model);
            }
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
            super.performRuntime(context, operation, model, verificationHandler, newControllers);
            context.reloadRequired();
        }
    }
}

