/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.affinity;

import java.util.Collections;
import java.util.concurrent.Executor;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyAffinityServiceImpl;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;

public class LocalKeyAffinityServiceFactory
implements KeyAffinityServiceFactory {
    private final Executor executor;
    private final int bufferSize;

    public LocalKeyAffinityServiceFactory(Executor executor, int bufferSize) {
        this.executor = executor;
        this.bufferSize = bufferSize;
    }

    @Override
    public <K> KeyAffinityService<K> createService(Cache<K, ?> cache, KeyGenerator<K> generator) {
        boolean distributed = cache.getCacheConfiguration().clustering().cacheMode().isDistributed();
        return distributed ? new KeyAffinityServiceImpl(this.executor, cache, generator, this.bufferSize, Collections.singleton(cache.getCacheManager().getAddress()), false) : new SimpleKeyAffinityService<K>(generator);
    }

    private static class SimpleKeyAffinityService<K>
    implements KeyAffinityService<K> {
        private final KeyGenerator<K> generator;
        private volatile boolean started = false;

        SimpleKeyAffinityService(KeyGenerator<K> generator) {
            this.generator = generator;
        }

        public void start() {
            this.started = true;
        }

        public void stop() {
            this.started = false;
        }

        public K getKeyForAddress(Address address) {
            return (K)this.generator.getKey();
        }

        public K getCollocatedKey(K otherKey) {
            return (K)this.generator.getKey();
        }

        public boolean isStarted() {
            return this.started;
        }
    }
}

