/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.transaction.LockingMode;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheCommands;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigOperationHandlers;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TransactionResource
extends SimpleResourceDefinition {
    private static final PathElement TRANSACTION_PATH = PathElement.pathElement((String)"transaction", (String)"TRANSACTION");
    static final SimpleAttributeDefinition LOCKING = new SimpleAttributeDefinitionBuilder("locking", ModelType.STRING, true).setXmlName(Attribute.LOCKING.getLocalName()).setAllowExpression(false).setValidator((ParameterValidator)new EnumValidator(LockingMode.class, true, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(LockingMode.OPTIMISTIC.name())).build();
    static final SimpleAttributeDefinition MODE = new SimpleAttributeDefinitionBuilder("mode", ModelType.STRING, true).setXmlName(Attribute.MODE.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(TransactionMode.class, true, true)).setDefaultValue(new ModelNode().set(TransactionMode.NONE.name())).build();
    static final SimpleAttributeDefinition STOP_TIMEOUT = new SimpleAttributeDefinitionBuilder("stop-timeout", ModelType.LONG, true).setXmlName(Attribute.STOP_TIMEOUT.getLocalName()).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(30000)).build();
    static final AttributeDefinition[] TRANSACTION_ATTRIBUTES = new AttributeDefinition[]{MODE, STOP_TIMEOUT, LOCKING};
    static final SimpleAttributeDefinition TX_INTERNAL_ID = new SimpleAttributeDefinitionBuilder("internal-id", ModelType.LONG, true).setXmlName("internal-id").setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final OperationDefinition RESET_TX_STATISTICS = new SimpleOperationDefinitionBuilder("reset-transaction-statistics", InfinispanExtension.getResourceDescriptionResolver("transaction")).build();
    static final OperationDefinition LIST_IN_DOUBT_TRANSACTIONS = new SimpleOperationDefinitionBuilder("list-in-doubt-transactions", InfinispanExtension.getResourceDescriptionResolver("transaction")).build();
    static final OperationDefinition TRANSACTION_FORCE_COMMIT = new SimpleOperationDefinitionBuilder("force-commit-transaction", InfinispanExtension.getResourceDescriptionResolver("transaction.recovery")).addParameter((AttributeDefinition)TX_INTERNAL_ID).build();
    static final OperationDefinition TRANSACTION_FORCE_ROLLBACK = new SimpleOperationDefinitionBuilder("force-rollback-transaction", InfinispanExtension.getResourceDescriptionResolver("transaction.recovery")).addParameter((AttributeDefinition)TX_INTERNAL_ID).build();
    static final OperationDefinition TRANSACTION_FORGET = new SimpleOperationDefinitionBuilder("forget-transaction", InfinispanExtension.getResourceDescriptionResolver("transaction.recovery")).addParameter((AttributeDefinition)TX_INTERNAL_ID).build();
    private final boolean runtimeRegistration;

    public TransactionResource(boolean runtimeRegistration) {
        super(TRANSACTION_PATH, InfinispanExtension.getResourceDescriptionResolver("transaction"), CacheConfigOperationHandlers.TRANSACTION_ADD, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.runtimeRegistration = runtimeRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(TRANSACTION_ATTRIBUTES);
        for (AttributeDefinition attr : TRANSACTION_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.runtimeRegistration) {
            resourceRegistration.registerOperationHandler(RESET_TX_STATISTICS.getName(), (OperationStepHandler)CacheCommands.ResetTxStatisticsCommand.INSTANCE, RESET_TX_STATISTICS.getDescriptionProvider());
            resourceRegistration.registerOperationHandler(LIST_IN_DOUBT_TRANSACTIONS.getName(), (OperationStepHandler)CacheCommands.TransactionListInDoubtCommand.INSTANCE, LIST_IN_DOUBT_TRANSACTIONS.getDescriptionProvider());
            resourceRegistration.registerOperationHandler(TRANSACTION_FORCE_COMMIT.getName(), (OperationStepHandler)CacheCommands.TransactionForceCommitCommand.INSTANCE, TRANSACTION_FORCE_COMMIT.getDescriptionProvider());
            resourceRegistration.registerOperationHandler(TRANSACTION_FORCE_ROLLBACK.getName(), (OperationStepHandler)CacheCommands.TransactionForceRollbackCommand.INSTANCE, TRANSACTION_FORCE_ROLLBACK.getDescriptionProvider());
            resourceRegistration.registerOperationHandler(TRANSACTION_FORGET.getName(), (OperationStepHandler)CacheCommands.TransactionForgetCommand.INSTANCE, TRANSACTION_FORGET.getDescriptionProvider());
        }
    }

    public boolean isRuntimeRegistration() {
        return this.runtimeRegistration;
    }
}

