/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.dmr.ModelNode;

public class CacheContainerWriteAttributeHandler
implements OperationStepHandler {
    public static final CacheContainerWriteAttributeHandler INSTANCE = new CacheContainerWriteAttributeHandler();
    private final ParametersValidator nameValidator = new ParametersValidator();
    private final Map<String, AttributeDefinition> attributeDefinitions;

    public CacheContainerWriteAttributeHandler() {
        this(CacheContainerResource.CACHE_CONTAINER_ATTRIBUTES);
    }

    public CacheContainerWriteAttributeHandler(AttributeDefinition ... definitions) {
        assert (definitions != null) : ControllerMessages.MESSAGES.nullVar("definitions").getLocalizedMessage();
        this.attributeDefinitions = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition def : definitions) {
            this.attributeDefinitions.put(def.getName(), def);
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.nameValidator.validate(operation);
        String attributeName = operation.require("name").asString();
        ModelNode newValue = operation.hasDefined("value") ? operation.get("value") : new ModelNode();
        ModelNode submodel = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(attributeName);
        if (attributeDefinition != null) {
            ModelNode syntheticOp = new ModelNode();
            syntheticOp.get(attributeName).set(newValue);
            attributeDefinition.validateAndSet(syntheticOp, submodel);
        } else {
            submodel.get(attributeName).set(newValue);
        }
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getProcessType().isServer() && !context.isBooting();
    }

    protected AttributeDefinition getAttributeDefinition(String attributeName) {
        return this.attributeDefinitions == null ? null : this.attributeDefinitions.get(attributeName);
    }
}

