/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheCommands;
import org.jboss.as.clustering.infinispan.subsystem.CacheMetricsHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheReadAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheWriteAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.ClusterLoaderResource;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResource;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResource;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.LoaderResource;
import org.jboss.as.clustering.infinispan.subsystem.LockingResource;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.ModuleIdentifierValidator;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.StoreResource;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResource;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CacheResource
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition BATCHING = new SimpleAttributeDefinitionBuilder("batching", ModelType.BOOLEAN, true).setXmlName(Attribute.BATCHING.getLocalName()).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(false)).build();
    static final SimpleAttributeDefinition CACHE_MODULE = new SimpleAttributeDefinitionBuilder("module", ModelType.STRING, true).setXmlName(Attribute.MODULE.getLocalName()).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new ModuleIdentifierValidator(true)).build();
    static final SimpleAttributeDefinition INDEXING = new SimpleAttributeDefinitionBuilder("indexing", ModelType.STRING, true).setXmlName(Attribute.INDEX.getLocalName()).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(Indexing.class, true, false)).setDefaultValue(new ModelNode().set(Indexing.NONE.name())).build();
    static final SimpleAttributeDefinition JNDI_NAME = new SimpleAttributeDefinitionBuilder("jndi-name", ModelType.STRING, true).setXmlName(Attribute.JNDI_NAME.getLocalName()).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition START = new SimpleAttributeDefinitionBuilder("start", ModelType.STRING, true).setXmlName(Attribute.START.getLocalName()).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(StartMode.class, true, false)).setDefaultValue(new ModelNode().set(StartMode.LAZY.name())).build();
    static final AttributeDefinition[] CACHE_ATTRIBUTES = new AttributeDefinition[]{BATCHING, CACHE_MODULE, INDEXING, JNDI_NAME, START};
    static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, true).setXmlName(Attribute.NAME.getLocalName()).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final OperationDefinition CLEAR_CACHE = new SimpleOperationDefinitionBuilder("clear-cache", InfinispanExtension.getResourceDescriptionResolver("cache")).build();
    static final OperationDefinition RESET_STATISTICS = new SimpleOperationDefinitionBuilder("reset-statistics", InfinispanExtension.getResourceDescriptionResolver("cache")).build();
    static final OperationDefinition RESET_ACTIVATION_STATISTICS = new SimpleOperationDefinitionBuilder("reset-activation-statistics", InfinispanExtension.getResourceDescriptionResolver("cache")).build();
    static final OperationDefinition RESET_INVALIDATION_STATISTICS = new SimpleOperationDefinitionBuilder("reset-invalidation-statistics", InfinispanExtension.getResourceDescriptionResolver("cache")).build();
    static final OperationDefinition RESET_PASSIVATION_STATISTICS = new SimpleOperationDefinitionBuilder("reset-passivation-statistics", InfinispanExtension.getResourceDescriptionResolver("cache")).build();
    private final boolean runtimeRegistration;

    public CacheResource(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, AbstractAddStepHandler addHandler, OperationStepHandler removeHandler, boolean runtimeRegistration) {
        super(pathElement, descriptionResolver, (OperationStepHandler)addHandler, removeHandler);
        this.runtimeRegistration = runtimeRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        CacheWriteAttributeHandler writeHandler = new CacheWriteAttributeHandler(CACHE_ATTRIBUTES);
        for (AttributeDefinition attr : CACHE_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, (OperationStepHandler)CacheReadAttributeHandler.INSTANCE, (OperationStepHandler)writeHandler);
        }
        if (this.isRuntimeRegistration()) {
            CacheMetricsHandler.INSTANCE.registerCommonMetrics(resourceRegistration);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.runtimeRegistration) {
            resourceRegistration.registerOperationHandler(CLEAR_CACHE.getName(), (OperationStepHandler)CacheCommands.ClearCacheCommand.INSTANCE, CLEAR_CACHE.getDescriptionProvider());
            resourceRegistration.registerOperationHandler(RESET_STATISTICS.getName(), (OperationStepHandler)CacheCommands.ResetCacheStatisticsCommand.INSTANCE, RESET_STATISTICS.getDescriptionProvider());
            resourceRegistration.registerOperationHandler(RESET_ACTIVATION_STATISTICS.getName(), (OperationStepHandler)CacheCommands.ResetActivationStatisticsCommand.INSTANCE, RESET_ACTIVATION_STATISTICS.getDescriptionProvider());
            resourceRegistration.registerOperationHandler(RESET_INVALIDATION_STATISTICS.getName(), (OperationStepHandler)CacheCommands.ResetPassivationStatisticsCommand.INSTANCE, RESET_INVALIDATION_STATISTICS.getDescriptionProvider());
            resourceRegistration.registerOperationHandler(RESET_PASSIVATION_STATISTICS.getName(), (OperationStepHandler)CacheCommands.ResetPassivationStatisticsCommand.INSTANCE, RESET_PASSIVATION_STATISTICS.getDescriptionProvider());
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)new LockingResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new TransactionResource(this.runtimeRegistration));
        resourceRegistration.registerSubModel((ResourceDefinition)new EvictionResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new ExpirationResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new LoaderResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new ClusterLoaderResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new StoreResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new FileStoreResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new StringKeyedJDBCStoreResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new BinaryKeyedJDBCStoreResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new MixedKeyedJDBCStoreResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new RemoteStoreResource());
    }

    public boolean isRuntimeRegistration() {
        return this.runtimeRegistration;
    }
}

