/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResource;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public abstract class SharedStateCacheAdd
extends ClusteredCacheAdd {
    SharedStateCacheAdd(CacheMode mode) {
        super(mode);
    }

    @Override
    void processModelNode(OperationContext context, String containerName, ModelNode cache, ConfigurationBuilder builder, List<CacheAdd.Dependency<?>> dependencies) throws OperationFailedException {
        super.processModelNode(context, containerName, cache, builder, dependencies);
        if (cache.hasDefined("state-transfer") && cache.get(new String[]{"state-transfer", "STATE_TRANSFER"}).isDefined()) {
            ModelNode stateTransfer = cache.get(new String[]{"state-transfer", "STATE_TRANSFER"});
            boolean enabled = StateTransferResource.ENABLED.resolveModelAttribute(context, stateTransfer).asBoolean();
            long timeout = StateTransferResource.TIMEOUT.resolveModelAttribute(context, stateTransfer).asLong();
            int chunkSize = StateTransferResource.CHUNK_SIZE.resolveModelAttribute(context, stateTransfer).asInt();
            boolean awaitInitialTransfer = StateTransferResource.AWAIT_INITIAL_TRANSFER.resolveModelAttribute(context, stateTransfer).asBoolean();
            builder.clustering().stateTransfer().fetchInMemoryState(enabled);
            builder.clustering().stateTransfer().timeout(timeout);
            builder.clustering().stateTransfer().chunkSize(chunkSize);
            builder.clustering().stateTransfer().awaitInitialTransfer(awaitInitialTransfer);
        }
        if (cache.hasDefined("backup")) {
            SitesConfigurationBuilder sitesBuilder = builder.sites();
            for (Property property : cache.get("backup").asPropertyList()) {
                String siteName = property.getName();
                ModelNode site = property.getValue();
                sitesBuilder.addBackup().site(siteName).backupFailurePolicy(BackupFailurePolicy.valueOf((String)BackupSiteResource.FAILURE_POLICY.resolveModelAttribute(context, site).asString())).strategy(BackupConfiguration.BackupStrategy.valueOf((String)BackupSiteResource.STRATEGY.resolveModelAttribute(context, site).asString())).replicationTimeout(BackupSiteResource.REPLICATION_TIMEOUT.resolveModelAttribute(context, site).asLong());
                if (!BackupSiteResource.ENABLED.resolveModelAttribute(context, site).asBoolean()) continue;
                sitesBuilder.addInUseBackupSite(siteName);
            }
        }
    }
}

