/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.BaseStoreResource;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class BaseJDBCStoreResource
extends BaseStoreResource {
    static final SimpleAttributeDefinition DATA_SOURCE = new SimpleAttributeDefinitionBuilder("datasource", ModelType.STRING, false).setXmlName(Attribute.DATASOURCE.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final AttributeDefinition[] COMMON_JDBC_STORE_ATTRIBUTES = new AttributeDefinition[]{DATA_SOURCE};
    static final SimpleAttributeDefinition BATCH_SIZE = new SimpleAttributeDefinitionBuilder("batch-size", ModelType.INT, true).setXmlName(Attribute.BATCH_SIZE.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(100)).build();
    static final SimpleAttributeDefinition FETCH_SIZE = new SimpleAttributeDefinitionBuilder("fetch-size", ModelType.INT, true).setXmlName(Attribute.FETCH_SIZE.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(100)).build();
    static final SimpleAttributeDefinition PREFIX = new SimpleAttributeDefinitionBuilder("prefix", ModelType.STRING, true).setXmlName(Attribute.PREFIX.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition COLUMN_NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, true).setXmlName("name").setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set("name")).build();
    static final SimpleAttributeDefinition COLUMN_TYPE = new SimpleAttributeDefinitionBuilder("type", ModelType.STRING, true).setXmlName("type").setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set("type")).build();
    static final ObjectTypeAttributeDefinition ID_COLUMN = ObjectTypeAttributeDefinition.Builder.of((String)"id-column", (AttributeDefinition[])new AttributeDefinition[]{COLUMN_NAME, COLUMN_TYPE}).setAllowNull(true).setSuffix("column").build();
    static final ObjectTypeAttributeDefinition DATA_COLUMN = ObjectTypeAttributeDefinition.Builder.of((String)"data-column", (AttributeDefinition[])new AttributeDefinition[]{COLUMN_NAME, COLUMN_TYPE}).setAllowNull(true).setSuffix("column").build();
    static final ObjectTypeAttributeDefinition TIMESTAMP_COLUMN = ObjectTypeAttributeDefinition.Builder.of((String)"timestamp-column", (AttributeDefinition[])new AttributeDefinition[]{COLUMN_NAME, COLUMN_TYPE}).setAllowNull(true).setSuffix("column").build();
    static final ObjectTypeAttributeDefinition ENTRY_TABLE = ObjectTypeAttributeDefinition.Builder.of((String)"entry-table", (AttributeDefinition[])new AttributeDefinition[]{PREFIX, BATCH_SIZE, FETCH_SIZE, ID_COLUMN, DATA_COLUMN, TIMESTAMP_COLUMN}).setAllowNull(true).setSuffix("table").build();
    static final ObjectTypeAttributeDefinition BUCKET_TABLE = ObjectTypeAttributeDefinition.Builder.of((String)"bucket-table", (AttributeDefinition[])new AttributeDefinition[]{PREFIX, BATCH_SIZE, FETCH_SIZE, ID_COLUMN, DATA_COLUMN, TIMESTAMP_COLUMN}).setAllowNull(true).setSuffix("table").build();
    static final ObjectTypeAttributeDefinition STRING_KEYED_TABLE = ObjectTypeAttributeDefinition.Builder.of((String)"string-keyed-table", (AttributeDefinition[])new AttributeDefinition[]{PREFIX, BATCH_SIZE, FETCH_SIZE, ID_COLUMN, DATA_COLUMN, TIMESTAMP_COLUMN}).setAllowNull(true).setSuffix("table").build();
    static final ObjectTypeAttributeDefinition BINARY_KEYED_TABLE = ObjectTypeAttributeDefinition.Builder.of((String)"binary-keyed-table", (AttributeDefinition[])new AttributeDefinition[]{PREFIX, BATCH_SIZE, FETCH_SIZE, ID_COLUMN, DATA_COLUMN, TIMESTAMP_COLUMN}).setAllowNull(true).setSuffix("table").build();
    static final AttributeDefinition[] COMMON_JDBC_STORE_TABLE_ATTRIBUTES = new AttributeDefinition[]{PREFIX, BATCH_SIZE, FETCH_SIZE, ID_COLUMN, DATA_COLUMN, TIMESTAMP_COLUMN};
    static final AttributeDefinition[] COMMON_BASE_JDBC_STORE_ATTRIBUTES = new AttributeDefinition[]{DATA_SOURCE, BATCH_SIZE, FETCH_SIZE, PREFIX, COLUMN_NAME, COLUMN_TYPE, ID_COLUMN, DATA_COLUMN, TIMESTAMP_COLUMN, ENTRY_TABLE, BUCKET_TABLE, STRING_KEYED_TABLE, BINARY_KEYED_TABLE};

    public BaseJDBCStoreResource(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(pathElement, descriptionResolver, addHandler, removeHandler);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(COMMON_JDBC_STORE_ATTRIBUTES);
        for (AttributeDefinition attr : COMMON_JDBC_STORE_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
    }

    @Override
    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
    }
}

