/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.Cache;
import org.infinispan.interceptors.ActivationInterceptor;
import org.infinispan.interceptors.CacheMgmtInterceptor;
import org.infinispan.interceptors.CacheStoreInterceptor;
import org.infinispan.interceptors.InvalidationInterceptor;
import org.infinispan.interceptors.PassivationInterceptor;
import org.infinispan.interceptors.TxInterceptor;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.transaction.xa.recovery.RecoveryAdminOperations;
import org.infinispan.xsite.XSiteAdminOperations;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheMetricsHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public abstract class CacheCommands
implements OperationStepHandler {
    final int pathOffset;

    CacheCommands(int pathOffset) {
        this.pathOffset = pathOffset;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 2 - this.pathOffset).getValue();
        String cacheName = address.getElement(address.size() - 1 - this.pathOffset).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheService.getServiceName(cacheContainerName, cacheName));
        Cache cache = (Cache)controller.getValue();
        ModelNode operationResult = null;
        try {
            operationResult = this.invokeCommand(cache, operation);
        }
        catch (Exception e) {
            throw new OperationFailedException(new ModelNode().set(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage())));
        }
        if (operationResult != null) {
            context.getResult().set(operationResult);
        }
        context.stepCompleted();
    }

    protected abstract ModelNode invokeCommand(Cache<?, ?> var1, ModelNode var2) throws Exception;

    private static ModelNode toOperationResult(String s) {
        ModelNode result = new ModelNode();
        result.add(s);
        return result;
    }

    public static class BackupSiteStatusCommand
    extends CacheCommands {
        public static final BackupSiteStatusCommand INSTANCE = new BackupSiteStatusCommand();

        public BackupSiteStatusCommand() {
            super(1);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String site = address.getLastElement().getValue();
            XSiteAdminOperations xsiteAdminOperations = (XSiteAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(XSiteAdminOperations.class);
            return CacheCommands.toOperationResult(xsiteAdminOperations.siteStatus(site));
        }
    }

    public static class BackupTakeSiteOfflineCommand
    extends CacheCommands {
        public static final BackupTakeSiteOfflineCommand INSTANCE = new BackupTakeSiteOfflineCommand();

        public BackupTakeSiteOfflineCommand() {
            super(1);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String site = address.getLastElement().getValue();
            XSiteAdminOperations xsiteAdminOperations = (XSiteAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(XSiteAdminOperations.class);
            return CacheCommands.toOperationResult(xsiteAdminOperations.takeSiteOffline(site));
        }
    }

    public static class BackupBringSiteOnlineCommand
    extends CacheCommands {
        public static final BackupBringSiteOnlineCommand INSTANCE = new BackupBringSiteOnlineCommand();

        public BackupBringSiteOnlineCommand() {
            super(1);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String site = address.getLastElement().getValue();
            XSiteAdminOperations xsiteAdminOperations = (XSiteAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(XSiteAdminOperations.class);
            return CacheCommands.toOperationResult(xsiteAdminOperations.bringSiteOnline(site));
        }
    }

    public static class TransactionForgetCommand
    extends CacheCommands {
        public static final TransactionForgetCommand INSTANCE = new TransactionForgetCommand();

        public TransactionForgetCommand() {
            super(1);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            long internalId = operation.require("internal-id").asLong();
            RecoveryAdminOperations recoveryAdminOperations = (RecoveryAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(RecoveryAdminOperations.class);
            return CacheCommands.toOperationResult(recoveryAdminOperations.forget(internalId));
        }
    }

    public static class TransactionForceRollbackCommand
    extends CacheCommands {
        public static final TransactionForceRollbackCommand INSTANCE = new TransactionForceRollbackCommand();

        public TransactionForceRollbackCommand() {
            super(1);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            long internalId = operation.require("internal-id").asLong();
            RecoveryAdminOperations recoveryAdminOperations = (RecoveryAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(RecoveryAdminOperations.class);
            return CacheCommands.toOperationResult(recoveryAdminOperations.forceRollback(internalId));
        }
    }

    public static class TransactionForceCommitCommand
    extends CacheCommands {
        public static final TransactionForceCommitCommand INSTANCE = new TransactionForceCommitCommand();

        public TransactionForceCommitCommand() {
            super(1);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            long internalId = operation.require("internal-id").asLong();
            RecoveryAdminOperations recoveryAdminOperations = (RecoveryAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(RecoveryAdminOperations.class);
            return CacheCommands.toOperationResult(recoveryAdminOperations.forceCommit(internalId));
        }
    }

    public static class TransactionListInDoubtCommand
    extends CacheCommands {
        public static final TransactionListInDoubtCommand INSTANCE = new TransactionListInDoubtCommand();

        public TransactionListInDoubtCommand() {
            super(1);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            RecoveryAdminOperations recoveryAdminOperations = (RecoveryAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(RecoveryAdminOperations.class);
            return CacheCommands.toOperationResult(recoveryAdminOperations.showInDoubtTransactions());
        }
    }

    public static class ResetCacheLoaderStatisticsCommand
    extends CacheCommands {
        public static final ResetCacheLoaderStatisticsCommand INSTANCE = new ResetCacheLoaderStatisticsCommand();

        public ResetCacheLoaderStatisticsCommand() {
            super(0);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            CacheStoreInterceptor interceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheStoreInterceptor.class);
            if (interceptor != null) {
                interceptor.resetStatistics();
            }
            return null;
        }
    }

    public static class ResetRpcManagerStatisticsCommand
    extends CacheCommands {
        public static final ResetRpcManagerStatisticsCommand INSTANCE = new ResetRpcManagerStatisticsCommand();

        public ResetRpcManagerStatisticsCommand() {
            super(0);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            RpcManagerImpl rpcManager = (RpcManagerImpl)cache.getAdvancedCache().getRpcManager();
            if (rpcManager != null) {
                rpcManager.resetStatistics();
            }
            return null;
        }
    }

    public static class ResetPassivationStatisticsCommand
    extends CacheCommands {
        public static final ResetPassivationStatisticsCommand INSTANCE = new ResetPassivationStatisticsCommand();

        public ResetPassivationStatisticsCommand() {
            super(0);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            PassivationInterceptor interceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), PassivationInterceptor.class);
            if (interceptor != null) {
                interceptor.resetStatistics();
            }
            return null;
        }
    }

    public static class ResetActivationStatisticsCommand
    extends CacheCommands {
        public static final ResetActivationStatisticsCommand INSTANCE = new ResetActivationStatisticsCommand();

        public ResetActivationStatisticsCommand() {
            super(0);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            ActivationInterceptor interceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), ActivationInterceptor.class);
            if (interceptor != null) {
                interceptor.resetStatistics();
            }
            return null;
        }
    }

    public static class ResetInvalidationStatisticsCommand
    extends CacheCommands {
        public static final ResetInvalidationStatisticsCommand INSTANCE = new ResetInvalidationStatisticsCommand();

        public ResetInvalidationStatisticsCommand() {
            super(0);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            InvalidationInterceptor interceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), InvalidationInterceptor.class);
            if (interceptor != null) {
                interceptor.resetStatistics();
            }
            return null;
        }
    }

    public static class ResetTxStatisticsCommand
    extends CacheCommands {
        public static final ResetTxStatisticsCommand INSTANCE = new ResetTxStatisticsCommand();

        public ResetTxStatisticsCommand() {
            super(0);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            TxInterceptor interceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), TxInterceptor.class);
            if (interceptor != null) {
                interceptor.resetStatistics();
            }
            return null;
        }
    }

    public static class ClearCacheCommand
    extends CacheCommands {
        public static final ClearCacheCommand INSTANCE = new ClearCacheCommand();

        public ClearCacheCommand() {
            super(0);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            cache.clear();
            return null;
        }
    }

    public static class ResetCacheStatisticsCommand
    extends CacheCommands {
        public static final ResetCacheStatisticsCommand INSTANCE = new ResetCacheStatisticsCommand();

        public ResetCacheStatisticsCommand() {
            super(0);
        }

        @Override
        protected ModelNode invokeCommand(Cache<?, ?> cache, ModelNode operation) throws Exception {
            CacheMgmtInterceptor interceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheMgmtInterceptor.class);
            if (interceptor != null) {
                interceptor.resetStatistics();
            }
            return null;
        }
    }
}

