/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheAdd;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;

public class CacheRemove
extends AbstractRemoveStepHandler {
    static final CacheRemove INSTANCE = new CacheRemove();

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String cacheType = this.getCacheType(operation);
        if (cacheType.equals("local-cache")) {
            LocalCacheAdd.INSTANCE.removeRuntimeServices(context, operation, model);
        } else if (cacheType.equals("invalidation-cache")) {
            InvalidationCacheAdd.INSTANCE.removeRuntimeServices(context, operation, model);
        } else if (cacheType.equals("replicated-cache")) {
            ReplicatedCacheAdd.INSTANCE.removeRuntimeServices(context, operation, model);
        } else if (cacheType.equals("distributed-cache")) {
            DistributedCacheAdd.INSTANCE.removeRuntimeServices(context, operation, model);
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode cacheModel) throws OperationFailedException {
        PathAddress cacheAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress containerAddress = cacheAddress.subAddress(0, cacheAddress.size() - 1);
        ModelNode containerModel = context.readResourceFromRoot(containerAddress).getModel();
        String cacheType = this.getCacheType(operation);
        ServiceVerificationHandler verificationHandler = null;
        if (cacheType.equals("local-cache")) {
            LocalCacheAdd.INSTANCE.installRuntimeServices(context, operation, containerModel, cacheModel, verificationHandler);
        } else if (cacheType.equals("invalidation-cache")) {
            InvalidationCacheAdd.INSTANCE.installRuntimeServices(context, operation, containerModel, cacheModel, verificationHandler);
        } else if (cacheType.equals("replicated-cache")) {
            ReplicatedCacheAdd.INSTANCE.installRuntimeServices(context, operation, containerModel, cacheModel, verificationHandler);
        } else if (cacheType.equals("distributed-cache")) {
            DistributedCacheAdd.INSTANCE.installRuntimeServices(context, operation, containerModel, cacheModel, verificationHandler);
        }
    }

    private String getCacheType(ModelNode operation) {
        PathAddress cacheAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String cacheType = cacheAddress.getLastElement().getKey();
        return cacheType;
    }
}

