/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.util.Properties;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelLookup;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jgroups.Channel;

public class ChannelProvider
implements JGroupsChannelLookup {
    private static final String CHANNEL = "channel";

    public static void init(TransportConfigurationBuilder builder, ServiceName channel) {
        Properties properties = new Properties();
        properties.setProperty("channelLookup", ChannelProvider.class.getName());
        properties.setProperty(CHANNEL, channel.getCanonicalName());
        builder.transport().defaultTransport().withProperties(properties);
    }

    public Channel getJGroupsChannel(Properties properties) {
        String channel = properties.getProperty(CHANNEL);
        if (channel == null) {
            throw InfinispanMessages.MESSAGES.invalidTransportProperty(CHANNEL, properties);
        }
        ServiceName name = ServiceName.parse((String)channel);
        ServiceController service = ServiceContainerHelper.getCurrentServiceContainer().getRequiredService(name);
        try {
            return (Channel)ServiceContainerHelper.getValue((ServiceController)service, Channel.class);
        }
        catch (StartException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean shouldConnect() {
        return true;
    }

    public boolean shouldDisconnect() {
        return true;
    }

    public boolean shouldClose() {
        return true;
    }
}

