/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteResource;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheCommands;
import org.jboss.as.clustering.infinispan.subsystem.CacheMetricsHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheReadAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheWriteAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.ClusterLoaderResource;
import org.jboss.as.clustering.infinispan.subsystem.CompatibilityResource;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResource;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResource;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.LoaderResource;
import org.jboss.as.clustering.infinispan.subsystem.LockingResource;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.ModuleIdentifierValidator;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.RestStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.StoreResource;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResource;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class CacheResource
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition BATCHING = new SimpleAttributeDefinitionBuilder("batching", ModelType.BOOLEAN, true).setXmlName(Attribute.BATCHING.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(false)).build();
    static final SimpleAttributeDefinition CACHE_MODULE = new SimpleAttributeDefinitionBuilder("module", ModelType.STRING, true).setXmlName(Attribute.MODULE.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new ModuleIdentifierValidator(true)).build();
    static final SimpleAttributeDefinition INDEXING = new SimpleAttributeDefinitionBuilder("indexing", ModelType.STRING, true).setXmlName(Attribute.INDEX.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(Indexing.class, true, false)).setDefaultValue(new ModelNode().set(Indexing.NONE.name())).build();
    static final SimpleMapAttributeDefinition INDEXING_PROPERTIES = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("indexing-properties", true).setAllowExpression(true)).setAttributeMarshaller(new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (!(resourceModel = resourceModel.get(attribute.getName())).isDefined()) {
                return;
            }
            for (Property property : resourceModel.asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Element.NAME.getLocalName(), property.getName());
                writer.writeCharacters(property.getValue().asString());
                writer.writeEndElement();
            }
        }
    })).build();
    static final SimpleAttributeDefinition JNDI_NAME = new SimpleAttributeDefinitionBuilder("jndi-name", ModelType.STRING, true).setXmlName(Attribute.JNDI_NAME.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition START = new SimpleAttributeDefinitionBuilder("start", ModelType.STRING, true).setXmlName(Attribute.START.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(StartMode.class, true, false)).setDefaultValue(new ModelNode().set(StartMode.LAZY.name())).build();
    static final SimpleAttributeDefinition STATISTICS = new SimpleAttributeDefinitionBuilder("statistics", ModelType.BOOLEAN, true).setXmlName(Attribute.STATISTICS.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).setDefaultValue(new ModelNode().set(true)).build();
    static final AttributeDefinition[] CACHE_ATTRIBUTES = new AttributeDefinition[]{BATCHING, CACHE_MODULE, INDEXING, INDEXING_PROPERTIES, JNDI_NAME, START, STATISTICS};
    static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, true).setXmlName(Attribute.NAME.getLocalName()).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final OperationDefinition CLEAR_CACHE = new SimpleOperationDefinitionBuilder("clear-cache", InfinispanExtension.getResourceDescriptionResolver("cache")).build();
    static final OperationDefinition RESET_STATISTICS = new SimpleOperationDefinitionBuilder("reset-statistics", InfinispanExtension.getResourceDescriptionResolver("cache")).build();
    static final OperationDefinition RESET_ACTIVATION_STATISTICS = new SimpleOperationDefinitionBuilder("reset-activation-statistics", InfinispanExtension.getResourceDescriptionResolver("cache")).build();
    static final OperationDefinition RESET_INVALIDATION_STATISTICS = new SimpleOperationDefinitionBuilder("reset-invalidation-statistics", InfinispanExtension.getResourceDescriptionResolver("cache")).build();
    static final OperationDefinition RESET_PASSIVATION_STATISTICS = new SimpleOperationDefinitionBuilder("reset-passivation-statistics", InfinispanExtension.getResourceDescriptionResolver("cache")).build();
    protected final ResolvePathHandler resolvePathHandler;
    protected final boolean runtimeRegistration;

    public CacheResource(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, AbstractAddStepHandler addHandler, OperationStepHandler removeHandler, ResolvePathHandler resolvePathHandler, boolean runtimeRegistration) {
        super(pathElement, descriptionResolver, (OperationStepHandler)addHandler, removeHandler);
        this.resolvePathHandler = resolvePathHandler;
        this.runtimeRegistration = runtimeRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        CacheWriteAttributeHandler writeHandler = new CacheWriteAttributeHandler(CACHE_ATTRIBUTES);
        for (AttributeDefinition attr : CACHE_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, (OperationStepHandler)CacheReadAttributeHandler.INSTANCE, (OperationStepHandler)writeHandler);
        }
        if (this.runtimeRegistration) {
            CacheMetricsHandler.INSTANCE.registerCommonMetrics(resourceRegistration);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.runtimeRegistration) {
            resourceRegistration.registerOperationHandler(CLEAR_CACHE, (OperationStepHandler)CacheCommands.ClearCacheCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(RESET_STATISTICS, (OperationStepHandler)CacheCommands.ResetCacheStatisticsCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(RESET_ACTIVATION_STATISTICS, (OperationStepHandler)CacheCommands.ResetActivationStatisticsCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(RESET_INVALIDATION_STATISTICS, (OperationStepHandler)CacheCommands.ResetPassivationStatisticsCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(RESET_PASSIVATION_STATISTICS, (OperationStepHandler)CacheCommands.ResetPassivationStatisticsCommand.INSTANCE);
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)new LockingResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new TransactionResource(this.runtimeRegistration));
        resourceRegistration.registerSubModel((ResourceDefinition)new EvictionResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new ExpirationResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new CompatibilityResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new LoaderResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new ClusterLoaderResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new BackupSiteResource(this.runtimeRegistration));
        resourceRegistration.registerSubModel((ResourceDefinition)new StoreResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new FileStoreResource(this.resolvePathHandler));
        resourceRegistration.registerSubModel((ResourceDefinition)new StringKeyedJDBCStoreResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new BinaryKeyedJDBCStoreResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new MixedKeyedJDBCStoreResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new RemoteStoreResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new LevelDBStoreResource(this.resolvePathHandler));
        resourceRegistration.registerSubModel((ResourceDefinition)new RestStoreResource());
    }
}

