/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheCommands;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigOperationHandlers;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class BackupSiteResource
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition FAILURE_POLICY = new SimpleAttributeDefinitionBuilder("failure-policy", ModelType.STRING, true).setXmlName(Attribute.BACKUP_FAILURE_POLICY.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(BackupFailurePolicy.class, true, true)).setDefaultValue(new ModelNode().set(BackupFailurePolicy.WARN.name())).build();
    static final SimpleAttributeDefinition STRATEGY = new SimpleAttributeDefinitionBuilder("strategy", ModelType.STRING, true).setXmlName(Attribute.STRATEGY.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(BackupConfiguration.BackupStrategy.class, true, true)).setDefaultValue(new ModelNode().set(BackupConfiguration.BackupStrategy.ASYNC.name())).build();
    static final SimpleAttributeDefinition REPLICATION_TIMEOUT = new SimpleAttributeDefinitionBuilder("timeout", ModelType.STRING, true).setXmlName(Attribute.TIMEOUT.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(10000L)).build();
    static final SimpleAttributeDefinition ENABLED = new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN, true).setXmlName(Attribute.ENABLED.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(true)).build();
    static final SimpleAttributeDefinition TAKE_OFFLINE_AFTER_FAILURES = new SimpleAttributeDefinitionBuilder("after-failures", ModelType.INT, true).setXmlName(Attribute.TAKE_BACKUP_OFFLINE_AFTER_FAILURES.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(0)).build();
    static final SimpleAttributeDefinition TAKE_OFFLINE_MIN_WAIT = new SimpleAttributeDefinitionBuilder("min-wait", ModelType.INT, true).setXmlName(Attribute.TAKE_BACKUP_OFFLINE_MIN_WAIT.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(0)).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{FAILURE_POLICY, STRATEGY, REPLICATION_TIMEOUT, ENABLED, TAKE_OFFLINE_AFTER_FAILURES, TAKE_OFFLINE_MIN_WAIT};
    static final OperationDefinition BACKUP_BRING_SITE_ONLINE = new SimpleOperationDefinitionBuilder("bring-site-online", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).build();
    static final OperationDefinition BACKUP_TAKE_SITE_OFFLINE = new SimpleOperationDefinitionBuilder("take-site-offline", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).build();
    static final OperationDefinition BACKUP_SITE_STATUS = new SimpleOperationDefinitionBuilder("site-status", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).build();
    private final boolean runtimeRegistration;

    BackupSiteResource(boolean runtimeRegistration) {
        super(PathElement.pathElement((String)"backup"), InfinispanExtension.getResourceDescriptionResolver("backup"), (OperationStepHandler)new CacheConfigOperationHandlers.CacheConfigAdd(ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.runtimeRegistration = runtimeRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            registration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeHandler);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.runtimeRegistration) {
            resourceRegistration.registerOperationHandler(BACKUP_BRING_SITE_ONLINE, (OperationStepHandler)CacheCommands.BackupBringSiteOnlineCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(BACKUP_TAKE_SITE_OFFLINE, (OperationStepHandler)CacheCommands.BackupTakeSiteOfflineCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(BACKUP_SITE_STATUS, (OperationStepHandler)CacheCommands.BackupSiteStatusCommand.INSTANCE);
        }
    }

    public boolean isRuntimeRegistration() {
        return this.runtimeRegistration;
    }
}

