/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;

public enum Element {
    UNKNOWN((String)null),
    ALIAS("alias"),
    AUTHORIZATION("authorization"),
    BACKUP("backup"),
    BACKUPS("backups"),
    BINARY_KEYED_TABLE("binary-keyed-table"),
    BUCKET_TABLE("bucket-table"),
    CACHE_CONTAINER("cache-container"),
    CONNECTION_POOL("connection-pool"),
    CLUSTER_LOADER("cluster-loader"),
    COMPATIBILITY("compatibility"),
    COMPRESSION("compression"),
    COMMON_NAME_ROLE_MAPPER("common-name-role-mapper"),
    CLUSTER_ROLE_MAPPER("cluster-role-mapper"),
    CUSTOM_ROLE_MAPPER("custom-role-mapper"),
    DATA_COLUMN("data-column"),
    DISTRIBUTED_CACHE("distributed-cache"),
    ENTRY_TABLE("entry-table"),
    EVICTION("eviction"),
    EXPIRATION("expiration"),
    FILE_STORE("file-store"),
    ID_COLUMN("id-column"),
    IDENTITY_ROLE_MAPPER("identity-role-mapper"),
    INVALIDATION_CACHE("invalidation-cache"),
    LEVELDB_STORE("leveldb-store"),
    JDBC_STORE("jdbc-store"),
    STRING_KEYED_JDBC_STORE("string-keyed-jdbc-store"),
    BINARY_KEYED_JDBC_STORE("binary-keyed-jdbc-store"),
    MIXED_KEYED_JDBC_STORE("mixed-keyed-jdbc-store"),
    IMPLEMENTATION("implementation"),
    INDEXING("indexing"),
    LOADER("loader"),
    LOCAL_CACHE("local-cache"),
    LOCKING("locking"),
    PROPERTY("property"),
    REHASHING("rehashing"),
    REMOTE_SERVER("remote-server"),
    REMOTE_STORE("remote-store"),
    REPLICATED_CACHE("replicated-cache"),
    REST_STORE("rest-store"),
    ROLE("role"),
    SECURITY("security"),
    STATE_TRANSFER("state-transfer"),
    STORE("store"),
    STRING_KEYED_TABLE("string-keyed-table"),
    TAKE_OFFLINE("take-offline"),
    TIMESTAMP_COLUMN("timestamp-column"),
    TRANSACTION("transaction"),
    TRANSPORT("transport"),
    WRITE_BEHIND("write-behind");

    private final String name;
    private final AttributeDefinition definition;
    private static final Map<String, Element> elements;

    private Element(String name) {
        this.name = name;
        this.definition = null;
    }

    private Element(AttributeDefinition definition) {
        this.name = definition.getXmlName();
        this.definition = definition;
    }

    public String getLocalName() {
        return this.name;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static Element forName(String localName) {
        Element element = elements.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        elements = map;
    }
}

