/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.infinispan.commons.util.Util;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class UploadProtoFileOperationHandler
implements OperationStepHandler {
    public static final UploadProtoFileOperationHandler INSTANCE = new UploadProtoFileOperationHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode newValue = operation.require(CacheContainerResource.PROTO_URLS.getName());
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 1).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(EmbeddedCacheManagerService.getServiceName(cacheContainerName));
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)controller.getValue();
        ProtobufMetadataManager protoManager = (ProtobufMetadataManager)cacheManager.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        if (protoManager != null) {
            try {
                List descriptorsNodes = newValue.asList();
                String[] nameArray = new String[descriptorsNodes.size()];
                String[] contentArray = new String[descriptorsNodes.size()];
                int i = 0;
                for (ModelNode modelNode : descriptorsNodes) {
                    String urlString = modelNode.asString();
                    nameArray[i] = this.extractFile(urlString);
                    contentArray[i] = Util.read((InputStream)new URL(urlString).openStream());
                    ++i;
                }
                protoManager.registerProtofiles(nameArray, contentArray);
            }
            catch (Exception e) {
                throw new OperationFailedException(new ModelNode().set(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage())));
            }
        }
        context.stepCompleted();
    }

    private String extractFile(String url) {
        return url.replaceFirst(".*!/(.*)", "$1");
    }
}

