/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheCommands;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.LoaderPropertyResource;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class BaseLoaderResource
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition PRELOAD = new SimpleAttributeDefinitionBuilder("preload", ModelType.BOOLEAN, true).setXmlName(Attribute.PRELOAD.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(false)).build();
    static final SimpleAttributeDefinition SHARED = new SimpleAttributeDefinitionBuilder("shared", ModelType.BOOLEAN, true).setXmlName(Attribute.SHARED.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(false)).build();
    static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, true).setXmlName(Attribute.NAME.getLocalName()).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final AttributeDefinition PROPERTY = new SimpleAttributeDefinition("property", ModelType.PROPERTY, true);
    static final SimpleListAttributeDefinition PROPERTIES = SimpleListAttributeDefinition.Builder.of((String)"properties", (AttributeDefinition)PROPERTY).setAllowNull(true).build();
    static final AttributeDefinition[] COMMON_LOADER_ATTRIBUTES = new AttributeDefinition[]{SHARED, PRELOAD};
    static final AttributeDefinition[] COMMON_LOADER_PARAMETERS = new AttributeDefinition[]{SHARED, PRELOAD, PROPERTIES};
    private static final OperationDefinition CACHE_LOADER_ADD_DEFINITION = new SimpleOperationDefinitionBuilder("add", InfinispanExtension.getResourceDescriptionResolver("loader")).setParameters(COMMON_LOADER_PARAMETERS).build();
    private static final OperationDefinition RESET_LOADER_STATISTICS = new SimpleOperationDefinitionBuilder("reset-loader-statistics", InfinispanExtension.getResourceDescriptionResolver("loader")).build();

    public BaseLoaderResource(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(pathElement, descriptionResolver, addHandler, removeHandler);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(COMMON_LOADER_ATTRIBUTES);
        for (AttributeDefinition attr : COMMON_LOADER_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
    }

    protected void registerAddOperation(ManagementResourceRegistration registration, OperationStepHandler handler, OperationEntry.Flag ... flags) {
        registration.registerOperationHandler(CACHE_LOADER_ADD_DEFINITION, handler);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)new LoaderPropertyResource());
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(RESET_LOADER_STATISTICS, (OperationStepHandler)CacheCommands.ResetCacheLoaderStatisticsCommand.INSTANCE);
    }
}

