/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;

public enum Attribute {
    UNKNOWN((String)null),
    ACQUIRE_TIMEOUT("acquire-timeout"),
    ALIASES("aliases"),
    APPEND_CACHE_NAME_TO_PATH("append-cache-name-to-path"),
    ASYNC_MARSHALLING("async-marshalling"),
    AUDIT_LOGGER("audit-logger"),
    AUTO_CONFIG("auto-config"),
    AWAIT_INITIAL_TRANSFER("await-initial-transfer"),
    BACKUP_FAILURE_POLICY("failure-policy"),
    BATCH_SIZE("batch-size"),
    BATCHING("batching"),
    BLOCK_SIZE("block-size"),
    BUFFER_SIZE("buffer-size"),
    CACHE("cache"),
    CACHE_SIZE("cache-size"),
    CAPACITY_FACTOR("capacity-factor"),
    CHUNK_SIZE("chunk-size"),
    CLASS("class"),
    CLEAR_THRESHOLD("clear-threshold"),
    CLUSTER("cluster"),
    CONCURRENCY_LEVEL("concurrency-level"),
    CONNECTION_TIMEOUT("connection-timeout"),
    CREATE_ON_START("create-on-start"),
    DATASOURCE("datasource"),
    DEFAULT_CACHE("default-cache"),
    DEFAULT_CACHE_CONTAINER("default-cache-container"),
    DIALECT("dialect"),
    DROP_ON_EXIT("drop-on-exit"),
    EAGER_LOCKING("eager-locking"),
    ENABLED("enabled"),
    EVICTION_EXECUTOR("eviction-executor"),
    EXECUTOR("executor"),
    FETCH_SIZE("fetch-size"),
    FETCH_STATE("fetch-state"),
    FLUSH_LOCK_TIMEOUT("flush-lock-timeout"),
    FLUSH_TIMEOUT("flush-timeout"),
    HOTROD_WRAPPING("hotrod-wrapping"),
    INDEXING("indexing"),
    INDEX("index"),
    INTERVAL("interval"),
    ISOLATION("isolation"),
    JNDI_NAME("jndi-name"),
    L1_LIFESPAN("l1-lifespan"),
    LIFESPAN("lifespan"),
    LISTENER_EXECUTOR("listener-executor"),
    LOCK_TIMEOUT("lock-timeout"),
    LOCKING("locking"),
    MACHINE("machine"),
    MAPPER("mapper"),
    MARSHALLER("marshaller"),
    MAX_CONNECTIONS_PER_HOST("max-connections-per-host"),
    MAX_ENTRIES("max-entries"),
    MAX_IDLE("max-idle"),
    MAX_RETRIES("max-retries"),
    MAX_TOTAL_CONNECTIONS("max-total-connections"),
    MODE("mode"),
    MODIFICATION_QUEUE_SIZE("modification-queue-size"),
    MODULE("module"),
    NAME("name"),
    NAMESPACE("xmlns"),
    OUTBOUND_SOCKET_BINDING("outbound-socket-binding"),
    OWNERS("owners"),
    PASSIVATION("passivation"),
    PATH("path"),
    PERMISSIONS("permissions"),
    PREFIX("prefix"),
    PRELOAD("preload"),
    PURGE("purge"),
    QUEUE_FLUSH_INTERVAL("queue-flush-interval"),
    QUEUE_SIZE("queue-size"),
    RACK("rack"),
    RAW_VALUES("raw-values"),
    READ_ONLY("read-only"),
    RELATIVE_TO("relative-to"),
    REMOTE_CACHE("remote-cache"),
    REMOTE_COMMAND_EXECUTOR("remote-command-executor"),
    REMOTE_SITE("remote-site"),
    REMOTE_TIMEOUT("remote-timeout"),
    REPLICATION_QUEUE_EXECUTOR("replication-queue-executor"),
    ROLES("roles"),
    SEGMENTS("segments"),
    SHARED("shared"),
    SHUTDOWN_TIMEOUT("shutdown-timeout"),
    SINGLETON("singleton"),
    SITE("site"),
    SOCKET_TIMEOUT("socket-timeout"),
    STACK("stack"),
    START("start"),
    STATE_TRANSFER_EXECUTOR("state-transfer-executor"),
    STATISTICS("statistics"),
    STRICT_PEER_TO_PEER("strict-peer-to-peer"),
    STOP_TIMEOUT("stop-timeout"),
    STRATEGY("strategy"),
    STRIPING("striping"),
    TAKE_BACKUP_OFFLINE_AFTER_FAILURES("after-failures"),
    TAKE_BACKUP_OFFLINE_MIN_WAIT("min-wait"),
    TCP_NO_DELAY("tcp-no-delay"),
    THREAD_POOL_SIZE("thread-pool-size"),
    TIMEOUT("timeout"),
    TOTAL_ORDER_EXECUTOR("total-order-executor"),
    TYPE("type"),
    VIRTUAL_NODES("virtual-nodes"),
    WAIT_TIME("wait-time");

    private final String name;
    private final AttributeDefinition definition;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
        this.definition = null;
    }

    private Attribute(AttributeDefinition definition) {
        this.name = definition.getXmlName();
        this.definition = definition;
    }

    public String getLocalName() {
        return this.name;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

