/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheReadAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheRemove;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.RebalancingAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.RestartCacheWriteAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.SharedCacheResource;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DistributedCacheResource
extends SharedCacheResource {
    public static final PathElement DISTRIBUTED_CACHE_PATH = PathElement.pathElement((String)"distributed-cache");
    static final SimpleAttributeDefinition L1_LIFESPAN = new SimpleAttributeDefinitionBuilder("l1-lifespan", ModelType.LONG, true).setXmlName(Attribute.L1_LIFESPAN.getLocalName()).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).setDefaultValue(new ModelNode().set(0)).build();
    static final SimpleAttributeDefinition OWNERS = new SimpleAttributeDefinitionBuilder("owners", ModelType.INT, true).setXmlName(Attribute.OWNERS.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).setDefaultValue(new ModelNode().set(2)).build();
    @Deprecated
    static final SimpleAttributeDefinition VIRTUAL_NODES = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("virtual-nodes", ModelType.INT, true).setXmlName(Attribute.VIRTUAL_NODES.getLocalName()).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).setDefaultValue(new ModelNode().set(1)).setDeprecated(ModelVersion.create((int)1, (int)4, (int)0))).build();
    static final SimpleAttributeDefinition SEGMENTS = new SimpleAttributeDefinitionBuilder("segments", ModelType.INT, true).setXmlName(Attribute.SEGMENTS.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).setDefaultValue(new ModelNode().set(80)).build();
    static final SimpleAttributeDefinition CAPACITY_FACTOR = new SimpleAttributeDefinitionBuilder("capacity-factor", ModelType.DOUBLE, true).setXmlName(Attribute.CAPACITY_FACTOR.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).setDefaultValue(new ModelNode().set(1.0)).build();
    static final SimpleAttributeDefinition REBALANCING = new SimpleAttributeDefinitionBuilder("rebalancing", ModelType.BOOLEAN, true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE}).setDefaultValue(new ModelNode().set(true)).setStorageRuntime().build();
    static final AttributeDefinition[] DISTRIBUTED_CACHE_ATTRIBUTES = new AttributeDefinition[]{OWNERS, SEGMENTS, CAPACITY_FACTOR, L1_LIFESPAN};

    public DistributedCacheResource(ResolvePathHandler resolvePathHandler, boolean runtimeRegistration) {
        super(DISTRIBUTED_CACHE_PATH, InfinispanExtension.getResourceDescriptionResolver("distributed-cache"), DistributedCacheAdd.INSTANCE, (OperationStepHandler)CacheRemove.INSTANCE, resolvePathHandler, runtimeRegistration);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        RestartCacheWriteAttributeHandler restartWriteHandler = new RestartCacheWriteAttributeHandler(this.getPathElement().getKey(), this.getCacheAddHandler(), DISTRIBUTED_CACHE_ATTRIBUTES);
        for (AttributeDefinition attr : DISTRIBUTED_CACHE_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, (OperationStepHandler)CacheReadAttributeHandler.INSTANCE, (OperationStepHandler)restartWriteHandler);
        }
        if (this.runtimeRegistration) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)REBALANCING, (OperationStepHandler)RebalancingAttributeHandler.INSTANCE, (OperationStepHandler)RebalancingAttributeHandler.INSTANCE);
        }
        ModelOnlyWriteAttributeHandler virtualNodesWriteHandler = new ModelOnlyWriteAttributeHandler(new AttributeDefinition[]{VIRTUAL_NODES}){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (operation.hasDefined("value") && operation.get("value").asInt() != 1) {
                    throw InfinispanMessages.MESSAGES.attributeDeprecated("virtual-nodes");
                }
                context.stepCompleted();
            }
        };
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)VIRTUAL_NODES, null, (OperationStepHandler)virtualNodesWriteHandler);
    }
}

