/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.manager.CacheContainer;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactoryService;
import org.jboss.as.clustering.infinispan.subsystem.AuthorizationRoleResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerAuthorizationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.ChannelDependentServiceProvider;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanJndiName;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.TransportResource;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.Services;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class CacheContainerAdd
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)CacheContainerAdd.class.getPackage().getName());
    public static final CacheContainerAdd INSTANCE = new CacheContainerAdd();

    static ModelNode createOperation(ModelNode address, ModelNode existing) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        CacheContainerAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        CacheContainerResource.DEFAULT_CACHE.validateAndSet(source, target);
        if (source.hasDefined("aliases")) {
            target.get("aliases").set(source.get("aliases"));
        }
        CacheContainerResource.JNDI_NAME.validateAndSet(source, target);
        CacheContainerResource.START.validateAndSet(source, target);
        CacheContainerResource.LISTENER_EXECUTOR.validateAndSet(source, target);
        CacheContainerResource.EVICTION_EXECUTOR.validateAndSet(source, target);
        CacheContainerResource.EXPIRATION_EXECUTOR.validateAndSet(source, target);
        CacheContainerResource.STATE_TRANSFER_EXECUTOR.validateAndSet(source, target);
        CacheContainerResource.ASYNC_EXECUTOR.validateAndSet(source, target);
        CacheContainerResource.REPLICATION_QUEUE_EXECUTOR.validateAndSet(source, target);
        CacheContainerResource.CACHE_CONTAINER_MODULE.validateAndSet(source, target);
        CacheContainerResource.STATISTICS.validateAndSet(source, target);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CacheContainerAdd.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        this.installRuntimeServices(context, operation, Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS)));
    }

    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel) throws OperationFailedException {
        ModelNode securityModel;
        String expirationExecutor;
        PathAddress address = this.getCacheContainerAddressFromOperation(operation);
        String name = address.getLastElement().getValue();
        ServiceTarget target = context.getServiceTarget();
        ModelNode resolvedValue = null;
        resolvedValue = CacheContainerResource.DEFAULT_CACHE.resolveModelAttribute(context, containerModel);
        String defaultCache = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CacheContainerResource.JNDI_NAME.resolveModelAttribute(context, containerModel);
        String jndiName = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CacheContainerResource.LISTENER_EXECUTOR.resolveModelAttribute(context, containerModel);
        String listenerExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CacheContainerResource.ASYNC_EXECUTOR.resolveModelAttribute(context, containerModel);
        String asyncExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CacheContainerResource.EXPIRATION_EXECUTOR.resolveModelAttribute(context, containerModel);
        String string = expirationExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        if (expirationExecutor == null) {
            resolvedValue = CacheContainerResource.EVICTION_EXECUTOR.resolveModelAttribute(context, containerModel);
            expirationExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        }
        String replicationQueueExecutor = (resolvedValue = CacheContainerResource.REPLICATION_QUEUE_EXECUTOR.resolveModelAttribute(context, containerModel)).isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CacheContainerResource.STATE_TRANSFER_EXECUTOR.resolveModelAttribute(context, containerModel);
        String stateTransferExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        ServiceController.Mode initialMode = StartMode.valueOf(CacheContainerResource.START.resolveModelAttribute(context, containerModel).asString()).getMode();
        boolean statistics = CacheContainerResource.STATISTICS.resolveModelAttribute(context, containerModel).asBoolean();
        ServiceName[] aliases = null;
        if (containerModel.hasDefined("aliases")) {
            List list = operation.get("aliases").asList();
            aliases = new ServiceName[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                aliases[i] = EmbeddedCacheManagerService.getServiceName(((ModelNode)list.get(i)).asString());
            }
        }
        ModuleIdentifier moduleId = (resolvedValue = CacheContainerResource.CACHE_CONTAINER_MODULE.resolveModelAttribute(context, containerModel)).isDefined() ? ModuleIdentifier.fromString((String)resolvedValue.asString()) : null;
        Transport transportConfig = containerModel.hasDefined("transport") && containerModel.get("transport").hasDefined("TRANSPORT") ? new Transport() : null;
        String stack = null;
        String transportExecutor = null;
        String totalOrderExecutor = null;
        String remoteCommandExecutor = null;
        LinkedList controllers = new LinkedList();
        if (transportConfig != null) {
            ModelNode transport = containerModel.get(new String[]{"transport", "TRANSPORT"});
            resolvedValue = TransportResource.STACK.resolveModelAttribute(context, transport);
            stack = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            resolvedValue = TransportResource.CLUSTER.resolveModelAttribute(context, transport);
            String cluster = resolvedValue.isDefined() ? resolvedValue.asString() : name;
            long lockTimeout = TransportResource.LOCK_TIMEOUT.resolveModelAttribute(context, transport).asLong();
            resolvedValue = TransportResource.EXECUTOR.resolveModelAttribute(context, transport);
            transportExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            resolvedValue = TransportResource.TOTAL_ORDER_EXECUTOR.resolveModelAttribute(context, transport);
            totalOrderExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            resolvedValue = TransportResource.REMOTE_COMMAND_EXECUTOR.resolveModelAttribute(context, transport);
            remoteCommandExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            boolean strictPeerToPeer = TransportResource.STRICT_PEER_TO_PEER.resolveModelAttribute(context, transport).asBoolean();
            transportConfig.setStrictPeerToPeer(strictPeerToPeer);
            transportConfig.setLockTimeout(lockTimeout);
            controllers.add(this.installChannelService(target, name, cluster, stack));
            for (ChannelDependentServiceProvider provider : ServiceFinder.load(ChannelDependentServiceProvider.class, (ClassLoader[])new ClassLoader[]{ChannelDependentServiceProvider.class.getClassLoader()})) {
                controllers.add(provider.install(target, name));
            }
        }
        Authorization authorizationConfig = null;
        if (containerModel.hasDefined("security") && containerModel.get("security").hasDefined("SECURITY") && (securityModel = containerModel.get(new String[]{"security", "SECURITY"})).hasDefined("authorization") && securityModel.get("authorization").hasDefined("AUTHORIZATION")) {
            ModelNode authzModel = securityModel.get(new String[]{"authorization", "AUTHORIZATION"});
            authorizationConfig = new Authorization();
            resolvedValue = CacheContainerAuthorizationResource.MAPPER.resolveModelAttribute(context, authzModel);
            authorizationConfig.setPrincipalMapper(resolvedValue.isDefined() ? resolvedValue.asString() : null);
            for (ModelNode roleNode : authzModel.get("role").asList()) {
                ModelNode role = roleNode.get(0);
                String roleName = AuthorizationRoleResource.NAME.resolveModelAttribute(context, role).asString();
                ArrayList<String> permissions = new ArrayList<String>();
                for (ModelNode permission : AuthorizationRoleResource.PERMISSIONS.resolveModelAttribute(context, role).asList()) {
                    permissions.add(permission.asString());
                }
                authorizationConfig.getRoles().put(roleName, permissions);
            }
        }
        controllers.add(this.installContainerConfigurationService(target, name, defaultCache, statistics, moduleId, stack, transportConfig, authorizationConfig, transportExecutor, totalOrderExecutor, remoteCommandExecutor, listenerExecutor, asyncExecutor, expirationExecutor, replicationQueueExecutor, stateTransferExecutor));
        controllers.add(this.installContainerService(target, name, aliases, transportConfig, initialMode));
        controllers.add(this.installJndiService(target, name, InfinispanJndiName.createCacheContainerJndiName(jndiName, name)));
        controllers.add(this.installKeyAffinityServiceFactoryService(target, name));
        log.debugf("%s cache container installed", (Object)name);
        return controllers;
    }

    void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = this.getCacheContainerAddressFromOperation(operation);
        String containerName = address.getLastElement().getValue();
        context.removeService(KeyAffinityServiceFactoryService.getServiceName(containerName));
        ModelNode resolvedValue = null;
        resolvedValue = CacheContainerResource.JNDI_NAME.resolveModelAttribute(context, model);
        String jndiName = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)InfinispanJndiName.createCacheContainerJndiName(jndiName, containerName));
        context.removeService(bindInfo.getBinderServiceName());
        context.removeService(EmbeddedCacheManagerService.getServiceName(containerName));
        context.removeService(EmbeddedCacheManagerConfigurationService.getServiceName(containerName));
        ServiceName channelServiceName = ChannelService.getServiceName((String)containerName);
        ServiceController channelServiceController = context.getServiceRegistry(false).getService(channelServiceName);
        if (channelServiceController != null) {
            for (ChannelDependentServiceProvider provider : ServiceFinder.load(ChannelDependentServiceProvider.class, (ClassLoader[])new ClassLoader[]{ChannelDependentServiceProvider.class.getClassLoader()})) {
                context.removeService(provider.getServiceName(containerName));
            }
            context.removeService(channelServiceName);
        }
    }

    ServiceController<?> installKeyAffinityServiceFactoryService(ServiceTarget target, String containerName) {
        return target.addService(KeyAffinityServiceFactoryService.getServiceName(containerName), (Service)new KeyAffinityServiceFactoryService(10)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    ServiceController<?> installChannelService(ServiceTarget target, String containerName, String cluster, String stack) {
        InjectedValue channelFactory = new InjectedValue();
        return target.addService(ChannelService.getServiceName((String)containerName), (Service)new ChannelService(cluster, (Value)channelFactory)).addDependency(ChannelFactoryService.getServiceName((String)stack), ChannelFactory.class, (Injector)channelFactory).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    PathAddress getCacheContainerAddressFromOperation(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.get("address"));
    }

    ServiceController<?> installContainerConfigurationService(ServiceTarget target, String containerName, String defaultCache, boolean statistics, ModuleIdentifier moduleId, String stack, Transport transportConfig, Authorization authorizationConfig, String transportExecutor, String totalOrderExecutor, String remoteCommandExecutor, String listenerExecutor, String asyncExecutor, String expirationExecutor, String replicationQueueExecutor, String stateTransferExecutor) {
        ServiceName configServiceName = EmbeddedCacheManagerConfigurationService.getServiceName(containerName);
        EmbeddedCacheManagerDependencies dependencies = new EmbeddedCacheManagerDependencies(transportConfig, authorizationConfig);
        EmbeddedCacheManagerConfigurationService service = new EmbeddedCacheManagerConfigurationService(containerName, defaultCache, statistics, moduleId, dependencies);
        ServiceBuilder configBuilder = target.addService(configServiceName, (Service)service).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, dependencies.getModuleLoaderInjector()).addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, dependencies.getMBeanServerInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (transportConfig != null) {
            if (transportExecutor != null) {
                this.addExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, transportExecutor, transportConfig.getExecutorInjector());
                this.addExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, totalOrderExecutor, transportConfig.getTotalorderExecutorInjector());
                this.addExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, remoteCommandExecutor, transportConfig.getRemoteCommandExecutorInjector());
            }
            configBuilder.addDependency(ChannelFactoryService.getServiceName((String)stack), ChannelFactory.class, transportConfig.getChannelFactoryInjector());
        }
        this.addExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, listenerExecutor, dependencies.getListenerExecutorInjector());
        this.addExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, asyncExecutor, dependencies.getAsyncExecutorInjector());
        this.addExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, stateTransferExecutor, dependencies.getStateTransferExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, expirationExecutor, dependencies.getExpirationExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, replicationQueueExecutor, dependencies.getReplicationQueueExecutorInjector());
        return configBuilder.install();
    }

    ServiceController<?> installContainerService(ServiceTarget target, String containerName, ServiceName[] aliases, Transport transport, ServiceController.Mode initialMode) {
        ServiceName containerServiceName = EmbeddedCacheManagerService.getServiceName(containerName);
        ServiceName configServiceName = EmbeddedCacheManagerConfigurationService.getServiceName(containerName);
        InjectedValue config = new InjectedValue();
        EmbeddedCacheManagerService service = new EmbeddedCacheManagerService((Value<EmbeddedCacheManagerConfiguration>)config);
        ServiceBuilder builder = target.addService(containerServiceName, (Service)service).addDependency(configServiceName, EmbeddedCacheManagerConfiguration.class, (Injector)config).addAliases(aliases).setInitialMode(initialMode);
        if (transport != null) {
            builder.addDependency(ChannelService.getServiceName((String)containerName));
        }
        return builder.install();
    }

    ServiceController<?> installJndiService(ServiceTarget target, String containerName, String jndiName) {
        ServiceName containerServiceName = EmbeddedCacheManagerService.getServiceName(containerName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binder = new BinderService(bindInfo.getBindName());
        return target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName})}).addDependency(containerServiceName, CacheContainer.class, (Injector)new ManagedReferenceInjector((Injector)binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    private void addExecutorDependency(ServiceBuilder<EmbeddedCacheManagerConfiguration> builder, String executor, Injector<Executor> injector) {
        if (executor != null) {
            builder.addDependency(ThreadsServices.executorName((String)executor), Executor.class, injector);
        }
    }

    private void addScheduledExecutorDependency(ServiceBuilder<EmbeddedCacheManagerConfiguration> builder, String executor, Injector<ScheduledExecutorService> injector) {
        if (executor != null) {
            builder.addDependency(ThreadsServices.executorName((String)executor), ScheduledExecutorService.class, injector);
        }
    }

    static class Authorization
    implements EmbeddedCacheManagerConfigurationService.AuthorizationConfiguration {
        private String principalMapper;
        private Map<String, List<String>> roles = new HashMap<String, List<String>>();

        Authorization() {
        }

        public void setPrincipalMapper(String principalMapper) {
            this.principalMapper = principalMapper;
        }

        public void setRoles(Map<String, List<String>> roles) {
            this.roles = roles;
        }

        @Override
        public String getPrincipalMapper() {
            return this.principalMapper;
        }

        @Override
        public Map<String, List<String>> getRoles() {
            return this.roles;
        }
    }

    static class Transport
    implements EmbeddedCacheManagerConfigurationService.TransportConfiguration {
        private final InjectedValue<ChannelFactory> channelFactory = new InjectedValue();
        private final InjectedValue<Executor> executor = new InjectedValue();
        private final InjectedValue<Executor> totalOrderExecutor = new InjectedValue();
        private final InjectedValue<Executor> remoteCommandExecutor = new InjectedValue();
        private Long lockTimeout;
        private boolean strictPeerToPeer;

        Transport() {
        }

        void setLockTimeout(long lockTimeout) {
            this.lockTimeout = lockTimeout;
        }

        void setStrictPeerToPeer(boolean strictPeerToPeer) {
            this.strictPeerToPeer = strictPeerToPeer;
        }

        Injector<ChannelFactory> getChannelFactoryInjector() {
            return this.channelFactory;
        }

        Injector<Executor> getExecutorInjector() {
            return this.executor;
        }

        Injector<Executor> getTotalorderExecutorInjector() {
            return this.totalOrderExecutor;
        }

        Injector<Executor> getRemoteCommandExecutorInjector() {
            return this.remoteCommandExecutor;
        }

        @Override
        public ChannelFactory getChannelFactory() {
            return (ChannelFactory)this.channelFactory.getValue();
        }

        @Override
        public Executor getExecutor() {
            return (Executor)this.executor.getOptionalValue();
        }

        @Override
        public Executor getTotalOrderExecutor() {
            return (Executor)this.totalOrderExecutor.getOptionalValue();
        }

        @Override
        public Executor getRemoteCommandExecutor() {
            return (Executor)this.remoteCommandExecutor.getOptionalValue();
        }

        @Override
        public boolean isStrictPeerToPeer() {
            return this.strictPeerToPeer;
        }

        @Override
        public Long getLockTimeout() {
            return this.lockTimeout;
        }
    }

    static class EmbeddedCacheManagerDependencies
    implements EmbeddedCacheManagerConfigurationService.Dependencies {
        private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
        private final InjectedValue<Executor> listenerExecutor = new InjectedValue();
        private final InjectedValue<Executor> asyncExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> expirationExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> replicationQueueExecutor = new InjectedValue();
        private final InjectedValue<Executor> stateTransferExecutor = new InjectedValue();
        private final EmbeddedCacheManagerConfigurationService.TransportConfiguration transport;
        private final EmbeddedCacheManagerConfigurationService.AuthorizationConfiguration authorization;
        private final InjectedValue<ModuleLoader> moduleLoader = new InjectedValue();

        EmbeddedCacheManagerDependencies(EmbeddedCacheManagerConfigurationService.TransportConfiguration transport, EmbeddedCacheManagerConfigurationService.AuthorizationConfiguration authorization) {
            this.transport = transport;
            this.authorization = authorization;
        }

        Injector<MBeanServer> getMBeanServerInjector() {
            return this.mbeanServer;
        }

        Injector<Executor> getListenerExecutorInjector() {
            return this.listenerExecutor;
        }

        Injector<Executor> getAsyncExecutorInjector() {
            return this.asyncExecutor;
        }

        Injector<Executor> getStateTransferExecutorInjector() {
            return this.stateTransferExecutor;
        }

        Injector<ScheduledExecutorService> getExpirationExecutorInjector() {
            return this.expirationExecutor;
        }

        Injector<ScheduledExecutorService> getReplicationQueueExecutorInjector() {
            return this.replicationQueueExecutor;
        }

        Injector<ModuleLoader> getModuleLoaderInjector() {
            return this.moduleLoader;
        }

        @Override
        public EmbeddedCacheManagerConfigurationService.TransportConfiguration getTransportConfiguration() {
            return this.transport;
        }

        @Override
        public EmbeddedCacheManagerConfigurationService.AuthorizationConfiguration getAuthorizationConfiguration() {
            return this.authorization;
        }

        @Override
        public MBeanServer getMBeanServer() {
            return (MBeanServer)this.mbeanServer.getOptionalValue();
        }

        @Override
        public Executor getListenerExecutor() {
            return (Executor)this.listenerExecutor.getOptionalValue();
        }

        @Override
        public Executor getAsyncExecutor() {
            return (Executor)this.asyncExecutor.getOptionalValue();
        }

        @Override
        public Executor getStateTransferExecutor() {
            return (Executor)this.stateTransferExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getExpirationExecutor() {
            return (ScheduledExecutorService)this.expirationExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getReplicationQueueExecutor() {
            return (ScheduledExecutorService)this.replicationQueueExecutor.getOptionalValue();
        }

        @Override
        public ModuleLoader getModuleLoader() {
            return (ModuleLoader)this.moduleLoader.getValue();
        }
    }
}

