/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.security.impl.ClusterRoleMapper;
import org.infinispan.security.impl.CommonNameRoleMapper;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.infinispan.server.jgroups.subsystem.ChannelResourceDefinition;
import org.infinispan.server.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.AuthorizationRoleResource;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteStateTransferConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseJDBCStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseLoaderConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheAuthorizationConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerAuthorizationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerConfigurationsResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.ClusterLoaderConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.CompatibilityConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.Element;
import org.jboss.as.clustering.infinispan.subsystem.EvictionConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBCompressionConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBExpirationConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBImplementationConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.LoaderConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.LockingConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.Namespace;
import org.jboss.as.clustering.infinispan.subsystem.PartitionHandlingConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.RestStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResource;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.StoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.StorePropertyResource;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResource;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResource;
import org.jboss.as.clustering.infinispan.subsystem.TransactionConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.TransportResource;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public final class InfinispanSubsystemXMLReader
implements XMLElementReader<List<ModelNode>> {
    private static final Logger log = Logger.getLogger(InfinispanSubsystemXMLReader.class);
    private final Namespace namespace;

    public InfinispanSubsystemXMLReader(Namespace namespace) {
        this.namespace = namespace;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> result) throws XMLStreamException {
        LinkedHashMap<PathAddress, ModelNode> operations = new LinkedHashMap<PathAddress, ModelNode>();
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{InfinispanExtension.SUBSYSTEM_PATH});
        ModelNode subsystem = Util.createAddOperation((PathAddress)subsystemAddress);
        operations.put(subsystemAddress, subsystem);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CACHE_CONTAINER: {
                    this.parseContainer(reader, subsystemAddress, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.addAll(operations.values());
    }

    private void parseContainer(XMLExtendedStreamReader reader, PathAddress subsystemAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode container = Util.getEmptyOperation((String)"add", null);
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block35: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block35;
                }
                case ALIASES: {
                    for (String alias : reader.getListAttributeValue(i)) {
                        container.get("aliases").add(alias);
                    }
                    continue block35;
                }
                case DEFAULT_CACHE: {
                    CacheContainerResource.DEFAULT_CACHE.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block35;
                }
                case JNDI_NAME: {
                    CacheContainerResource.JNDI_NAME.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block35;
                }
                case START: {
                    CacheContainerResource.START.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block35;
                }
                case LISTENER_EXECUTOR: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.deprecatedExecutor("listener-executor", "listener-thread-pool");
                    continue block35;
                }
                case ASYNC_EXECUTOR: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.deprecatedExecutor("async-executor", "async-operations-thread-pool");
                    continue block35;
                }
                case EVICTION_EXECUTOR: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.deprecatedExecutor("eviction-executor", "expiration-thread-pool");
                    continue block35;
                }
                case EXPIRATION_EXECUTOR: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.deprecatedExecutor("expiration-executor", "expiration-thread-pool");
                    continue block35;
                }
                case REPLICATION_QUEUE_EXECUTOR: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.deprecatedExecutor("replication-queue-executor", "replication-queue-thread-pool");
                    continue block35;
                }
                case STATE_TRANSFER_EXECUTOR: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.deprecatedExecutor("state-transfer-executor", "state-transfer-thread-pool");
                    continue block35;
                }
                case MODULE: {
                    CacheContainerResource.CACHE_CONTAINER_MODULE.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block35;
                }
                case STATISTICS: {
                    CacheContainerResource.STATISTICS.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block35;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress containerAddress = subsystemAddress.append("cache-container", name);
        container.get("address").set(containerAddress.toModelNode());
        operations.put(containerAddress, container);
        PathAddress configurationsAddress = containerAddress.append(new PathElement[]{CacheContainerConfigurationsResource.PATH});
        operations.put(configurationsAddress, Util.getEmptyOperation((String)"add", (ModelNode)configurationsAddress.toModelNode()));
        Stream.of(ThreadPoolResource.values()).forEach(pool -> operations.put(containerAddress.append(new PathElement[]{pool.getPathElement()}), Util.createAddOperation((PathAddress)containerAddress.append(new PathElement[]{pool.getPathElement()}))));
        Stream.of(ScheduledThreadPoolResource.values()).forEach(pool -> operations.put(containerAddress.append(new PathElement[]{pool.getPathElement()}), Util.createAddOperation((PathAddress)containerAddress.append(new PathElement[]{pool.getPathElement()}))));
        block37: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TRANSPORT: {
                    this.parseTransport(reader, containerAddress, operations);
                    continue block37;
                }
                case SECURITY: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_7_0)) {
                        this.parseGlobalSecurity(reader, containerAddress, operations);
                        continue block37;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case LOCAL_CACHE: {
                    this.parseLocalCache(reader, containerAddress, operations, false);
                    continue block37;
                }
                case LOCAL_CACHE_CONFIGURATION: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        this.parseLocalCache(reader, containerAddress, operations, true);
                        continue block37;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case INVALIDATION_CACHE: {
                    this.parseInvalidationCache(reader, containerAddress, operations, false);
                    continue block37;
                }
                case INVALIDATION_CACHE_CONFIGURATION: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        this.parseInvalidationCache(reader, containerAddress, operations, true);
                        continue block37;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case REPLICATED_CACHE: {
                    this.parseReplicatedCache(reader, containerAddress, operations, false);
                    continue block37;
                }
                case REPLICATED_CACHE_CONFIGURATION: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        this.parseReplicatedCache(reader, containerAddress, operations, true);
                        continue block37;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(reader, containerAddress, operations, false);
                    continue block37;
                }
                case DISTRIBUTED_CACHE_CONFIGURATION: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        this.parseDistributedCache(reader, containerAddress, operations, true);
                        continue block37;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case ASYNC_OPERATIONS_THREAD_POOL: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        this.parseThreadPool(ThreadPoolResource.ASYNC_OPERATIONS, reader, containerAddress, operations);
                        continue block37;
                    }
                }
                case EXPIRATION_THREAD_POOL: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        this.parseScheduledThreadPool(ScheduledThreadPoolResource.EXPIRATION, reader, containerAddress, operations);
                        continue block37;
                    }
                }
                case LISTENER_THREAD_POOL: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        this.parseThreadPool(ThreadPoolResource.LISTENER, reader, containerAddress, operations);
                        continue block37;
                    }
                }
                case PERSISTENCE_THREAD_POOL: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        this.parseThreadPool(ThreadPoolResource.PERSISTENCE, reader, containerAddress, operations);
                        continue block37;
                    }
                }
                case REMOTE_COMMAND_THREAD_POOL: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        this.parseThreadPool(ThreadPoolResource.REMOTE_COMMAND, reader, containerAddress, operations);
                        continue block37;
                    }
                }
                case REPLICATION_QUEUE_THREAD_POOL: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        this.parseScheduledThreadPool(ScheduledThreadPoolResource.REPLICATION_QUEUE, reader, containerAddress, operations);
                        continue block37;
                    }
                }
                case STATE_TRANSFER_THREAD_POOL: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        this.parseThreadPool(ThreadPoolResource.STATE_TRANSFER, reader, containerAddress, operations);
                        continue block37;
                    }
                }
                case TRANSPORT_THREAD_POOL: {
                    if (!this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) break;
                    this.parseThreadPool(ThreadPoolResource.TRANSPORT, reader, containerAddress, operations);
                    continue block37;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress transportAddress = containerAddress.append("transport", "TRANSPORT");
        ModelNode transport = Util.createAddOperation((PathAddress)transportAddress);
        String stack = null;
        String cluster = null;
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CHANNEL: {
                    TransportResource.CHANNEL.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block10;
                }
                case EXECUTOR: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.deprecatedExecutor("executor", "transport-thread-pool");
                    continue block10;
                }
                case LOCK_TIMEOUT: {
                    TransportResource.LOCK_TIMEOUT.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block10;
                }
                case REMOTE_COMMAND_EXECUTOR: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    InfinispanLogger.ROOT_LOGGER.deprecatedExecutor("remote-command-executor", "remote-command-thread-pool");
                    continue block10;
                }
                case STRICT_PEER_TO_PEER: {
                    TransportResource.STRICT_PEER_TO_PEER.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block10;
                }
                case TOTAL_ORDER_EXECUTOR: {
                    if (!this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        log.warn((Object)"The xml element total-order-executor has been removed and has no effect, please update your configuration file.");
                        continue block10;
                    }
                }
                case STACK: {
                    if (!this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        stack = value;
                        continue block10;
                    }
                }
                case CLUSTER: {
                    if (!this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                        cluster = value;
                        continue block10;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
            String channel = cluster != null ? cluster : "cluster-" + containerAddress.getLastElement().getValue();
            TransportResource.CHANNEL.parseAndSetParameter(channel, transport, (XMLStreamReader)reader);
            PathAddress channelAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH, ChannelResourceDefinition.pathElement((String)channel)});
            ModelNode channelOperation = Util.createAddOperation((PathAddress)channelAddress);
            if (stack != null) {
                ChannelResourceDefinition.STACK.parseAndSetParameter(stack, channelOperation, (XMLStreamReader)reader);
            }
            operations.put(channelAddress, channelOperation);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(transportAddress, transport);
    }

    private void parseGlobalSecurity(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress securityAddress = containerAddress.append("security", "SECURITY");
        ModelNode security = Util.createAddOperation((PathAddress)securityAddress);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHORIZATION: {
                    this.parseGlobalAuthorization(reader, securityAddress, additionalConfigurationOperations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.put(securityAddress, security);
        operations.putAll(additionalConfigurationOperations);
    }

    private void parseGlobalAuthorization(XMLExtendedStreamReader reader, PathAddress securityAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress authorizationAddress = securityAddress.append("authorization", "AUTHORIZATION");
        ModelNode authorization = Util.createAddOperation((PathAddress)authorizationAddress);
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUDIT_LOGGER: {
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        String roleMapper = null;
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case IDENTITY_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    roleMapper = IdentityRoleMapper.class.getName();
                    continue block11;
                }
                case COMMON_NAME_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    roleMapper = CommonNameRoleMapper.class.getName();
                    continue block11;
                }
                case CLUSTER_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    roleMapper = ClusterRoleMapper.class.getName();
                    continue block11;
                }
                case CUSTOM_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    roleMapper = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.CLASS.getLocalName());
                    continue block11;
                }
                case ROLE: {
                    this.parseGlobalRole(reader, authorizationAddress, additionalConfigurationOperations);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        CacheContainerAuthorizationResource.MAPPER.parseAndSetParameter(roleMapper, authorization, (XMLStreamReader)reader);
        operations.put(authorizationAddress, authorization);
        operations.putAll(additionalConfigurationOperations);
    }

    private void parseGlobalRole(XMLExtendedStreamReader reader, PathAddress authorizationAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.PERMISSIONS.getLocalName()});
        String name = attributes[0];
        PathAddress roleAddress = authorizationAddress.append("role", name);
        ModelNode role = Util.createAddOperation((PathAddress)roleAddress);
        AuthorizationRoleResource.NAME.parseAndSetParameter(name, role, (XMLStreamReader)reader);
        for (String perm : attributes[1].split("\\s+")) {
            AuthorizationRoleResource.PERMISSIONS.parseAndAddParameterElement(perm, role, (XMLStreamReader)reader);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(roleAddress, role);
    }

    private void parseCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode cache) throws XMLStreamException {
        switch (attribute) {
            case NAME: {
                CacheConfigurationResource.NAME.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case START: {
                CacheConfigurationResource.START.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                if (value.equalsIgnoreCase("EAGER")) break;
                Location location = reader.getLocation();
                log.warnf("Ignoring start mode [%s] at [row,col] [%s, %s], as EAGER is the only supported mode", (Object)value, (Object)location.getLineNumber(), (Object)location.getColumnNumber());
                cache.get(CacheConfigurationResource.START.getName()).set("EAGER");
                break;
            }
            case CONFIGURATION: {
                CacheConfigurationResource.CONFIGURATION.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case JNDI_NAME: {
                CacheConfigurationResource.JNDI_NAME.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case BATCHING: {
                CacheConfigurationResource.BATCHING.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case MODULE: {
                CacheConfigurationResource.CACHE_MODULE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case SIMPLE_CACHE: {
                CacheConfigurationResource.SIMPLE_CACHE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case STATISTICS: {
                CacheConfigurationResource.STATISTICS.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case STATISTICS_AVAILABLE: {
                CacheConfigurationResource.STATISTICS_AVAILABLE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseClusteredCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode cache) throws XMLStreamException {
        switch (attribute) {
            case ASYNC_MARSHALLING: {
                if (this.namespace.since(Namespace.INFINISPAN_SERVER_8_0)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
                }
                log.warn((Object)"The async-marshalling attribute has been deprecated and has no effect, please update your configuration file.");
                break;
            }
            case MODE: {
                ClusteredCacheConfigurationResource.MODE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case QUEUE_SIZE: {
                ClusteredCacheConfigurationResource.QUEUE_SIZE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case QUEUE_FLUSH_INTERVAL: {
                ClusteredCacheConfigurationResource.QUEUE_FLUSH_INTERVAL.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case REMOTE_TIMEOUT: {
                ClusteredCacheConfigurationResource.REMOTE_TIMEOUT.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            default: {
                this.parseCacheAttribute(reader, index, attribute, value, cache);
            }
        }
    }

    private void addCacheForConfiguration(ModelNode cacheConfiguration, String configurationName, PathAddress containerAddress, String type, Map<PathAddress, ModelNode> operations) {
        String name = PathAddress.pathAddress((ModelNode)cacheConfiguration.get("address")).getLastElement().getValue();
        PathAddress cacheAddress = containerAddress.append(type, name);
        ModelNode cache = Util.getEmptyOperation((String)"add", (ModelNode)cacheAddress.toModelNode());
        cache.get("configuration").set(configurationName == null ? name : configurationName);
        operations.put(cacheAddress, cache);
    }

    private void parseLocalCache(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations, boolean configurationOnly) throws XMLStreamException {
        ModelNode cacheConfiguration = Util.getEmptyOperation((String)"add", null);
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseCacheAttribute(reader, i, attribute, value, cacheConfiguration);
        }
        if (!cacheConfiguration.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        PathAddress cacheConfigurationAddress = this.addNameToAddress(cacheConfiguration, containerAddress, "local-cache");
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            this.parseCacheElement(reader, element, cacheConfiguration, additionalConfigurationOperations);
        }
        this.addCacheConfiguration("local-cache", containerAddress, operations, configurationOnly, cacheConfiguration, additionalConfigurationOperations, cacheConfigurationAddress);
    }

    private void addCacheConfiguration(String cacheType, PathAddress containerAddress, Map<PathAddress, ModelNode> operations, boolean configurationOnly, ModelNode cacheConfiguration, Map<PathAddress, ModelNode> additionalConfigurationOperations, PathAddress cacheConfigurationAddress) {
        if (configurationOnly) {
            operations.put(cacheConfigurationAddress, cacheConfiguration);
            operations.putAll(additionalConfigurationOperations);
        } else if (cacheConfiguration.hasDefined("configuration") && additionalConfigurationOperations.size() == 0) {
            this.addCacheForConfiguration(cacheConfiguration, cacheConfiguration.get("configuration").asString(), containerAddress, cacheType, operations);
        } else {
            operations.put(cacheConfigurationAddress, cacheConfiguration);
            operations.putAll(additionalConfigurationOperations);
            this.addCacheForConfiguration(cacheConfiguration, null, containerAddress, cacheType, operations);
        }
    }

    private void parseDistributedCache(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations, boolean configurationOnly) throws XMLStreamException {
        ModelNode cacheConfiguration = Util.getEmptyOperation((String)"add", null);
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OWNERS: {
                    DistributedCacheConfigurationResource.OWNERS.parseAndSetParameter(value, cacheConfiguration, (XMLStreamReader)reader);
                    continue block10;
                }
                case SEGMENTS: {
                    DistributedCacheConfigurationResource.SEGMENTS.parseAndSetParameter(value, cacheConfiguration, (XMLStreamReader)reader);
                    continue block10;
                }
                case CAPACITY_FACTOR: {
                    DistributedCacheConfigurationResource.CAPACITY_FACTOR.parseAndSetParameter(value, cacheConfiguration, (XMLStreamReader)reader);
                    continue block10;
                }
                case L1_LIFESPAN: {
                    DistributedCacheConfigurationResource.L1_LIFESPAN.parseAndSetParameter(value, cacheConfiguration, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    this.parseClusteredCacheAttribute(reader, i, attribute, value, cacheConfiguration);
                }
            }
        }
        if (!cacheConfiguration.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cacheConfiguration.hasDefined("mode") && !cacheConfiguration.hasDefined("configuration")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        PathAddress cacheConfigurationAddress = this.addNameToAddress(cacheConfiguration, containerAddress, "distributed-cache");
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PARTITION_HANDLING: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_7_0)) {
                        this.parsePartitionHandling(reader, cacheConfiguration, additionalConfigurationOperations);
                        continue block11;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, cacheConfiguration, additionalConfigurationOperations);
                    continue block11;
                }
            }
            this.parseCacheElement(reader, element, cacheConfiguration, additionalConfigurationOperations);
        }
        this.addCacheConfiguration("distributed-cache", containerAddress, operations, configurationOnly, cacheConfiguration, additionalConfigurationOperations, cacheConfigurationAddress);
    }

    private void parseReplicatedCache(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations, boolean configurationOnly) throws XMLStreamException {
        ModelNode cacheConfiguration = Util.getEmptyOperation((String)"add", null);
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseClusteredCacheAttribute(reader, i, attribute, value, cacheConfiguration);
        }
        if (!cacheConfiguration.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cacheConfiguration.hasDefined("mode") && !cacheConfiguration.hasDefined("configuration")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        PathAddress cacheConfigurationAddress = this.addNameToAddress(cacheConfiguration, containerAddress, "replicated-cache");
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PARTITION_HANDLING: {
                    this.parsePartitionHandling(reader, cacheConfiguration, additionalConfigurationOperations);
                    continue block5;
                }
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, cacheConfiguration, additionalConfigurationOperations);
                    continue block5;
                }
            }
            this.parseCacheElement(reader, element, cacheConfiguration, additionalConfigurationOperations);
        }
        this.addCacheConfiguration("replicated-cache", containerAddress, operations, configurationOnly, cacheConfiguration, additionalConfigurationOperations, cacheConfigurationAddress);
    }

    private void parseInvalidationCache(XMLExtendedStreamReader reader, PathAddress containerAddress, Map<PathAddress, ModelNode> operations, boolean configurationOnly) throws XMLStreamException {
        ModelNode cacheConfiguration = Util.getEmptyOperation((String)"add", null);
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseClusteredCacheAttribute(reader, i, attribute, value, cacheConfiguration);
        }
        if (!cacheConfiguration.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cacheConfiguration.hasDefined("mode") && !cacheConfiguration.hasDefined("configuration")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        PathAddress cacheConfigurationAddress = this.addNameToAddress(cacheConfiguration, containerAddress, "invalidation-cache");
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseCacheElement(reader, element, cacheConfiguration, additionalConfigurationOperations);
        }
        this.addCacheConfiguration("invalidation-cache", containerAddress, operations, configurationOnly, cacheConfiguration, additionalConfigurationOperations, cacheConfigurationAddress);
    }

    private PathAddress addNameToAddress(ModelNode current, PathAddress containerAddress, String type) {
        String name = current.get("name").asString();
        PathAddress cacheConfigurationAddress = containerAddress.append("configurations", "CONFIGURATIONS").append(type + "-configuration", name);
        current.get("address").set(cacheConfigurationAddress.toModelNode());
        current.remove("name");
        return cacheConfigurationAddress;
    }

    private void parseCacheElement(XMLExtendedStreamReader reader, Element element, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        switch (element) {
            case BACKUPS: {
                this.parseBackups(reader, cache, operations);
                break;
            }
            case BACKUP_FOR: {
                if (this.namespace.since(Namespace.INFINISPAN_SERVER_7_0)) {
                    this.parseBackupFor(reader, cache);
                    break;
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            case CLUSTER_LOADER: {
                this.parseClusterLoader(reader, cache, operations);
                break;
            }
            case COMPATIBILITY: {
                this.parseCompatibility(reader, cache, operations);
                break;
            }
            case LOCKING: {
                this.parseLocking(reader, cache, operations);
                break;
            }
            case TRANSACTION: {
                this.parseTransaction(reader, cache, operations);
                break;
            }
            case EVICTION: {
                this.parseEviction(reader, cache, operations);
                break;
            }
            case EXPIRATION: {
                this.parseExpiration(reader, cache, operations);
                break;
            }
            case LOADER: {
                this.parseCustomLoader(reader, cache, operations);
                break;
            }
            case STORE: {
                this.parseCustomStore(reader, cache, operations);
                break;
            }
            case FILE_STORE: {
                this.parseFileStore(reader, cache, operations);
                break;
            }
            case STRING_KEYED_JDBC_STORE: {
                this.parseStringKeyedJDBCStore(reader, cache, operations);
                break;
            }
            case BINARY_KEYED_JDBC_STORE: {
                this.parseBinaryKeyedJDBCStore(reader, cache, operations);
                break;
            }
            case MIXED_KEYED_JDBC_STORE: {
                this.parseMixedKeyedJDBCStore(reader, cache, operations);
                break;
            }
            case REMOTE_STORE: {
                this.parseRemoteStore(reader, cache, operations);
                break;
            }
            case LEVELDB_STORE: {
                this.parseLevelDBStore(reader, cache, operations);
                break;
            }
            case REST_STORE: {
                this.parseRestStore(reader, cache, operations);
                break;
            }
            case INDEXING: {
                this.parseIndexing(reader, cache);
                break;
            }
            case SECURITY: {
                if (this.namespace.since(Namespace.INFINISPAN_SERVER_7_0)) {
                    this.parseCacheSecurity(reader, cache, operations);
                    break;
                }
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseStateTransfer(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress stateTransferAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("state-transfer", "STATE_TRANSFER");
        ModelNode stateTransfer = Util.createAddOperation((PathAddress)stateTransferAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AWAIT_INITIAL_TRANSFER: {
                    StateTransferConfigurationResource.AWAIT_INITIAL_TRANSFER.parseAndSetParameter(value, stateTransfer, (XMLStreamReader)reader);
                    continue block6;
                }
                case ENABLED: {
                    StateTransferConfigurationResource.ENABLED.parseAndSetParameter(value, stateTransfer, (XMLStreamReader)reader);
                    continue block6;
                }
                case TIMEOUT: {
                    StateTransferConfigurationResource.TIMEOUT.parseAndSetParameter(value, stateTransfer, (XMLStreamReader)reader);
                    continue block6;
                }
                case CHUNK_SIZE: {
                    StateTransferConfigurationResource.CHUNK_SIZE.parseAndSetParameter(value, stateTransfer, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(stateTransferAddress, stateTransfer);
    }

    private void parseLocking(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress lockingAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("locking", "LOCKING");
        ModelNode locking = Util.createAddOperation((PathAddress)lockingAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ISOLATION: {
                    LockingConfigurationResource.ISOLATION.parseAndSetParameter(value, locking, (XMLStreamReader)reader);
                    continue block6;
                }
                case STRIPING: {
                    LockingConfigurationResource.STRIPING.parseAndSetParameter(value, locking, (XMLStreamReader)reader);
                    continue block6;
                }
                case ACQUIRE_TIMEOUT: {
                    LockingConfigurationResource.ACQUIRE_TIMEOUT.parseAndSetParameter(value, locking, (XMLStreamReader)reader);
                    continue block6;
                }
                case CONCURRENCY_LEVEL: {
                    LockingConfigurationResource.CONCURRENCY_LEVEL.parseAndSetParameter(value, locking, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(lockingAddress, locking);
    }

    private void parseTransaction(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress transactionAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append(new PathElement[]{TransactionConfigurationResource.PATH});
        ModelNode transaction = Util.createAddOperation((PathAddress)transactionAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STOP_TIMEOUT: {
                    TransactionConfigurationResource.STOP_TIMEOUT.parseAndSetParameter(value, transaction, (XMLStreamReader)reader);
                    continue block6;
                }
                case MODE: {
                    TransactionConfigurationResource.MODE.parseAndSetParameter(value, transaction, (XMLStreamReader)reader);
                    continue block6;
                }
                case LOCKING: {
                    TransactionConfigurationResource.LOCKING.parseAndSetParameter(value, transaction, (XMLStreamReader)reader);
                    continue block6;
                }
                case NOTIFICATIONS: {
                    TransactionConfigurationResource.NOTIFICATIONS.parseAndSetParameter(value, transaction, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(transactionAddress, transaction);
    }

    private void parseEviction(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress evictionAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append(new PathElement[]{EvictionConfigurationResource.PATH});
        ModelNode eviction = Util.createAddOperation((PathAddress)evictionAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STRATEGY: {
                    EvictionConfigurationResource.EVICTION_STRATEGY.parseAndSetParameter(value, eviction, (XMLStreamReader)reader);
                    continue block6;
                }
                case MAX_ENTRIES: {
                    EvictionConfigurationResource.MAX_ENTRIES.parseAndSetParameter(value, eviction, (XMLStreamReader)reader);
                    continue block6;
                }
                case TYPE: {
                    EvictionConfigurationResource.TYPE.parseAndSetParameter(value, eviction, (XMLStreamReader)reader);
                    continue block6;
                }
                case SIZE: {
                    EvictionConfigurationResource.SIZE.parseAndSetParameter(value, eviction, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(evictionAddress, eviction);
    }

    private void parseExpiration(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress expirationAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append(new PathElement[]{ExpirationConfigurationResource.PATH});
        ModelNode expiration = Util.createAddOperation((PathAddress)expirationAddress);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_IDLE: {
                    ExpirationConfigurationResource.MAX_IDLE.parseAndSetParameter(value, expiration, (XMLStreamReader)reader);
                    continue block5;
                }
                case LIFESPAN: {
                    ExpirationConfigurationResource.LIFESPAN.parseAndSetParameter(value, expiration, (XMLStreamReader)reader);
                    continue block5;
                }
                case INTERVAL: {
                    ExpirationConfigurationResource.INTERVAL.parseAndSetParameter(value, expiration, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(expirationAddress, expiration);
    }

    private PathAddress setOperationAddress(ModelNode operation, PathAddress address, PathElement element, String name) {
        address = address.append(element.getKey(), name);
        operation.get("address").set(address.toModelNode());
        if (operation.hasDefined("name")) {
            operation.remove("name");
        }
        return address;
    }

    private void parseCustomLoader(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode loader = Util.getEmptyOperation((String)"add", null);
        String name = "LOADER";
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    StoreConfigurationResource.CLASS.parseAndSetParameter(value, loader, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    name = this.parseLoaderAttribute(name, reader, i, attribute, value, loader);
                }
            }
        }
        if (!loader.hasDefined("class")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.CLASS));
        }
        PathAddress loaderAddress = this.setOperationAddress(loader, PathAddress.pathAddress((ModelNode)cache.get("address")), LoaderConfigurationResource.LOADER_PATH, name);
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        this.parseLoaderElements(reader, loader, additionalConfigurationOperations);
        operations.put(loaderAddress, loader);
        operations.putAll(additionalConfigurationOperations);
    }

    private void parseClusterLoader(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode loader = Util.getEmptyOperation((String)"add", null);
        String name = "CLUSTER_LOADER";
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOTE_TIMEOUT: {
                    ClusterLoaderConfigurationResource.REMOTE_TIMEOUT.parseAndSetParameter(value, loader, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    name = this.parseLoaderAttribute(name, reader, i, attribute, value, loader);
                }
            }
        }
        PathAddress loaderAddress = this.setOperationAddress(loader, PathAddress.pathAddress((ModelNode)cache.get("address")), ClusterLoaderConfigurationResource.PATH, name);
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        this.parseLoaderElements(reader, loader, additionalConfigurationOperations);
        operations.put(loaderAddress, loader);
        operations.putAll(additionalConfigurationOperations);
    }

    private void parseCustomStore(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "STORE";
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    StoreConfigurationResource.CLASS.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("class")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.CLASS));
        }
        PathAddress storeAddress = this.setOperationAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), StoreConfigurationResource.STORE_PATH, name);
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        this.parseStoreElements(reader, store, additionalConfigurationOperations);
        operations.put(storeAddress, store);
        operations.putAll(additionalConfigurationOperations);
    }

    private void parseFileStore(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "FILE_STORE";
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_ENTRIES: {
                    FileStoreResource.MAX_ENTRIES.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block5;
                }
                case RELATIVE_TO: {
                    FileStoreResource.RELATIVE_TO.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block5;
                }
                case PATH: {
                    FileStoreResource.PATH.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        PathAddress storeAddress = this.setOperationAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), FileStoreResource.FILE_STORE_PATH, name);
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        this.parseStoreElements(reader, store, additionalConfigurationOperations);
        operations.put(storeAddress, store);
        operations.putAll(additionalConfigurationOperations);
    }

    private void parseRemoteStore(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "REMOTE_STORE";
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CACHE: {
                    RemoteStoreConfigurationResource.CACHE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                case HOTROD_WRAPPING: {
                    RemoteStoreConfigurationResource.HOTROD_WRAPPING.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                case RAW_VALUES: {
                    RemoteStoreConfigurationResource.RAW_VALUES.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                case SOCKET_TIMEOUT: {
                    RemoteStoreConfigurationResource.SOCKET_TIMEOUT.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                case TCP_NO_DELAY: {
                    RemoteStoreConfigurationResource.TCP_NO_DELAY.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        PathAddress storeAddress = this.setOperationAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), RemoteStoreConfigurationResource.REMOTE_STORE_PATH, name);
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SERVER: {
                    this.parseRemoteServer(reader, store.get("remote-servers").add());
                    continue block12;
                }
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, additionalConfigurationOperations);
                    continue block12;
                }
            }
            this.parseStoreProperty(reader, store, additionalConfigurationOperations);
        }
        if (!store.hasDefined("remote-servers")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Element.REMOTE_SERVER));
        }
        operations.put(storeAddress, store);
        operations.putAll(additionalConfigurationOperations);
    }

    private void parseLevelDBStore(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "LEVELDB_STORE";
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    LevelDBStoreConfigurationResource.PATH.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                case BLOCK_SIZE: {
                    LevelDBStoreConfigurationResource.BLOCK_SIZE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                case CACHE_SIZE: {
                    LevelDBStoreConfigurationResource.CACHE_SIZE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                case CLEAR_THRESHOLD: {
                    LevelDBStoreConfigurationResource.CLEAR_THRESHOLD.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        PathAddress storeAddress = this.setOperationAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), LevelDBStoreConfigurationResource.LEVELDB_STORE_PATH, name);
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case EXPIRATION: {
                    this.parseStoreExpiry(reader, store, additionalConfigurationOperations);
                    continue block12;
                }
                case COMPRESSION: {
                    this.parseStoreCompression(reader, store, additionalConfigurationOperations);
                    continue block12;
                }
                case IMPLEMENTATION: {
                    this.parseStoreImplementation(reader, store, additionalConfigurationOperations);
                    continue block12;
                }
            }
            this.parseStoreProperty(reader, store, additionalConfigurationOperations);
        }
        operations.put(storeAddress, store);
        operations.putAll(additionalConfigurationOperations);
    }

    private void parseStoreExpiry(XMLExtendedStreamReader reader, ModelNode store, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress storeExpiryAddress = PathAddress.pathAddress((ModelNode)store.get("address")).append("expiration", "EXPIRATION");
        ModelNode storeExpiry = Util.createAddOperation((PathAddress)storeExpiryAddress);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    LevelDBExpirationConfigurationResource.PATH.parseAndSetParameter(value, storeExpiry, (XMLStreamReader)reader);
                    continue block4;
                }
                case QUEUE_SIZE: {
                    LevelDBExpirationConfigurationResource.QUEUE_SIZE.parseAndSetParameter(value, storeExpiry, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(storeExpiryAddress, storeExpiry);
    }

    private void parseStoreCompression(XMLExtendedStreamReader reader, ModelNode store, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress storeCompressionAddress = PathAddress.pathAddress((ModelNode)store.get("address")).append("compression", "COMPRESSION");
        ModelNode storeCompression = Util.createAddOperation((PathAddress)storeCompressionAddress);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    LevelDBCompressionConfigurationResource.TYPE.parseAndSetParameter(value, storeCompression, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(storeCompressionAddress, storeCompression);
    }

    private void parseStoreImplementation(XMLExtendedStreamReader reader, ModelNode store, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress storeImplementationAddress = PathAddress.pathAddress((ModelNode)store.get("address")).append("implementation", "IMPLEMENTATION");
        ModelNode storeImplementation = Util.createAddOperation((PathAddress)storeImplementationAddress);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    LevelDBImplementationConfigurationResource.TYPE.parseAndSetParameter(value, storeImplementation, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(storeImplementationAddress, storeImplementation);
    }

    private void parseRemoteServer(XMLExtendedStreamReader reader, ModelNode server) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OUTBOUND_SOCKET_BINDING: {
                    RemoteStoreConfigurationResource.OUTBOUND_SOCKET_BINDING.parseAndSetParameter(value, server, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseRestStore(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "REST_STORE";
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case APPEND_CACHE_NAME_TO_PATH: {
                    RestStoreConfigurationResource.APPEND_CACHE_NAME_TO_PATH.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block9;
                }
                case PATH: {
                    RestStoreConfigurationResource.PATH.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        PathAddress storeAddress = this.setOperationAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), RestStoreConfigurationResource.REST_STORE_PATH, name);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTION_POOL: {
                    this.parseRestConnectionPool(reader, store.get("connection-pool").setEmptyObject());
                    continue block10;
                }
                case REMOTE_SERVER: {
                    this.parseRemoteServer(reader, store.get("remote-servers").add());
                    continue block10;
                }
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, additionalConfigurationOperations);
                    continue block10;
                }
            }
            this.parseStoreProperty(reader, store, additionalConfigurationOperations);
        }
        if (!store.hasDefined("remote-servers")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Element.REMOTE_SERVER));
        }
        operations.put(storeAddress, store);
        operations.putAll(additionalConfigurationOperations);
    }

    private void parseRestConnectionPool(XMLExtendedStreamReader reader, ModelNode table) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case BUFFER_SIZE: {
                    RestStoreConfigurationResource.BUFFER_SIZE.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block8;
                }
                case CONNECTION_TIMEOUT: {
                    RestStoreConfigurationResource.CONNECTION_TIMEOUT.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block8;
                }
                case MAX_CONNECTIONS_PER_HOST: {
                    RestStoreConfigurationResource.MAX_CONNECTIONS_PER_HOST.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block8;
                }
                case MAX_TOTAL_CONNECTIONS: {
                    RestStoreConfigurationResource.MAX_TOTAL_CONNECTIONS.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block8;
                }
                case SOCKET_TIMEOUT: {
                    RestStoreConfigurationResource.SOCKET_TIMEOUT.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block8;
                }
                case TCP_NO_DELAY: {
                    RestStoreConfigurationResource.TCP_NO_DELAY.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseStringKeyedJDBCStore(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "STRING_KEYED_JDBC_STORE";
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE: {
                    BaseJDBCStoreConfigurationResource.DATA_SOURCE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block8;
                }
                case DIALECT: {
                    BaseJDBCStoreConfigurationResource.DIALECT.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("datasource")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DATASOURCE));
        }
        PathAddress storeAddress = this.setOperationAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), StringKeyedJDBCStoreResource.PATH, name);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("string-keyed-table").setEmptyObject());
                    continue block9;
                }
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, additionalConfigurationOperations);
                    continue block9;
                }
            }
            this.parseStoreProperty(reader, store, additionalConfigurationOperations);
        }
        operations.put(storeAddress, store);
        operations.putAll(additionalConfigurationOperations);
    }

    private void parseBinaryKeyedJDBCStore(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "BINARY_KEYED_JDBC_STORE";
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE: {
                    BaseJDBCStoreConfigurationResource.DATA_SOURCE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block8;
                }
                case DIALECT: {
                    BaseJDBCStoreConfigurationResource.DIALECT.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("datasource")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DATASOURCE));
        }
        PathAddress storeAddress = this.setOperationAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), BinaryKeyedJDBCStoreConfigurationResource.PATH, name);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BINARY_KEYED_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("binary-keyed-table").setEmptyObject());
                    continue block9;
                }
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, additionalConfigurationOperations);
                    continue block9;
                }
            }
            this.parseStoreProperty(reader, store, additionalConfigurationOperations);
        }
        operations.put(storeAddress, store);
        operations.putAll(additionalConfigurationOperations);
    }

    private void parseMixedKeyedJDBCStore(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "MIXED_KEYED_JDBC_STORE";
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE: {
                    BaseJDBCStoreConfigurationResource.DATA_SOURCE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block10;
                }
                case DIALECT: {
                    BaseJDBCStoreConfigurationResource.DIALECT.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("datasource")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DATASOURCE));
        }
        PathAddress storeAddress = this.setOperationAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), MixedKeyedJDBCStoreConfigurationResource.PATH, name);
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("string-keyed-table").setEmptyObject());
                    continue block11;
                }
                case BINARY_KEYED_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("binary-keyed-table").setEmptyObject());
                    continue block11;
                }
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, additionalConfigurationOperations);
                    continue block11;
                }
                case PROPERTY: {
                    this.parseStoreProperty(reader, store, additionalConfigurationOperations);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.put(storeAddress, store);
        operations.putAll(additionalConfigurationOperations);
    }

    private void parseJDBCStoreTable(XMLExtendedStreamReader reader, ModelNode table) throws XMLStreamException {
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PREFIX: {
                    BaseJDBCStoreConfigurationResource.PREFIX.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block12;
                }
                case FETCH_SIZE: {
                    BaseJDBCStoreConfigurationResource.FETCH_SIZE.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block12;
                }
                case BATCH_SIZE: {
                    BaseJDBCStoreConfigurationResource.BATCH_SIZE.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block12;
                }
                case CREATE_ON_START: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_7_2)) {
                        BaseJDBCStoreConfigurationResource.CREATE_ON_START.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                        continue block12;
                    }
                }
                case DROP_ON_EXIT: {
                    if (this.namespace.since(Namespace.INFINISPAN_SERVER_7_2)) {
                        BaseJDBCStoreConfigurationResource.DROP_ON_EXIT.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                        continue block12;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ID_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("id-column").setEmptyObject());
                    continue block13;
                }
                case DATA_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("data-column").setEmptyObject());
                    continue block13;
                }
                case TIMESTAMP_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("timestamp-column").setEmptyObject());
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseJDBCStoreColumn(XMLExtendedStreamReader reader, ModelNode column) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    BaseJDBCStoreConfigurationResource.COLUMN_NAME.parseAndSetParameter(value, column, (XMLStreamReader)reader);
                    continue block4;
                }
                case TYPE: {
                    BaseJDBCStoreConfigurationResource.COLUMN_TYPE.parseAndSetParameter(value, column, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLoaderElements(XMLExtendedStreamReader reader, ModelNode loader, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    this.parseStoreProperty(reader, loader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private String parseLoaderAttribute(String name, XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode loader) throws XMLStreamException {
        switch (attribute) {
            case NAME: {
                name = value;
                BaseLoaderConfigurationResource.NAME.parseAndSetParameter(value, loader, (XMLStreamReader)reader);
                break;
            }
            case SHARED: {
                BaseLoaderConfigurationResource.SHARED.parseAndSetParameter(value, loader, (XMLStreamReader)reader);
                break;
            }
            case PRELOAD: {
                BaseLoaderConfigurationResource.PRELOAD.parseAndSetParameter(value, loader, (XMLStreamReader)reader);
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
        return name;
    }

    private String parseStoreAttribute(String name, XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode store) throws XMLStreamException {
        switch (attribute) {
            case NAME: {
                name = value;
                BaseStoreConfigurationResource.NAME.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case SHARED: {
                BaseStoreConfigurationResource.SHARED.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case PRELOAD: {
                BaseStoreConfigurationResource.PRELOAD.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case PASSIVATION: {
                BaseStoreConfigurationResource.PASSIVATION.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case FETCH_STATE: {
                BaseStoreConfigurationResource.FETCH_STATE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case PURGE: {
                BaseStoreConfigurationResource.PURGE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case SINGLETON: {
                BaseStoreConfigurationResource.SINGLETON.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case READ_ONLY: {
                BaseStoreConfigurationResource.READ_ONLY.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
        return name;
    }

    private void parseStoreElements(XMLExtendedStreamReader reader, ModelNode store, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, operations);
                    continue block4;
                }
                case PROPERTY: {
                    this.parseStoreProperty(reader, store, operations);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStoreWriteBehind(XMLExtendedStreamReader reader, ModelNode store, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress writeBehindAddress = PathAddress.pathAddress((ModelNode)store.get("address")).append("write-behind", "WRITE_BEHIND");
        ModelNode writeBehind = Util.createAddOperation((PathAddress)writeBehindAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FLUSH_LOCK_TIMEOUT: {
                    StoreWriteBehindResource.FLUSH_LOCK_TIMEOUT.parseAndSetParameter(value, writeBehind, (XMLStreamReader)reader);
                    continue block6;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    StoreWriteBehindResource.MODIFICATION_QUEUE_SIZE.parseAndSetParameter(value, writeBehind, (XMLStreamReader)reader);
                    continue block6;
                }
                case SHUTDOWN_TIMEOUT: {
                    StoreWriteBehindResource.SHUTDOWN_TIMEOUT.parseAndSetParameter(value, writeBehind, (XMLStreamReader)reader);
                    continue block6;
                }
                case THREAD_POOL_SIZE: {
                    StoreWriteBehindResource.THREAD_POOL_SIZE.parseAndSetParameter(value, writeBehind, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(writeBehindAddress, writeBehind);
    }

    private void parseStoreProperty(XMLExtendedStreamReader reader, ModelNode node, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        int attributes = reader.getAttributeCount();
        String propertyName = null;
        block3: for (int i = 0; i < attributes; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    propertyName = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (propertyName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        String propertyValue = reader.getElementText();
        PathAddress propertyAddress = PathAddress.pathAddress((ModelNode)node.get("address")).append("property", propertyName);
        ModelNode property = Util.createAddOperation((PathAddress)propertyAddress);
        StorePropertyResource.VALUE.parseAndSetParameter(propertyValue, property, (XMLStreamReader)reader);
        operations.put(propertyAddress, property);
    }

    private void parseIndexing(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INDEX: {
                    CacheConfigurationResource.INDEXING.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block10;
                }
                case AUTO_CONFIG: {
                    CacheConfigurationResource.INDEXING_AUTO_CONFIG.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    int attributes = reader.getAttributeCount();
                    String property = null;
                    block12: for (int i = 0; i < attributes; ++i) {
                        String value = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                property = value;
                                continue block12;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (property == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
                    }
                    String value = reader.getElementText();
                    CacheConfigurationResource.INDEXING_PROPERTIES.parseAndAddParameterElement(property, value, node, reader);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBackups(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BACKUP: {
                    this.parseBackup(reader, cache, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBackupFor(XMLExtendedStreamReader reader, ModelNode cache) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOTE_CACHE: {
                    CacheConfigurationResource.REMOTE_CACHE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                    continue block4;
                }
                case REMOTE_SITE: {
                    CacheConfigurationResource.REMOTE_SITE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseBackup(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String site = null;
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SITE: {
                    site = value;
                    continue block11;
                }
                case STRATEGY: {
                    BackupSiteConfigurationResource.STRATEGY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
                case BACKUP_FAILURE_POLICY: {
                    BackupSiteConfigurationResource.FAILURE_POLICY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
                case TIMEOUT: {
                    BackupSiteConfigurationResource.REPLICATION_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
                case ENABLED: {
                    BackupSiteConfigurationResource.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (site == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SITE));
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)cache.get("address")).append("backup", site);
        operation.get("address").set(address.toModelNode());
        LinkedHashMap<PathAddress, ModelNode> additionalOperations = new LinkedHashMap<PathAddress, ModelNode>(1);
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TAKE_OFFLINE: {
                    this.parseTakeOffline(reader, operation);
                    continue block12;
                }
                case STATE_TRANSFER: {
                    if (!this.namespace.since(Namespace.INFINISPAN_SERVER_7_0)) break;
                    this.parseXSiteStateTransfer(reader, operation, additionalOperations);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.put(address, operation);
        operations.putAll(additionalOperations);
    }

    private void parseTakeOffline(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TAKE_BACKUP_OFFLINE_AFTER_FAILURES: {
                    BackupSiteConfigurationResource.TAKE_OFFLINE_AFTER_FAILURES.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case TAKE_BACKUP_OFFLINE_MIN_WAIT: {
                    BackupSiteConfigurationResource.TAKE_OFFLINE_MIN_WAIT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseXSiteStateTransfer(XMLExtendedStreamReader reader, ModelNode backup, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((ModelNode)backup.get("address")).append("state-transfer", "STATE_TRANSFER");
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CHUNK_SIZE: {
                    BackupSiteStateTransferConfigurationResource.STATE_TRANSFER_CHUNK_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                case TIMEOUT: {
                    BackupSiteStateTransferConfigurationResource.STATE_TRANSFER_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                case MAX_RETRIES: {
                    BackupSiteStateTransferConfigurationResource.STATE_TRANSFER_MAX_RETRIES.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                case WAIT_TIME: {
                    BackupSiteStateTransferConfigurationResource.STATE_TRANSFER_WAIT_TIME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(address, operation);
    }

    private void parseCompatibility(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress compatibilityAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("compatibility", "COMPATIBILITY");
        ModelNode compatibility = Util.createAddOperation((PathAddress)compatibilityAddress);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    CompatibilityConfigurationResource.ENABLED.parseAndSetParameter(value, compatibility, (XMLStreamReader)reader);
                    continue block4;
                }
                case MARSHALLER: {
                    CompatibilityConfigurationResource.MARSHALLER.parseAndSetParameter(value, compatibility, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(compatibilityAddress, compatibility);
    }

    private void parseCacheSecurity(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress securityAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("security", "SECURITY");
        ModelNode security = Util.createAddOperation((PathAddress)securityAddress);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        LinkedHashMap<PathAddress, ModelNode> additionalConfigurationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHORIZATION: {
                    this.parseCacheAuthorization(reader, security, additionalConfigurationOperations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.put(securityAddress, security);
        operations.putAll(additionalConfigurationOperations);
    }

    private void parseCacheAuthorization(XMLExtendedStreamReader reader, ModelNode security, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress authorizationAddress = PathAddress.pathAddress((ModelNode)security.get("address")).append("authorization", "AUTHORIZATION");
        ModelNode authorization = Util.createAddOperation((PathAddress)authorizationAddress);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    CacheAuthorizationConfigurationResource.ENABLED.parseAndSetParameter(value, authorization, (XMLStreamReader)reader);
                    continue block4;
                }
                case ROLES: {
                    for (String role : reader.getListAttributeValue(i)) {
                        CacheAuthorizationConfigurationResource.ROLES.parseAndAddParameterElement(role, authorization, (XMLStreamReader)reader);
                    }
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(authorizationAddress, authorization);
    }

    private void parsePartitionHandling(XMLExtendedStreamReader reader, ModelNode cache, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress partitionHandlingAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("partition-handling", "PARTITION_HANDLING");
        ModelNode partitionHandling = Util.createAddOperation((PathAddress)partitionHandlingAddress);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    PartitionHandlingConfigurationResource.ENABLED.parseAndSetParameter(value, partitionHandling, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.put(partitionHandlingAddress, partitionHandling);
    }

    private void parseThreadPool(ThreadPoolResource pool, XMLExtendedStreamReader reader, PathAddress parentAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = parentAddress.append(new PathElement[]{pool.getPathElement()});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MIN_THREADS: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getMinThreads());
                    continue block6;
                }
                case MAX_THREADS: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getMaxThreads());
                    continue block6;
                }
                case QUEUE_LENGTH: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getQueueLength());
                    continue block6;
                }
                case KEEPALIVE_TIME: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getKeepAliveTime());
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseScheduledThreadPool(ScheduledThreadPoolResource pool, XMLExtendedStreamReader reader, PathAddress parentAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = parentAddress.append(new PathElement[]{pool.getPathElement()});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_THREADS: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getMaxThreads());
                    continue block4;
                }
                case KEEPALIVE_TIME: {
                    InfinispanSubsystemXMLReader.readAttribute(reader, i, operation, pool.getKeepAliveTime());
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void readAttribute(XMLExtendedStreamReader reader, int index, ModelNode operation, AttributeDefinition attribute) throws XMLStreamException {
        InfinispanSubsystemXMLReader.setAttribute(reader, reader.getAttributeValue(index), operation, attribute);
    }

    private static void setAttribute(XMLExtendedStreamReader reader, String value, ModelNode operation, AttributeDefinition attribute) throws XMLStreamException {
        attribute.getParser().parseAndSetParameter(attribute, value, operation, (XMLStreamReader)reader);
    }
}

