/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.XSiteStateTransferConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigOperationHandlers.CacheConfigAdd;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

/**
 * Cross-Site state transfer resource.
 *
 * @author Pedro Ruivo
 * @since 7.0
 */
public class BackupSiteStateTransferConfigurationResource extends SimpleResourceDefinition {

   private static final PathElement PATH = PathElement.pathElement(ModelKeys.STATE_TRANSFER, ModelKeys.STATE_TRANSFER_NAME);
static final SimpleAttributeDefinition STATE_TRANSFER_CHUNK_SIZE = new SimpleAttributeDefinitionBuilder(ModelKeys.CHUNK_SIZE, ModelType.INT, true)
         .setXmlName(Attribute.CHUNK_SIZE.getLocalName())
         .setAllowExpression(true)
         .setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)
         .setDefaultValue(new ModelNode().set(XSiteStateTransferConfigurationBuilder.DEFAULT_CHUNK_SIZE))
         .build();
   static final SimpleAttributeDefinition STATE_TRANSFER_TIMEOUT = new SimpleAttributeDefinitionBuilder(ModelKeys.TIMEOUT, ModelType.LONG, true)
         .setXmlName(Attribute.TIMEOUT.getLocalName())
         .setAllowExpression(true)
         .setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)
         .setDefaultValue(new ModelNode().set(XSiteStateTransferConfigurationBuilder.DEFAULT_TIMEOUT))
         .build();
   static final SimpleAttributeDefinition STATE_TRANSFER_WAIT_TIME = new SimpleAttributeDefinitionBuilder(ModelKeys.WAIT_TIME, ModelType.LONG, true)
         .setXmlName(Attribute.WAIT_TIME.getLocalName())
         .setAllowExpression(true)
         .setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)
         .setDefaultValue(new ModelNode().set(XSiteStateTransferConfigurationBuilder.DEFAULT_WAIT_TIME))
         .build();
   static final SimpleAttributeDefinition STATE_TRANSFER_MAX_RETRIES = new SimpleAttributeDefinitionBuilder(ModelKeys.MAX_RETRIES, ModelType.INT, true)
         .setXmlName(Attribute.MAX_RETRIES.getLocalName())
         .setAllowExpression(true)
         .setFlags(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)
         .setDefaultValue(new ModelNode().set(XSiteStateTransferConfigurationBuilder.DEFAULT_MAX_RETRIES))
         .build();

   static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{STATE_TRANSFER_CHUNK_SIZE, STATE_TRANSFER_MAX_RETRIES, STATE_TRANSFER_TIMEOUT, STATE_TRANSFER_WAIT_TIME};

   private final boolean runtimeRegistration;

   BackupSiteStateTransferConfigurationResource(boolean runtimeRegistration) {
      super(PATH, new InfinispanResourceDescriptionResolver(ModelKeys.BACKUP, ModelKeys.STATE_TRANSFER), new CacheConfigAdd(ATTRIBUTES), ReloadRequiredRemoveStepHandler.INSTANCE);
      this.runtimeRegistration = runtimeRegistration;
   }

   @Override
   public void registerAttributes(ManagementResourceRegistration registration) {
      final OperationStepHandler writeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
      for (AttributeDefinition attribute : ATTRIBUTES) {
         registration.registerReadWriteAttribute(attribute, null, writeHandler);
      }
   }

   public boolean isRuntimeRegistration() {
      return runtimeRegistration;
   }
}
