/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.server.commons.dmr.ModelNodes;
import org.infinispan.server.commons.naming.BinderServiceBuilder;
import org.infinispan.server.commons.naming.JndiNameFactory;
import org.infinispan.server.commons.service.AliasServiceBuilder;
import org.infinispan.server.infinispan.spi.CacheContainer;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.infinispan.server.infinispan.spi.service.CacheServiceName;
import org.infinispan.server.jgroups.spi.ChannelFactory;
import org.infinispan.server.jgroups.spi.service.ChannelBuilder;
import org.infinispan.server.jgroups.spi.service.ChannelConnectorBuilder;
import org.infinispan.server.jgroups.spi.service.ChannelServiceName;
import org.infinispan.server.jgroups.spi.service.ProtocolStackServiceName;
import org.infinispan.server.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.AuthorizationConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.AuthorizationRoleResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerAuthorizationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.GlobalStateLocationConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.GlobalStateResource;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.TransportConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.TransportResource;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.Channel;

public class CacheContainerAddHandler
extends AbstractAddStepHandler {
    CacheContainerAddHandler() {
        super(CacheContainerResource.CACHE_CONTAINER_ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        CacheContainerAddHandler.installRuntimeServices(context, operation, Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS)));
    }

    static void installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode securityModel;
        String name = context.getCurrentAddressValue();
        ServiceTarget target = context.getServiceTarget();
        String defaultCache = ModelNodes.asString((ModelNode)CacheContainerResource.DEFAULT_CACHE.resolveModelAttribute(context, model));
        String jndiName = ModelNodes.asString((ModelNode)CacheContainerResource.JNDI_NAME.resolveModelAttribute(context, model));
        ModuleIdentifier module = ModelNodes.asModuleIdentifier((ModelNode)CacheContainerResource.CACHE_CONTAINER_MODULE.resolveModelAttribute(context, model));
        CacheContainerConfigurationBuilder configBuilder = new CacheContainerConfigurationBuilder(name).setModule(module).setStatisticsEnabled(CacheContainerResource.STATISTICS.resolveModelAttribute(context, model).asBoolean());
        if (model.hasDefined(TransportResource.TRANSPORT_PATH.getKey())) {
            ModelNode transport = model.get(TransportResource.TRANSPORT_PATH.getKeyValuePair());
            String channel = ModelNodes.asString((ModelNode)TransportResource.CHANNEL.resolveModelAttribute(context, transport), (String)"default");
            configBuilder.setTransport().setLockTimeout(TransportResource.LOCK_TIMEOUT.resolveModelAttribute(context, transport).asLong(), TimeUnit.MILLISECONDS).setStrictPeerToPeer(TransportResource.STRICT_PEER_TO_PEER.resolveModelAttribute(context, transport).asBoolean()).build(target).install();
            if (!name.equals(channel)) {
                new BinderServiceBuilder(JGroupsBindingFactory.createChannelBinding((String)name), ChannelServiceName.CHANNEL.getServiceName(name), Channel.class).build(target).install();
                new ChannelBuilder(name).build(target).install();
                new ChannelConnectorBuilder(name).build(target).install();
                new AliasServiceBuilder(ChannelServiceName.FACTORY.getServiceName(name), ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(channel), ChannelFactory.class).build(target).install();
            }
        }
        if (model.hasDefined(GlobalStateResource.GLOBAL_STATE_PATH.getKey())) {
            String relativeTo;
            String path;
            Object persistentLocation;
            ModelNode globalState = model.get(GlobalStateResource.GLOBAL_STATE_PATH.getKeyValuePair());
            String defaultPersistentLocation = "datagrid-infinispan" + File.separatorChar + name;
            GlobalStateLocationConfigurationBuilder globalStateBuilder = configBuilder.setGlobalState();
            if (globalState.hasDefined("persistent-location")) {
                persistentLocation = globalState.get("persistent-location");
                path = ModelNodes.asString((ModelNode)GlobalStateResource.PATH.resolveModelAttribute(context, (ModelNode)persistentLocation), (String)defaultPersistentLocation);
                relativeTo = ModelNodes.asString((ModelNode)GlobalStateResource.TEMPORARY_RELATIVE_TO.resolveModelAttribute(context, (ModelNode)persistentLocation));
                globalStateBuilder.setPersistencePath(path).setPersistenceRelativeTo(relativeTo);
            } else {
                globalStateBuilder.setPersistencePath(defaultPersistentLocation).setPersistenceRelativeTo("jboss.server.data.dir");
            }
            if (globalState.hasDefined("temporary-location")) {
                persistentLocation = globalState.get("temporary-location");
                path = ModelNodes.asString((ModelNode)GlobalStateResource.PATH.resolveModelAttribute(context, (ModelNode)persistentLocation), (String)defaultPersistentLocation);
                relativeTo = ModelNodes.asString((ModelNode)GlobalStateResource.TEMPORARY_RELATIVE_TO.resolveModelAttribute(context, (ModelNode)persistentLocation));
                globalStateBuilder.setTemporaryPath(path).setTemporaryRelativeTo(relativeTo);
            } else {
                globalStateBuilder.setTemporaryPath(defaultPersistentLocation).setTemporaryRelativeTo("jboss.server.temp.dir");
            }
        }
        AuthorizationConfigurationBuilder authorizationConfig = null;
        if (model.hasDefined("security") && model.get("security").hasDefined("SECURITY") && (securityModel = model.get(new String[]{"security", "SECURITY"})).hasDefined("authorization") && securityModel.get("authorization").hasDefined("AUTHORIZATION")) {
            ModelNode authzModel = securityModel.get(new String[]{"authorization", "AUTHORIZATION"});
            authorizationConfig = configBuilder.setAuthorization();
            if (authzModel.hasDefined("audit-logger")) {
                authorizationConfig.setAuditLogger(ModelNodes.asString((ModelNode)CacheContainerAuthorizationResource.AUDIT_LOGGER.resolveModelAttribute(context, authzModel)));
            }
            authorizationConfig.setPrincipalMapper(ModelNodes.asString((ModelNode)CacheContainerAuthorizationResource.MAPPER.resolveModelAttribute(context, authzModel)));
            for (ModelNode roleNode : authzModel.get("role").asList()) {
                ModelNode role = roleNode.get(0);
                String roleName = AuthorizationRoleResource.NAME.resolveModelAttribute(context, role).asString();
                ArrayList<String> permissions = new ArrayList<String>();
                for (ModelNode permission : AuthorizationRoleResource.PERMISSIONS.resolveModelAttribute(context, role).asList()) {
                    permissions.add(permission.asString());
                }
                authorizationConfig.getRoles().put(roleName, permissions);
            }
        }
        configBuilder.build(target).install();
        CacheContainerBuilder containerBuilder = new CacheContainerBuilder(name, defaultCache);
        if (model.hasDefined(CacheContainerResource.ALIASES.getName())) {
            for (ModelNode alias : operation.get(CacheContainerResource.ALIASES.getName()).asList()) {
                containerBuilder.addAlias(alias.asString());
            }
        }
        containerBuilder.build(target).install();
        ContextNames.BindInfo binding = InfinispanBindingFactory.createCacheContainerBinding(name);
        BinderServiceBuilder bindingBuilder = new BinderServiceBuilder(binding, CacheContainerServiceName.CACHE_CONTAINER.getServiceName(name), CacheContainer.class);
        if (jndiName != null) {
            bindingBuilder.alias(ContextNames.bindInfoFor((String)JndiNameFactory.parse((String)jndiName).getAbsoluteName()));
        }
        bindingBuilder.build(target).install();
        if (defaultCache != null && !defaultCache.equals("default")) {
            for (CacheServiceName nameFactory : CacheServiceName.values()) {
                new AliasServiceBuilder(nameFactory.getServiceName(name), nameFactory.getServiceName(name, defaultCache), Object.class).build(target).install();
            }
            new BinderServiceBuilder(InfinispanBindingFactory.createCacheBinding(name, "default"), CacheServiceName.CACHE.getServiceName(name), Cache.class).build(target).install();
        }
    }

    static void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        context.removeService(InfinispanBindingFactory.createCacheContainerBinding(name).getBinderServiceName());
        for (CacheContainerServiceName cacheContainerServiceName : CacheContainerServiceName.values()) {
            context.removeService(cacheContainerServiceName.getServiceName(name));
        }
        if (model.hasDefined(TransportResource.TRANSPORT_PATH.getKey())) {
            context.removeService(new TransportConfigurationBuilder(name).getServiceName());
            context.removeService(JGroupsBindingFactory.createChannelBinding((String)name).getBinderServiceName());
            for (CacheContainerServiceName cacheContainerServiceName : ChannelServiceName.values()) {
                context.removeService(cacheContainerServiceName.getServiceName(name));
            }
        }
    }
}

