/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.cs.deployment;

import java.lang.reflect.Constructor;
import java.util.List;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.cs.factory.DeployedCacheStoreFactory;
import org.jboss.as.clustering.infinispan.cs.factory.DeployedCacheStoreFactoryService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public abstract class AbstractCacheStoreExtensionProcessor<T>
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext ctx) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = ctx.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null) {
            this.addServices(ctx, servicesAttachment, module);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }

    private void addServices(DeploymentPhaseContext ctx, ServicesAttachment servicesAttachment, Module module) {
        Class<T> serviceClass = this.getServiceClass();
        List implementationNames = servicesAttachment.getServiceImplementations(serviceClass.getName());
        ModuleClassLoader classLoader = module.getClassLoader();
        for (String serviceClassName : implementationNames) {
            try {
                Class<T> clazz = classLoader.loadClass(serviceClassName).asSubclass(serviceClass);
                Constructor<T> ctor = clazz.getConstructor(new Class[0]);
                T instance = ctor.newInstance(new Object[0]);
                this.installService(ctx, serviceClassName, instance);
            }
            catch (Exception e) {
                InfinispanMessages.MESSAGES.unableToInstantiateClass(serviceClassName);
            }
        }
    }

    public final void installService(DeploymentPhaseContext ctx, String implementationClassName, T instance) {
        AbstractExtensionManagerService<T> service = this.createService(implementationClassName, instance);
        ServiceName extensionServiceName = ServiceName.JBOSS.append(new String[]{service.getServiceTypeName(), implementationClassName.replaceAll("\\.", "_")});
        InfinispanLogger.ROOT_LOGGER.installDeployedCacheStore(implementationClassName);
        ServiceBuilder serviceBuilder = ctx.getServiceTarget().addService(extensionServiceName, service);
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        serviceBuilder.addDependency(DeployedCacheStoreFactoryService.SERVICE_NAME, DeployedCacheStoreFactory.class, service.getDeployedCacheStoreFactory());
        serviceBuilder.install();
    }

    public abstract Class<T> getServiceClass();

    public abstract AbstractExtensionManagerService<T> createService(String var1, T var2);

    protected static abstract class AbstractExtensionManagerService<T>
    implements Service<T> {
        protected final T extension;
        protected final String className;
        protected InjectedValue<DeployedCacheStoreFactory> deployedCacheStoreFactory = new InjectedValue();

        protected AbstractExtensionManagerService(String className, T extension) {
            this.extension = extension;
            this.className = className;
        }

        public void start(StartContext context) {
            InfinispanLogger.ROOT_LOGGER.deployedStoreStarted(this.className);
            ((DeployedCacheStoreFactory)this.deployedCacheStoreFactory.getValue()).addInstance(this.extension);
        }

        public void stop(StopContext context) {
            InfinispanLogger.ROOT_LOGGER.deployedStoreStopped(this.className);
            ((DeployedCacheStoreFactory)this.deployedCacheStoreFactory.getValue()).removeInstance(this.extension);
        }

        public InjectedValue<DeployedCacheStoreFactory> getDeployedCacheStoreFactory() {
            return this.deployedCacheStoreFactory;
        }

        public abstract String getServiceTypeName();
    }
}

