/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.impl.ActivationInterceptor;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.impl.InvalidationInterceptor;
import org.infinispan.interceptors.impl.TxInterceptor;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.server.infinispan.SecurityActions;
import org.infinispan.server.infinispan.spi.service.CacheServiceName;
import org.infinispan.util.concurrent.locks.impl.DefaultLockManager;
import org.infinispan.xsite.XSiteAdminOperations;
import org.infinispan.xsite.status.SiteStatus;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class CacheMetricsHandler
extends AbstractRuntimeOnlyHandler {
    public static final CacheMetricsHandler INSTANCE = new CacheMetricsHandler();

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 2).getValue();
        String cacheName = address.getLastElement().getValue();
        String attrName = operation.require("name").asString();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheServiceName.CACHE.getServiceName(cacheContainerName, cacheName));
        Cache cache = (Cache)controller.getValue();
        CacheMetrics metric = CacheMetrics.getStat(attrName);
        ModelNode result = new ModelNode();
        if (metric == null) {
            context.getFailureDescription().set(String.format("Unknown metric %s", attrName));
        } else if (cache == null) {
            context.getFailureDescription().set(String.format("Unavailable cache %s", attrName));
        } else {
            AdvancedCache aCache = cache.getAdvancedCache();
            DefaultLockManager lockManager = (DefaultLockManager)SecurityActions.getLockManager(aCache);
            RpcManagerImpl rpcManager = (RpcManagerImpl)SecurityActions.getRpcManager(aCache);
            List<AsyncInterceptor> interceptors = SecurityActions.getInterceptorChain(aCache);
            ComponentRegistry registry = SecurityActions.getComponentRegistry(aCache);
            ComponentStatus status = SecurityActions.getCacheStatus(aCache);
            switch (metric) {
                case CACHE_STATUS: {
                    result.set(status.toString());
                    break;
                }
                case CONCURRENCY_LEVEL: {
                    result.set(lockManager.getConcurrencyLevel());
                    break;
                }
                case NUMBER_OF_LOCKS_AVAILABLE: {
                    result.set(lockManager.getNumberOfLocksAvailable());
                    break;
                }
                case NUMBER_OF_LOCKS_HELD: {
                    result.set(lockManager.getNumberOfLocksHeld());
                    break;
                }
                case AVERAGE_READ_TIME: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getAverageReadTime() : 0L);
                    break;
                }
                case AVERAGE_WRITE_TIME: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getAverageWriteTime() : 0L);
                    break;
                }
                case AVERAGE_REMOVE_TIME: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getAverageRemoveTime() : 0L);
                    break;
                }
                case TIME_SINCE_START: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getTimeSinceStart() : 0L);
                    break;
                }
                case EVICTIONS: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getEvictions() : 0L);
                    break;
                }
                case HIT_RATIO: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getHitRatio() : 0.0);
                    break;
                }
                case HITS: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getHits() : 0L);
                    break;
                }
                case MISSES: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getMisses() : 0L);
                    break;
                }
                case NUMBER_OF_ENTRIES: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getNumberOfEntries() : 0);
                    break;
                }
                case READ_WRITE_RATIO: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getReadWriteRatio() : 0.0);
                    break;
                }
                case REMOVE_HITS: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getRemoveHits() : 0L);
                    break;
                }
                case REMOVE_MISSES: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getRemoveMisses() : 0L);
                    break;
                }
                case STORES: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getStores() : 0L);
                    break;
                }
                case TIME_SINCE_RESET: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getTimeSinceReset() : 0L);
                    break;
                }
                case AVERAGE_REPLICATION_TIME: {
                    result.set(rpcManager.getAverageReplicationTime());
                    break;
                }
                case REPLICATION_COUNT: {
                    result.set(rpcManager.getReplicationCount());
                    break;
                }
                case REPLICATION_FAILURES: {
                    result.set(rpcManager.getReplicationFailures());
                    break;
                }
                case SUCCESS_RATIO: {
                    result.set(rpcManager.getSuccessRatioFloatingPoint());
                    break;
                }
                case COMMITS: {
                    TxInterceptor txInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, TxInterceptor.class);
                    result.set(txInterceptor != null ? txInterceptor.getCommits() : 0L);
                    break;
                }
                case PREPARES: {
                    TxInterceptor txInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, TxInterceptor.class);
                    result.set(txInterceptor != null ? txInterceptor.getPrepares() : 0L);
                    break;
                }
                case ROLLBACKS: {
                    TxInterceptor txInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, TxInterceptor.class);
                    result.set(txInterceptor != null ? txInterceptor.getRollbacks() : 0L);
                    break;
                }
                case INVALIDATIONS: {
                    InvalidationInterceptor invInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, InvalidationInterceptor.class);
                    result.set(invInterceptor != null ? invInterceptor.getInvalidations() : 0L);
                    break;
                }
                case PASSIVATIONS: {
                    PassivationManager manager = (PassivationManager)registry.getComponent(PassivationManager.class);
                    result.set(manager != null ? manager.getPassivations() : 0L);
                    break;
                }
                case ACTIVATIONS: {
                    ActivationManager manager = (ActivationManager)registry.getComponent(ActivationManager.class);
                    result.set(manager != null ? manager.getActivationCount() : 0L);
                    break;
                }
                case CACHE_LOADER_LOADS: {
                    ActivationInterceptor interceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, ActivationInterceptor.class);
                    result.set(interceptor != null ? interceptor.getCacheLoaderLoads() : 0L);
                    break;
                }
                case CACHE_LOADER_MISSES: {
                    ActivationInterceptor interceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, ActivationInterceptor.class);
                    result.set(interceptor != null ? interceptor.getCacheLoaderMisses() : 0L);
                    break;
                }
                case CACHE_LOADER_STORES: {
                    CacheWriterInterceptor interceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(interceptors, CacheWriterInterceptor.class);
                    result.set(interceptor != null ? interceptor.getWritesToTheStores() : 0L);
                    break;
                }
                case CACHE_NAME: {
                    result.set(cache.getName());
                    break;
                }
                case VERSION: {
                    result.set(SecurityActions.getCacheVersion(aCache));
                    break;
                }
                case OFFLINE_SITES: 
                case ONLINE_SITES: 
                case MIXED_SITES: {
                    Collection<String> sites = CacheMetricsHandler.filterSitesByStatus((XSiteAdminOperations)registry.getComponent(XSiteAdminOperations.class), metric);
                    if (sites.isEmpty()) {
                        result.setEmptyList();
                        break;
                    }
                    result.set(CacheMetricsHandler.toModelNodeCollection(sites));
                    break;
                }
                default: {
                    context.getFailureDescription().set(String.format("Unknown metric %s", new Object[]{metric}));
                }
            }
            context.getResult().set(result);
        }
        context.stepCompleted();
    }

    public void registerCommonMetrics(ManagementResourceRegistration container) {
        for (CacheMetrics metric : CacheMetrics.values()) {
            if (metric.clustered) continue;
            container.registerMetric(metric.definition, (OperationStepHandler)this);
        }
    }

    public void registerClusteredMetrics(ManagementResourceRegistration container) {
        for (CacheMetrics metric : CacheMetrics.values()) {
            if (!metric.clustered) continue;
            container.registerMetric(metric.definition, (OperationStepHandler)this);
        }
    }

    public static <T extends AsyncInterceptor> T getFirstInterceptorWhichExtends(List<AsyncInterceptor> interceptors, Class<T> interceptorClass) {
        for (AsyncInterceptor interceptor : interceptors) {
            boolean isSubclass = interceptorClass.isAssignableFrom(interceptor.getClass());
            if (!isSubclass) continue;
            return (T)interceptor;
        }
        return null;
    }

    private static Collection<String> filterSitesByStatus(XSiteAdminOperations operations, CacheMetrics metric) {
        if (operations == null) {
            return Collections.emptyList();
        }
        Map statusMap = operations.clusterStatus();
        if (statusMap.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<String> filterSites = new LinkedList<String>();
        block5: for (Map.Entry entry : statusMap.entrySet()) {
            switch (metric) {
                case ONLINE_SITES: {
                    if (!((SiteStatus)entry.getValue()).isOnline()) continue block5;
                    filterSites.add((String)entry.getKey());
                    continue block5;
                }
                case OFFLINE_SITES: {
                    if (!((SiteStatus)entry.getValue()).isOffline()) continue block5;
                    filterSites.add((String)entry.getKey());
                    continue block5;
                }
                case MIXED_SITES: {
                    if (((SiteStatus)entry.getValue()).isOnline() || ((SiteStatus)entry.getValue()).isOffline()) continue block5;
                    filterSites.add((String)entry.getKey());
                    continue block5;
                }
            }
            return Collections.emptyList();
        }
        return filterSites;
    }

    private static Collection<ModelNode> toModelNodeCollection(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModelNode> modelNodeCollection = new ArrayList<ModelNode>(collection.size());
        collection.forEach(e -> modelNodeCollection.add(new ModelNode().set(e)));
        return modelNodeCollection;
    }

    public static enum CacheMetrics {
        CACHE_STATUS("cache-status", ModelType.STRING, true),
        VERSION("version", ModelType.STRING, true),
        CACHE_NAME("cache-name", ModelType.STRING, true),
        NUMBER_OF_LOCKS_AVAILABLE("number-of-locks-available", ModelType.INT, true),
        NUMBER_OF_LOCKS_HELD("number-of-locks-held", ModelType.INT, true),
        CONCURRENCY_LEVEL("concurrency-level", ModelType.INT, true),
        AVERAGE_READ_TIME("average-read-time", ModelType.LONG, true),
        AVERAGE_WRITE_TIME("average-write-time", ModelType.LONG, true),
        AVERAGE_REMOVE_TIME("average-remove-time", ModelType.LONG, true),
        TIME_SINCE_START("time-since-start", ModelType.LONG, true),
        EVICTIONS("evictions", ModelType.LONG, true),
        HIT_RATIO("hit-ratio", ModelType.DOUBLE, true),
        HITS("hits", ModelType.LONG, true),
        MISSES("misses", ModelType.LONG, true),
        NUMBER_OF_ENTRIES("number-of-entries", ModelType.INT, true),
        READ_WRITE_RATIO("read-write-ratio", ModelType.DOUBLE, true),
        REMOVE_HITS("remove-hits", ModelType.LONG, true),
        REMOVE_MISSES("remove-misses", ModelType.LONG, true),
        STORES("stores", ModelType.LONG, true),
        TIME_SINCE_RESET("time-since-reset", ModelType.LONG, true),
        COMMITS("commits", ModelType.LONG, true),
        PREPARES("prepares", ModelType.LONG, true),
        ROLLBACKS("rollbacks", ModelType.LONG, true),
        INVALIDATIONS("invalidations", ModelType.LONG, true),
        PASSIVATIONS("passivations", ModelType.STRING, true),
        ACTIVATIONS("activations", ModelType.STRING, true),
        CACHE_LOADER_LOADS("cache-loader-loads", ModelType.LONG, true),
        CACHE_LOADER_MISSES("cache-loader-misses", ModelType.LONG, true),
        CACHE_LOADER_STORES("cache-loader-stores", ModelType.LONG, true),
        AVERAGE_REPLICATION_TIME("average-replication-time", ModelType.LONG, true, true),
        REPLICATION_COUNT("replication-count", ModelType.LONG, true, true),
        REPLICATION_FAILURES("replication-failures", ModelType.LONG, true, true),
        SUCCESS_RATIO("success-ratio", ModelType.DOUBLE, true, true),
        ONLINE_SITES("sites-online", ModelType.LIST, ModelType.STRING, false),
        OFFLINE_SITES("sites-offline", ModelType.LIST, ModelType.STRING, false),
        MIXED_SITES("sites-mixed", ModelType.LIST, ModelType.STRING, false);

        private static final Map<String, CacheMetrics> MAP;
        final AttributeDefinition definition;
        final boolean clustered;

        private CacheMetrics(AttributeDefinition definition, boolean clustered) {
            this.definition = definition;
            this.clustered = clustered;
        }

        private CacheMetrics(String attributeName, ModelType type, boolean allowNull) {
            this((AttributeDefinition)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(attributeName, type, allowNull).setStorageRuntime()).build(), false);
        }

        private CacheMetrics(String attributeName, ModelType type, boolean allowNull, boolean clustered) {
            this((AttributeDefinition)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(attributeName, type, allowNull).setStorageRuntime()).build(), clustered);
        }

        private CacheMetrics(String attributeName, ModelType outerType, ModelType innerType, boolean allowNull) {
            if (outerType != ModelType.LIST) {
                throw new IllegalArgumentException();
            }
            if (innerType != ModelType.STRING) {
                throw new IllegalArgumentException();
            }
            this.definition = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(attributeName).setAllowNull(allowNull)).build();
            this.clustered = false;
        }

        public final String toString() {
            return this.definition.getName();
        }

        public static CacheMetrics getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, CacheMetrics>();
            for (CacheMetrics metric : CacheMetrics.values()) {
                MAP.put(metric.toString(), metric);
            }
        }
    }
}

