/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class UnregisterProtoSchemasOperationHandler
implements OperationStepHandler {
    public static final UnregisterProtoSchemasOperationHandler INSTANCE = new UnregisterProtoSchemasOperationHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        EmbeddedCacheManager cacheManager;
        ProtobufMetadataManager protoManager;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 1).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(cacheContainerName));
        if (controller != null && (protoManager = (ProtobufMetadataManager)(cacheManager = (EmbeddedCacheManager)controller.getValue()).getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class)) != null) {
            try {
                ModelNode names = operation.require(CacheContainerResource.PROTO_NAMES.getName());
                this.validateParameters(names);
                for (ModelNode modelNode : names.asList()) {
                    protoManager.unregisterProtofile(modelNode.asString());
                }
            }
            catch (Exception e) {
                throw new OperationFailedException(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage()));
            }
        }
        context.stepCompleted();
    }

    private void validateParameters(ModelNode names) {
        if (names.getType() != ModelType.LIST) {
            throw InfinispanMessages.MESSAGES.invalidParameterType(CacheContainerResource.PROTO_NAMES.getName(), ModelType.LIST.toString());
        }
    }
}

