/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.server.infinispan.spi.service.CacheServiceName;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.PathAddressUtils;
import org.jboss.as.clustering.infinispan.subsystem.RuntimeCacheConfigurationApplier;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class RuntimeCacheConfigurationWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    private final RuntimeCacheConfigurationApplier applier;
    private final SimpleAttributeDefinition attributeDef;

    public RuntimeCacheConfigurationWriteAttributeHandler(SimpleAttributeDefinition attributeDef, RuntimeCacheConfigurationApplier applier) {
        super(new AttributeDefinition[]{attributeDef});
        this.attributeDef = attributeDef;
        this.applier = applier;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.applyModelToRuntime(context, operation, attributeName, model);
        return false;
    }

    private void applyModelToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        ServiceName serviceName = this.getParentServiceName(address);
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController sc = registry.getService(serviceName);
        if (sc != null) {
            CacheConfigurationService ccs = (CacheConfigurationService)sc.getService();
            Configuration configuration = ccs.getValue();
            ModelNode value = this.attributeDef.resolveModelAttribute(context, model);
            this.applier.applyConfiguration(configuration, value);
        }
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.applyModelToRuntime(context, operation, attributeName, restored);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        int containerIndex = PathAddressUtils.indexOf(parentAddress, CacheContainerResource.CONTAINER_PATH);
        String containerName = parentAddress.getElement(containerIndex).getValue();
        String configurationName = parentAddress.getElement(containerIndex + 2).getValue();
        return CacheServiceName.CONFIGURATION.getServiceName(containerName, configurationName);
    }
}

