/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.infinispan;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.SearchManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheComponentRegistryAction;
import org.infinispan.security.actions.GetCacheInterceptorChainAction;
import org.infinispan.security.actions.GetCacheLockManagerAction;
import org.infinispan.security.actions.GetCacheManagerAddress;
import org.infinispan.security.actions.GetCacheManagerClusterAvailabilityAction;
import org.infinispan.security.actions.GetCacheManagerClusterNameAction;
import org.infinispan.security.actions.GetCacheManagerCoordinatorAddress;
import org.infinispan.security.actions.GetCacheManagerIsCoordinatorAction;
import org.infinispan.security.actions.GetCacheManagerStatusAction;
import org.infinispan.security.actions.GetCacheRpcManagerAction;
import org.infinispan.security.actions.GetCacheStatusAction;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;
import org.infinispan.server.infinispan.actions.AbstractAdvancedCacheAction;
import org.infinispan.server.infinispan.actions.ClearCacheAction;
import org.infinispan.server.infinispan.actions.FlushCacheAction;
import org.infinispan.server.infinispan.actions.GetCacheVersionAction;
import org.infinispan.server.infinispan.actions.GetCreatedCacheCountAction;
import org.infinispan.server.infinispan.actions.GetDefinedCacheCountAction;
import org.infinispan.server.infinispan.actions.GetDefinedCacheNamesAction;
import org.infinispan.server.infinispan.actions.GetMembersAction;
import org.infinispan.server.infinispan.actions.GetRunningCacheCountAction;
import org.infinispan.server.infinispan.actions.GetSearchManagerAction;
import org.infinispan.server.infinispan.actions.GetSitesViewAction;
import org.infinispan.server.infinispan.actions.ResetComponentJmxStatisticsAction;
import org.infinispan.server.infinispan.actions.ResetInterceptorJmxStatisticsAction;
import org.infinispan.server.infinispan.actions.StartCacheAction;
import org.infinispan.server.infinispan.actions.StopCacheAction;
import org.infinispan.util.concurrent.locks.LockManager;
import org.jboss.as.clustering.infinispan.DefaultCacheContainer;

public final class SecurityActions {
    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    private static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    public static void registerAndStartContainer(EmbeddedCacheManager container, Object listener) {
        PrivilegedAction<Void> action = () -> {
            container.addListener(listener);
            container.start();
            return null;
        };
        SecurityActions.doPrivileged(action);
    }

    public static boolean stopAndUnregisterContainer(EmbeddedCacheManager container, Object listener) {
        PrivilegedAction<Boolean> action = () -> {
            if (container.getStatus().allowInvocations()) {
                container.removeListener(listener);
                container.stop();
                return true;
            }
            return false;
        };
        return SecurityActions.doPrivileged(action);
    }

    public static void defineContainerConfiguration(EmbeddedCacheManager container, String name, Configuration config) {
        PrivilegedAction<Void> action = () -> {
            container.defineConfiguration(name, config);
            return null;
        };
        SecurityActions.doPrivileged(action);
    }

    public static void undefineContainerConfiguration(EmbeddedCacheManager container, String name) {
        PrivilegedAction<Void> action = () -> {
            container.undefineConfiguration(name);
            return null;
        };
        SecurityActions.doPrivileged(action);
    }

    public static <K, V> Cache<K, V> startCache(EmbeddedCacheManager container, String name, String configurationName) {
        PrivilegedAction<Cache> action = () -> {
            Cache cache = container.getCache(name, configurationName);
            cache.start();
            return cache;
        };
        return SecurityActions.doPrivileged(action);
    }

    public static void stopCache(Cache<?, ?> cache) {
        PrivilegedAction<Void> action = () -> {
            cache.stop();
            return null;
        };
        SecurityActions.doPrivileged(action);
    }

    public static void shutdownCache(Cache<?, ?> cache) {
        PrivilegedAction<Void> action = () -> {
            cache.shutdown();
            return null;
        };
        SecurityActions.doPrivileged(action);
    }

    public static LockManager getLockManager(AdvancedCache<?, ?> cache) {
        GetCacheLockManagerAction action = new GetCacheLockManagerAction(cache);
        return (LockManager)SecurityActions.doPrivileged(action);
    }

    public static List<AsyncInterceptor> getInterceptorChain(AdvancedCache<?, ?> cache) {
        GetCacheInterceptorChainAction action = new GetCacheInterceptorChainAction(cache);
        return (List)SecurityActions.doPrivileged(action);
    }

    public static RpcManager getRpcManager(AdvancedCache<?, ?> cache) {
        GetCacheRpcManagerAction action = new GetCacheRpcManagerAction(cache);
        return (RpcManager)SecurityActions.doPrivileged(action);
    }

    public static ComponentRegistry getComponentRegistry(AdvancedCache<?, ?> cache) {
        GetCacheComponentRegistryAction action = new GetCacheComponentRegistryAction(cache);
        return (ComponentRegistry)SecurityActions.doPrivileged(action);
    }

    public static ComponentStatus getCacheStatus(AdvancedCache<?, ?> cache) {
        GetCacheStatusAction action = new GetCacheStatusAction(cache);
        return (ComponentStatus)SecurityActions.doPrivileged(action);
    }

    public static String getCacheVersion(AdvancedCache<?, ?> cache) {
        GetCacheVersionAction action = new GetCacheVersionAction(cache);
        return SecurityActions.doPrivileged(action);
    }

    public static ComponentStatus getCacheManagerStatus(EmbeddedCacheManager cacheManager) {
        GetCacheManagerStatusAction action = new GetCacheManagerStatusAction(cacheManager);
        return (ComponentStatus)SecurityActions.doPrivileged(action);
    }

    public static Address getCacheManagerLocalAddress(DefaultCacheContainer cacheManager) {
        GetCacheManagerAddress action = new GetCacheManagerAddress((EmbeddedCacheManager)cacheManager);
        return (Address)SecurityActions.doPrivileged(action);
    }

    public static Address getCacheManagerCoordinatorAddress(DefaultCacheContainer cacheManager) {
        GetCacheManagerCoordinatorAddress action = new GetCacheManagerCoordinatorAddress((EmbeddedCacheManager)cacheManager);
        return (Address)SecurityActions.doPrivileged(action);
    }

    public static boolean getCacheManagerIsCoordinator(DefaultCacheContainer cacheManager) {
        GetCacheManagerIsCoordinatorAction action = new GetCacheManagerIsCoordinatorAction((EmbeddedCacheManager)cacheManager);
        return (Boolean)SecurityActions.doPrivileged(action);
    }

    public static String getCacheManagerClusterName(DefaultCacheContainer cacheManager) {
        GetCacheManagerClusterNameAction action = new GetCacheManagerClusterNameAction((EmbeddedCacheManager)cacheManager);
        return (String)SecurityActions.doPrivileged(action);
    }

    public static String getCacheManagerClusterAvailability(DefaultCacheContainer cacheManager) {
        GetCacheManagerClusterAvailabilityAction action = new GetCacheManagerClusterAvailabilityAction((EmbeddedCacheManager)cacheManager);
        return (String)SecurityActions.doPrivileged(action);
    }

    public static String getDefinedCacheNames(DefaultCacheContainer cacheManager) {
        GetDefinedCacheNamesAction action = new GetDefinedCacheNamesAction(cacheManager);
        return SecurityActions.doPrivileged(action);
    }

    public static String getCacheCreatedCount(DefaultCacheContainer cacheManager) {
        GetCreatedCacheCountAction action = new GetCreatedCacheCountAction(cacheManager);
        return SecurityActions.doPrivileged(action);
    }

    public static String getDefinedCacheCount(DefaultCacheContainer cacheManager) {
        GetDefinedCacheCountAction action = new GetDefinedCacheCountAction(cacheManager);
        return SecurityActions.doPrivileged(action);
    }

    public static String getRunningCacheCount(DefaultCacheContainer cacheManager) {
        GetRunningCacheCountAction action = new GetRunningCacheCountAction(cacheManager);
        return SecurityActions.doPrivileged(action);
    }

    public static List<Address> getMembers(DefaultCacheContainer cacheManager) {
        GetMembersAction action = new GetMembersAction(cacheManager);
        return SecurityActions.doPrivileged(action);
    }

    public static Void clearCache(AdvancedCache<?, ?> cache) {
        ClearCacheAction action = new ClearCacheAction(cache);
        SecurityActions.doPrivileged(action);
        return null;
    }

    public static Void flushCache(AdvancedCache<?, ?> cache) {
        FlushCacheAction action = new FlushCacheAction(cache);
        SecurityActions.doPrivileged(action);
        return null;
    }

    public static Void stopCache(AdvancedCache<?, ?> cache) {
        StopCacheAction action = new StopCacheAction(cache);
        SecurityActions.doPrivileged(action);
        return null;
    }

    public static Void startCache(AdvancedCache<?, ?> cache) {
        StartCacheAction action = new StartCacheAction(cache);
        SecurityActions.doPrivileged(action);
        return null;
    }

    public static <T extends JmxStatisticsExposer> Void resetStatistics(AdvancedCache<?, ?> cache, Class<T> jmxClass) {
        AbstractAdvancedCacheAction action = jmxClass.isAssignableFrom(CommandInterceptor.class) ? new ResetInterceptorJmxStatisticsAction<T>(cache, jmxClass) : new ResetComponentJmxStatisticsAction<T>(cache, jmxClass);
        SecurityActions.doPrivileged(action);
        return null;
    }

    public static Map<String, String> executeInterpreter(Interpreter interpreter, String sessionId, String command) throws Exception {
        PrivilegedExceptionAction<Map> action = () -> interpreter.execute(sessionId, command);
        return SecurityActions.doPrivileged(action);
    }

    public static SearchManager getSearchManager(AdvancedCache<?, ?> cache) {
        GetSearchManagerAction action = new GetSearchManagerAction(cache);
        return SecurityActions.doPrivileged(action);
    }

    public static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        GetGlobalComponentRegistryAction action = new GetGlobalComponentRegistryAction(cacheManager);
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(action);
    }

    public static Set<String> getSitesView(DefaultCacheContainer cacheManager) {
        GetSitesViewAction action = new GetSitesViewAction(cacheManager);
        return SecurityActions.doPrivileged(action);
    }

    public static Optional<CounterManager> findCounterManager(EmbeddedCacheManager cacheManager) {
        return Optional.ofNullable(SecurityActions.doPrivileged(() -> EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)cacheManager)));
    }
}

