/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.infinispan.health.CacheHealth;
import org.infinispan.health.Health;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.jboss.as.clustering.infinispan.DefaultCacheContainer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class HealthMetricsHandler
extends AbstractRuntimeOnlyHandler {
    public static final HealthMetricsHandler INSTANCE = new HealthMetricsHandler();
    private static final int CACHE_CONTAINER_INDEX = 1;
    private static final int NUMBER_OF_LINES = 10;
    private PathManager pathManager;

    private static Collection<ModelNode> toModelNodeCollection(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModelNode> modelNodeCollection = new ArrayList<ModelNode>(collection.size());
        collection.forEach(e -> modelNodeCollection.add(new ModelNode().set(e)));
        return modelNodeCollection;
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) {
        ModelNode result = new ModelNode();
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(1).getValue();
        String metricName = operation.require("name").asString();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(cacheContainerName));
        if (controller != null) {
            DefaultCacheContainer cacheManager = (DefaultCacheContainer)controller.getValue();
            HealthMetrics metric = HealthMetrics.getMetric(metricName);
            if (metric == null) {
                context.getFailureDescription().set(String.format("Unknown metric %s", metricName));
            } else if (cacheManager == null) {
                context.getFailureDescription().set(String.format("Unavailable cache container %s", metricName));
            } else {
                Health health = cacheManager.getHealth();
                switch (metric) {
                    case CACHE_HEALTH: {
                        List cacheHealths = health.getCacheHealth();
                        LinkedList<String> perCacheHealth = new LinkedList<String>();
                        for (CacheHealth cacheHealth : cacheHealths) {
                            perCacheHealth.add(cacheHealth.getCacheName());
                            perCacheHealth.add(cacheHealth.getStatus().toString());
                        }
                        result.set(HealthMetricsHandler.toModelNodeCollection(perCacheHealth));
                        break;
                    }
                    case FREE_MEMORY_KB: {
                        result.set(health.getHostInfo().getFreeMemoryInKb());
                        break;
                    }
                    case TOTAL_MEMORY_KB: {
                        result.set(health.getHostInfo().getTotalMemoryKb());
                        break;
                    }
                    case NUMBER_OF_NODES: {
                        result.set(health.getClusterHealth().getNumberOfNodes());
                        break;
                    }
                    case CLUSTER_NAME: {
                        result.set(health.getClusterHealth().getClusterName());
                        break;
                    }
                    case NUMBER_OF_CPUS: {
                        result.set(health.getHostInfo().getNumberOfCpus());
                        break;
                    }
                    case CLUSTER_HEALTH: {
                        result.set(health.getClusterHealth().getHealthStatus().toString());
                        break;
                    }
                    case LOG_TAIL: {
                        File path = new File(this.pathManager.resolveRelativePathEntry("server.log", "jboss.server.log.dir"));
                        try (ReversedLinesFileReader reader = new ReversedLinesFileReader(path, StandardCharsets.UTF_8);){
                            LinkedList<String> results = new LinkedList<String>();
                            for (int i = 0; i < 10; ++i) {
                                results.add(0, reader.readLine());
                            }
                            result.set(HealthMetricsHandler.toModelNodeCollection(results));
                        }
                        catch (FileNotFoundException e) {
                            result.set("File [" + path.getAbsolutePath() + "] does not exist");
                        }
                        catch (IOException e) {
                            result.set("Unable to read file [" + path.getAbsolutePath() + "]");
                        }
                        break;
                    }
                    default: {
                        context.getFailureDescription().set(String.format("Unknown metric %s", new Object[]{metric}));
                    }
                }
            }
        }
        context.getResult().set(result);
    }

    public void registerPathManager(PathManager pathManager) {
        this.pathManager = pathManager;
    }

    public void registerMetrics(ManagementResourceRegistration container) {
        for (HealthMetrics metric : HealthMetrics.values()) {
            container.registerMetric(metric.definition, (OperationStepHandler)this);
        }
    }

    public static enum HealthMetrics {
        NUMBER_OF_CPUS("number-of-cpus", ModelType.INT),
        TOTAL_MEMORY_KB("total-memory", ModelType.LONG),
        FREE_MEMORY_KB("free-memory", ModelType.LONG),
        CLUSTER_HEALTH("cluster-health", ModelType.STRING),
        CLUSTER_NAME("cluster-name", ModelType.STRING),
        NUMBER_OF_NODES("number-of-nodes", ModelType.INT),
        CACHE_HEALTH("cache-health", ModelType.LIST),
        LOG_TAIL("log-tail", ModelType.LIST);

        private static final Map<String, HealthMetrics> MAP;
        final AttributeDefinition definition;

        private HealthMetrics(String attributeName, ModelType type) {
            this.definition = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(attributeName).setRequired(false)).setStorageRuntime()).build();
        }

        public static HealthMetrics getMetric(String stringForm) {
            return MAP.get(stringForm);
        }

        public final String toString() {
            return this.definition.getName();
        }

        static {
            MAP = new HashMap<String, HealthMetrics>();
            for (HealthMetrics metric : HealthMetrics.values()) {
                MAP.put(metric.toString(), metric);
            }
        }
    }
}

