/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.cs.deployment;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.cs.factory.DeployedCacheStoreFactory;
import org.jboss.as.clustering.infinispan.cs.factory.DeployedCacheStoreFactoryService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public abstract class AbstractCacheStoreExtensionProcessor<T>
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext ctx) {
        DeploymentUnit deploymentUnit = ctx.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null) {
            this.addServices(ctx, servicesAttachment, module);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }

    private void addServices(DeploymentPhaseContext ctx, ServicesAttachment servicesAttachment, Module module) {
        Class<T> serviceClass = this.getServiceClass();
        List implementationNames = servicesAttachment.getServiceImplementations(serviceClass.getName());
        ModuleClassLoader classLoader = module.getClassLoader();
        for (String serviceClassName : implementationNames) {
            try {
                Class<T> clazz = classLoader.loadClass(serviceClassName).asSubclass(serviceClass);
                Constructor ctor = clazz.getConstructor(new Class[0]);
                this.installService(ctx, serviceClassName, () -> {
                    try {
                        return ctor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw InfinispanMessages.MESSAGES.unableToInstantiateClass(serviceClassName);
                    }
                });
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw InfinispanMessages.MESSAGES.unableToInstantiateClass(serviceClassName);
            }
        }
    }

    private void installService(DeploymentPhaseContext ctx, String implementationClassName, Supplier<T> instanceFactory) {
        AbstractExtensionManagerService<T> service = this.createService(implementationClassName, instanceFactory);
        InfinispanLogger.ROOT_LOGGER.installDeployedCacheStore(implementationClassName);
        ServiceBuilder serviceBuilder = ctx.getServiceTarget().addService(service.getName()).setInitialMode(ServiceController.Mode.ACTIVE);
        service.deployedCacheStoreFactory = serviceBuilder.requires(DeployedCacheStoreFactoryService.SERVICE_NAME);
        serviceBuilder.setInstance(service);
        serviceBuilder.install();
    }

    public abstract Class<T> getServiceClass();

    public abstract AbstractExtensionManagerService<T> createService(String var1, Supplier<T> var2);

    static abstract class AbstractExtensionManagerService<T>
    implements Service {
        final Supplier<T> instanceFactory;
        final String className;
        final String serviceName;
        Supplier<DeployedCacheStoreFactory> deployedCacheStoreFactory;

        AbstractExtensionManagerService(String serviceName, String className, Supplier<T> instanceFactory) {
            this.serviceName = serviceName;
            this.className = className;
            this.instanceFactory = instanceFactory;
        }

        public void start(StartContext context) {
            InfinispanLogger.ROOT_LOGGER.deployedStoreStarted(this.className);
            this.deployedCacheStoreFactory.get().addInstanceFactory(this.className, this.instanceFactory);
        }

        public void stop(StopContext context) {
            InfinispanLogger.ROOT_LOGGER.deployedStoreStopped(this.className);
            this.deployedCacheStoreFactory.get().removeInstance(this.className);
        }

        public ServiceName getName() {
            return ServiceName.JBOSS.append(new String[]{this.serviceName, this.className.replace(".", "_")});
        }
    }
}

