/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Arrays;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.BaseJDBCStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseLoaderConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.ClusterLoaderConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.LoaderConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.LoaderPropertyResource;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.RestStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.RocksDBStoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.StoreConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResource;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResource;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredAddStepHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class CacheConfigOperationHandlers {
    static final OperationStepHandler CONTAINER_CONFIGURATIONS_ADD = new ReloadRequiredAddStepHandler(new AttributeDefinition[0]);
    static final OperationStepHandler CONTAINER_SECURITY_ADD = new ReloadRequiredAddStepHandler(new AttributeDefinition[0]);
    static final OperationStepHandler STORE_WRITE_BEHIND_ADD = new ReloadRequiredAddStepHandler(StoreWriteBehindResource.ATTRIBUTES);

    CacheConfigOperationHandlers() {
    }

    private static AttributeDefinition[] concat(AttributeDefinition[] A, AttributeDefinition[] B) {
        AttributeDefinition[] C;
        int aLen = A.length;
        int bLen = B.length;
        if (bLen > 0) {
            C = Arrays.copyOf(A, aLen + bLen);
            System.arraycopy(B, 0, C, aLen, bLen);
        } else {
            C = A;
        }
        return C;
    }

    private static class RestCacheStoreAdd
    extends AbstractCacheStoreAdd {
        RestCacheStoreAdd() {
            super(RestStoreConfigurationResource.REST_STORE_ATTRIBUTES);
        }
    }

    private static class RocksDBCacheStoreAdd
    extends AbstractCacheStoreAdd {
        RocksDBCacheStoreAdd() {
            super(RocksDBStoreConfigurationResource.ROCKSDB_STORE_ATTRIBUTES);
        }
    }

    private static class RemoteCacheStoreAdd
    extends AbstractCacheStoreAdd {
        RemoteCacheStoreAdd() {
            super(RemoteStoreConfigurationResource.REMOTE_STORE_ATTRIBUTES);
        }
    }

    private static class StringKeyedJDBCCacheStoreAdd
    extends JDBCCacheStoreAdd {
        private final AttributeDefinition[] additionalAttributes = StringKeyedJDBCStoreResource.ATTRIBUTES;

        StringKeyedJDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateSubclassModel(context, operation, model);
            for (AttributeDefinition attribute : this.additionalAttributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class JDBCCacheStoreAdd
    extends AbstractCacheStoreAdd {
        JDBCCacheStoreAdd() {
            super(BaseJDBCStoreConfigurationResource.COMMON_JDBC_STORE_ATTRIBUTES);
        }
    }

    private static class FileCacheStoreAdd
    extends AbstractCacheStoreAdd {
        FileCacheStoreAdd() {
            super(FileStoreResource.ATTRIBUTES);
        }
    }

    private static class CacheStoreAdd
    extends AbstractCacheStoreAdd {
        CacheStoreAdd() {
            super(StoreConfigurationResource.STORE_ATTRIBUTES);
        }
    }

    static abstract class AbstractCacheStoreAdd
    extends AbstractCacheLoaderAdd {
        AbstractCacheStoreAdd() {
            super(BaseStoreConfigurationResource.BASE_STORE_PARAMETERS);
        }

        AbstractCacheStoreAdd(AttributeDefinition[] attributes) {
            super(CacheConfigOperationHandlers.concat(BaseStoreConfigurationResource.BASE_STORE_PARAMETERS, attributes));
        }
    }

    private static class ClusterCacheLoaderAdd
    extends AbstractCacheLoaderAdd {
        ClusterCacheLoaderAdd() {
            super(ClusterLoaderConfigurationResource.ATTRIBUTES, true);
        }
    }

    private static class CacheLoaderAdd
    extends AbstractCacheLoaderAdd {
        CacheLoaderAdd() {
            super(LoaderConfigurationResource.LOADER_ATTRIBUTES, true);
        }
    }

    static abstract class AbstractCacheLoaderAdd
    extends AbstractAddStepHandler {
        protected final AttributeDefinition[] attributes;

        AbstractCacheLoaderAdd(AttributeDefinition[] attributes) {
            this(attributes, false);
        }

        AbstractCacheLoaderAdd(AttributeDefinition[] attributes, boolean includeCommonLoaderAttributes) {
            this.attributes = includeCommonLoaderAttributes ? CacheConfigOperationHandlers.concat(BaseLoaderConfigurationResource.BASE_LOADER_PARAMETERS, attributes) : attributes;
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            ModelNode model = resource.getModel();
            for (AttributeDefinition attribute : this.attributes) {
                if (attribute.getName().equals(BaseStoreConfigurationResource.PROPERTIES.getName())) continue;
                attribute.validateAndSet(operation, model);
            }
            this.populateSubclassModel(context, operation, model);
            if (operation.hasDefined("properties")) {
                for (ModelNode node : operation.get("properties").asList()) {
                    for (Property property : node.asPropertyList()) {
                        Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"property", (String)property.getName())}));
                        ModelNode value = property.getValue();
                        if (!value.isDefined()) {
                            throw InfinispanMessages.MESSAGES.propertyValueNotDefined(property.getName());
                        }
                        ModelNode holder = new ModelNode();
                        holder.get(LoaderPropertyResource.VALUE.getName()).set(value);
                        LoaderPropertyResource.VALUE.validateAndSet(holder, param.getModel());
                    }
                }
            }
        }

        void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }

        protected void populateModel(ModelNode operation, ModelNode model) {
        }
    }
}

