/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.rhq;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.server.rhq.MetricsRemappingComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ConfigurationWriteDelegate;
import org.rhq.modules.plugins.jbossas7.CreateResourceDelegate;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class IspnCacheComponent
extends MetricsRemappingComponent<IspnCacheComponent>
implements CreateChildResourceFacet {
    static final String FLAVOR = "_flavor";

    public AvailabilityType getAvailability() {
        ReadAttribute op = new ReadAttribute(this.getAddress(), "cache-status");
        Result res = this.getASConnection().execute((Operation)op);
        if (res != null && res.isSuccess() && "RUNNING".equals(res.getResult())) {
            return AvailabilityType.UP;
        }
        return AvailabilityType.DOWN;
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        ConfigurationDefinition configDef;
        if (report.getPluginConfiguration().getSimpleValue("path").contains("jdbc")) {
            ASConnection connection = this.getASConnection();
            configDef = report.getResourceType().getResourceConfigurationDefinition();
            CreateResourceDelegate delegate = new CreateResourceDelegate(configDef, connection, this.getAddress()){

                protected Map<String, Object> prepareSimplePropertyMap(PropertyMap property, PropertyDefinitionMap propertyDefinition) {
                    Map memberDefinitions = propertyDefinition.getMap();
                    HashMap<String, Object> results = new HashMap<String, Object>();
                    for (String name : memberDefinitions.keySet()) {
                        PropertyDefinition memberDefinition = (PropertyDefinition)memberDefinitions.get(name);
                        if (memberDefinition instanceof PropertyDefinitionSimple) {
                            PropertyDefinitionSimple pds = (PropertyDefinitionSimple)memberDefinition;
                            PropertySimple ps = (PropertySimple)property.get(name);
                            if ((ps == null || ps.getStringValue() == null) && !pds.isRequired() || ps == null) continue;
                            results.put(name, ps.getStringValue());
                            continue;
                        }
                        if (memberDefinition instanceof PropertyDefinitionMap) {
                            PropertyDefinitionMap pdm = (PropertyDefinitionMap)memberDefinition;
                            PropertyMap pm = (PropertyMap)property.get(name);
                            if ((pm == null || pm.getMap().isEmpty()) && !pdm.isRequired() || pm == null) continue;
                            Map<String, Object> innerMap = this.prepareSimplePropertyMap(pm, pdm);
                            results.put(name, innerMap);
                            continue;
                        }
                        IspnCacheComponent.this.log.error((Object)(" *** not yet supported *** : " + memberDefinition.getName()));
                    }
                    return results;
                }
            };
            report = delegate.createResource(report);
        } else {
            report = super.createResource(report);
        }
        if (report.getStatus() == CreateResourceStatus.SUCCESS) {
            ConfigurationUpdateReport updateReport = new ConfigurationUpdateReport(report.getResourceConfiguration());
            configDef = report.getResourceType().getResourceConfigurationDefinition();
            Address address = new Address(this.getAddress());
            address.add(report.getPluginConfiguration().getSimpleValue("path"), report.getUserSpecifiedResourceName());
            ConfigurationWriteDelegate delegate = new ConfigurationWriteDelegate(configDef, this.getASConnection(), address);
            delegate.updateResourceConfiguration(updateReport);
            if (updateReport.getStatus() != ConfigurationUpdateStatus.SUCCESS) {
                report.setErrorMessage(updateReport.getErrorMessage());
                report.setStatus(CreateResourceStatus.FAILURE);
            }
        }
        return report;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Set<MeasurementScheduleRequest> requests = metrics;
        HashSet<MeasurementScheduleRequest> todo = new HashSet<MeasurementScheduleRequest>();
        for (MeasurementScheduleRequest req : requests) {
            if (req.getName().equals("__flavor")) {
                String flavor = this.getCacheFlavorFromPath();
                MeasurementDataTrait trait = new MeasurementDataTrait(req, flavor);
                report.addData(trait);
                continue;
            }
            todo.add(req);
        }
        super.getValues(report, todo);
    }

    private String getCacheFlavorFromPath() {
        String flavor = this.getPath().substring(this.getPath().lastIndexOf(",") + 1);
        flavor = flavor.substring(0, flavor.indexOf("="));
        return flavor;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = super.loadResourceConfiguration();
        String f = this.getCacheFlavorFromPath();
        PropertySimple flavor = new PropertySimple(FLAVOR, (Object)f);
        config.put((Property)flavor);
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        report.getConfiguration().remove(FLAVOR);
        super.updateResourceConfiguration(report);
    }
}

