/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.remoting;

import java.security.Permission;
import org.jboss.remoting3.Connection;

public class RemotingContext {
    private static final RuntimePermission SET_CONNECTION_PERMISSION = new RuntimePermission("org.jboss.as.security.remoting.SET_CONNECTION");
    private static final RuntimePermission CLEAR_CONNECTION_PERMISSION = new RuntimePermission("org.jboss.as.security.remoting.CLEAR_CONNECTION");
    private static final RuntimePermission GET_CONNECTION_PERMISSION = new RuntimePermission("org.jboss.as.security.remoting.GET_CONNECTION");
    private static final RuntimePermission IS_SET_PERMISSION = new RuntimePermission("org.jboss.as.security.remoting.IS_CONNECTION_SET");
    private static ThreadLocal<Connection> connection = new ThreadLocal();

    public static void setConnection(Connection connection) {
        RemotingContext.checkPermission(SET_CONNECTION_PERMISSION);
        RemotingContext.connection.set(connection);
    }

    public static void clear() {
        RemotingContext.checkPermission(CLEAR_CONNECTION_PERMISSION);
        connection.set(null);
    }

    public static Connection getConnection() {
        RemotingContext.checkPermission(GET_CONNECTION_PERMISSION);
        return connection.get();
    }

    public static boolean isSet() {
        RemotingContext.checkPermission(IS_SET_PERMISSION);
        return connection.get() != null;
    }

    private static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }
}

