/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerConfigurationsResource;
import org.jboss.as.clustering.infinispan.subsystem.ServerLocalConfigurationStorage;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class StandaloneServerLocalConfigurationStorage
implements ServerLocalConfigurationStorage {
    private static final String[] CACHE_MODES = new String[]{"local-cache", "invalidation-cache", "replicated-cache", "distributed-cache", "scattered-cache"};
    private ModelControllerClient modelControllerClient;
    private PathAddress rootPath;

    public void initialize(EmbeddedCacheManager embeddedCacheManager, ConfigurationManager configurationManager, Executor executor) {
    }

    public void validateFlags(EnumSet<CacheContainerAdmin.AdminFlag> flags) {
    }

    public CompletableFuture<Void> createCache(String name, String template, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        if (!flags.contains(CacheContainerAdmin.AdminFlag.PERMANENT)) {
            throw InfinispanMessages.MESSAGES.cannotCreateNonPermamentCache(name);
        }
        if (template == null) {
            throw InfinispanMessages.MESSAGES.nonExistingTemplate(name, template);
        }
        String cacheMode = this.findCacheMode(template, true);
        if (cacheMode == null) {
            throw InfinispanMessages.MESSAGES.nonExistingTemplate(name, template);
        }
        ModelNode cacheAddOp = new ModelNode();
        cacheAddOp.get("operation").set("add");
        cacheAddOp.get("address").set(this.rootPath.append(cacheMode, name).toModelNode());
        cacheAddOp.get("configuration").set(template);
        try {
            ModelNode resp = this.modelControllerClient.execute(cacheAddOp);
            if (!"success".equals(resp.get("outcome").asString())) {
                throw InfinispanMessages.MESSAGES.cannotCreateCache(null, name);
            }
        }
        catch (IOException e) {
            throw InfinispanMessages.MESSAGES.cannotCreateCache(e, name);
        }
        return CompletableFutures.completedNull();
    }

    public CompletableFuture<Void> removeCache(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        String cacheMode = this.findCacheMode(name, false);
        if (cacheMode == null) {
            throw InfinispanMessages.MESSAGES.nonExistingCache(name);
        }
        ModelNode cacheRemoveOp = new ModelNode();
        cacheRemoveOp.get("operation").set("remove");
        cacheRemoveOp.get("address").set(this.rootPath.append(cacheMode, name).toModelNode());
        try {
            ModelNode resp = this.modelControllerClient.execute(cacheRemoveOp);
            if (!"success".equals(resp.get("outcome").asString())) {
                throw InfinispanMessages.MESSAGES.cannotRemoveCache(null, name);
            }
        }
        catch (IOException e) {
            throw InfinispanMessages.MESSAGES.cannotRemoveCache(e, name);
        }
        return CompletableFutures.completedNull();
    }

    private String findCacheMode(String name, boolean configuration) {
        for (String cacheMode : CACHE_MODES) {
            PathAddress address = this.rootPath;
            address = configuration ? address.append(new PathElement[]{CacheContainerConfigurationsResource.PATH}).append(cacheMode + "-configuration", name) : address.append(cacheMode, name);
            ModelNode op = new ModelNode();
            op.get("operation").set("read-attribute");
            op.get("address").set(address.toModelNode());
            op.get("name").set(configuration ? "template" : "configuration");
            try {
                ModelNode resp = this.modelControllerClient.execute(op);
                if (!"success".equals(resp.get("outcome").asString())) continue;
                return cacheMode;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Map<String, Configuration> loadAll() {
        return Collections.emptyMap();
    }

    @Override
    public void setRootPath(PathAddress rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public void setModelControllerClient(ModelControllerClient modelControllerClient) {
        this.modelControllerClient = modelControllerClient;
    }
}

